/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;

public abstract class BundleDescriptor
extends RootDeploymentDescriptor
implements Roles {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BundleDescriptor.class);
    private static final String DEPLOYMENT_DESCRIPTOR_DIR = "META-INF";
    private static final String WSDL_DIR = "wsdl";
    private Application application;
    private Set roles;
    private Set messageDestinations = new HashSet();
    private WebServicesDescriptor webServices = new WebServicesDescriptor();
    private ModuleDescriptor moduleDescriptor;

    public BundleDescriptor() {
        this.webServices.setBundleDescriptor(this);
    }

    public BundleDescriptor(String name, String description) {
        super(name, description);
        this.webServices.setBundleDescriptor(this);
    }

    public void setApplication(Application a) {
        if (this.application != null) {
            this.removeNotificationListener(this.application);
        }
        this.application = a;
        if (this.application != null) {
            this.addNotificationListener(this.application);
        }
    }

    void addBundleDescriptor(BundleDescriptor bundleDescriptor) {
        this.getRoles().addAll(bundleDescriptor.getRoles());
        this.changed();
    }

    public boolean isApplication() {
        return false;
    }

    public Application getApplication() {
        return this.application;
    }

    public abstract Set getServiceReferenceDescriptors();

    public WebServicesDescriptor getWebServices() {
        return this.webServices;
    }

    public WebServiceEndpoint getWebServiceEndpointByName(String name) {
        return this.webServices.getEndpointByName(name);
    }

    public boolean hasWebServiceClients() {
        return false;
    }

    public boolean hasWebServices() {
        return this.getWebServices().hasWebServices();
    }

    public Set getMessageDestinations() {
        if (this.messageDestinations == null) {
            this.messageDestinations = new HashSet();
        }
        return this.messageDestinations;
    }

    public boolean hasMessageDestinationByName(String name) {
        Iterator itr = this.getMessageDestinations().iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public MessageDestinationDescriptor getMessageDestinationByName(String name) {
        Iterator itr = this.getMessageDestinations().iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return (MessageDestinationDescriptor)next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionmessagedestbundle", "Referencing error: this bundle has no message destination of name: {0}", new Object[]{name}));
    }

    public void addMessageDestination(MessageDestinationDescriptor messageDestination) {
        messageDestination.setBundleDescriptor(this);
        this.getMessageDestinations().add(messageDestination);
        super.changed();
    }

    public void removeMessageDestination(MessageDestinationDescriptor msgDest) {
        msgDest.setBundleDescriptor(null);
        this.getMessageDestinations().remove(msgDest);
        super.changed();
    }

    public Set getRoles() {
        if (this.roles == null) {
            this.roles = new OrderedSet();
        }
        if (this.application != null) {
            this.roles.addAll(this.application.getAppRoles());
        }
        return this.roles;
    }

    public void addRole(Role role) {
        this.getRoles().add(role);
        this.changed();
    }

    public void addRole(SecurityRoleDescriptor descriptor) {
        Role role = new Role(descriptor.getName());
        role.setDescription(descriptor.getDescription());
        this.addRole(role);
    }

    public void removeRole(Role role) {
        this.getRoles().remove(role);
        this.changed();
    }

    protected Collection getNamedDescriptorsFrom(JndiNameEnvironment nameEnvironment) {
        Vector<EnvironmentProperty> namedDescriptors = new Vector<EnvironmentProperty>();
        Iterator itr = nameEnvironment.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor resourceReference = (ResourceReferenceDescriptor)itr.next();
            namedDescriptors.add(resourceReference);
        }
        itr = nameEnvironment.getEjbReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            EjbReferenceDescriptor ejbReference = (EjbReferenceDescriptor)itr.next();
            namedDescriptors.add(ejbReference);
        }
        itr = nameEnvironment.getJmsDestinationReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            JmsDestinationReferenceDescriptor resourceEnvRef = (JmsDestinationReferenceDescriptor)itr.next();
            namedDescriptors.add(resourceEnvRef);
        }
        return namedDescriptors;
    }

    protected Vector getNamedReferencePairsFrom(JndiNameEnvironment nameEnvironment) {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        Iterator itr = nameEnvironment.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor resourceReference = (ResourceReferenceDescriptor)itr.next();
            pairs.add(NamedReferencePair.createResourceRefPair((Descriptor)((Object)nameEnvironment), resourceReference));
        }
        itr = nameEnvironment.getEjbReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            EjbReferenceDescriptor ejbReference = (EjbReferenceDescriptor)itr.next();
            pairs.add(NamedReferencePair.createEjbRefPair((Descriptor)((Object)nameEnvironment), ejbReference));
        }
        itr = nameEnvironment.getJmsDestinationReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            JmsDestinationReferenceDescriptor resourceEnvRef = (JmsDestinationReferenceDescriptor)itr.next();
            pairs.add(NamedReferencePair.createResourceEnvRefPair((Descriptor)((Object)nameEnvironment), resourceEnvRef));
        }
        return pairs;
    }

    public ModuleDescriptor getModuleDescriptor() {
        if (this.moduleDescriptor == null) {
            this.moduleDescriptor = new ModuleDescriptor();
            this.moduleDescriptor.setModuleType(this.getModuleType());
            this.moduleDescriptor.setDescriptor(this);
        }
        return this.moduleDescriptor;
    }

    public void setModuleDescriptor(ModuleDescriptor descriptor) {
        this.moduleDescriptor = descriptor;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.application != null) {
            return this.application.getClassLoader();
        }
        throw new RuntimeException("No class loader associated with this module " + this.getName());
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("\n");
        super.print(toStringBuffer);
        toStringBuffer.append("\n Roles[] = ").append(this.roles);
        if (this.getWebServices().hasWebServices()) {
            toStringBuffer.append("\n WebServices ");
            ((Descriptor)this.getWebServices()).print(toStringBuffer);
        }
    }

    public abstract ModuleType getModuleType();

    public String getModuleID() {
        if (this.moduleID == null) {
            this.moduleID = this.getModuleDescriptor().getArchiveUri();
        }
        if (this.getModuleDescriptor().isStandalone()) {
            return this.moduleID;
        }
        if (this.application != null) {
            if (this.application.getModuleID() == null) {
                return this.getDisplayName();
            }
            return this.application.getModuleID() + "#" + this.moduleID;
        }
        return this.moduleID;
    }

    public String getDeploymentDescriptorDir() {
        return DEPLOYMENT_DESCRIPTOR_DIR;
    }

    public String getWsdlDir() {
        return this.getDeploymentDescriptorDir() + "/" + WSDL_DIR;
    }
}

