/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.deployment.types.RoleMappingContainer;
import com.sun.enterprise.deployment.util.AppClientVisitor;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.ConnectorVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DescriptorVisitor;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.LogDomains;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;

public class Application
extends RootDeploymentDescriptor
implements NotificationListener,
Roles,
RoleMappingContainer {
    private Set modules = new HashSet();
    private long uniqueId;
    private boolean virtual = false;
    private Boolean passByReference = null;
    private Hashtable cmpDescriptors = null;
    private boolean isDirty;
    private SecurityRoleMapper roleMapper;
    private String registrationName;
    private String realm;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Application.class);
    private Set appRoles;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public Application(String name, File jar) {
        super(name, localStrings.getLocalString("enterprise.deployment.application.description", "Application description"));
    }

    public Application() {
        super("", localStrings.getLocalString("enterprise.deployment.application.description", "Application description"));
    }

    public static Application createApplication(String name, ModuleDescriptor newModule) {
        Application application = new Application();
        application.setVirtual(true);
        if (name == null && newModule.getDescriptor() != null) {
            name = newModule.getDescriptor().getDisplayName();
        }
        if (name != null) {
            application.setDisplayName(name);
            application.setName(name);
        }
        newModule.setStandalone(true);
        newModule.setArchiveUri(name);
        if (newModule.getDescriptor() != null) {
            newModule.getDescriptor().setApplication(application);
        }
        application.addModule(newModule);
        return application;
    }

    public void setRegistrationName(String appId) {
        SecurityRoleMapper roleMapper = null;
        try {
            roleMapper = this.getRoleMapper();
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        if (roleMapper != null) {
            SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryMgr.getFactory();
            if (factory == null) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.norolemapperfactorydefine", "This application has no role mapper factory defined"));
            }
            factory.removeRoleMapper(this.getName());
            roleMapper.setName(appId);
            factory.setRoleMapper(appId, roleMapper);
        }
        this.registrationName = appId;
    }

    public String getRegistrationName() {
        if (this.registrationName != null) {
            return this.registrationName;
        }
        return this.getName();
    }

    public Set getRoles() {
        HashSet roles = new HashSet();
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            if (wbd == null) continue;
            roles.addAll(wbd.getRoles());
        }
        itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
            if (ejbd == null) continue;
            roles.addAll(ejbd.getRoles());
        }
        return roles;
    }

    public Set getAppRoles() {
        if (this.appRoles == null) {
            this.appRoles = new OrderedSet();
        }
        return this.appRoles;
    }

    public void addAppRole(SecurityRoleDescriptor descriptor) {
        Role role = new Role(descriptor.getName());
        role.setDescription(descriptor.getDescription());
        this.getAppRoles().add(role);
    }

    public void addRole(Role role) {
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            wbd.addRole(role);
        }
        itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
            ejbd.addRole(role);
        }
        this.changed();
    }

    public void removeRole(Role role) {
        this.getAppRoles().remove(role);
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            wbd.removeRole(role);
        }
        itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
            ejbd.removeRole(role);
        }
        this.changed();
    }

    public Set getResourceReferenceDescriptors() {
        HashSet resourceReferences = new HashSet();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
            resourceReferences.addAll(ejbd.getResourceReferenceDescriptors());
        }
        return resourceReferences;
    }

    public void setName(String name) {
        name = name.replace('/', '-');
        name = name.replace('\\', '-');
        this.setDirty(true);
        super.setName(name);
        this.getRoleMapper().setName(name);
    }

    public void setDescription(String description) {
        this.setDirty(true);
        super.setDescription(description);
    }

    public void setLargeIconUri(String largeIconUri) {
        this.setDirty(true);
        super.setLargeIconUri(largeIconUri);
    }

    public void setSmallIconUri(String smallIconUri) {
        this.setDirty(true);
        super.setSmallIconUri(smallIconUri);
    }

    public int getWebComponentCount() {
        int count = 0;
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            count += wbd.getWebDescriptors().size();
        }
        return count;
    }

    public void removeModule(ModuleDescriptor descriptor) {
        if (this.modules.contains(descriptor)) {
            if (descriptor.getDescriptor() != null) {
                descriptor.getDescriptor().removeNotificationListener(this);
                descriptor.getDescriptor().setApplication(null);
            }
            this.modules.remove(descriptor);
            this.changed(true);
        }
    }

    public void addModule(ModuleDescriptor descriptor) {
        this.modules.add(descriptor);
        if (descriptor.getDescriptor() != null) {
            descriptor.getDescriptor().addNotificationListener(this);
            descriptor.getDescriptor().setApplication(this);
        }
        this.changed(true);
    }

    public Iterator getModules() {
        return this.modules.iterator();
    }

    public Iterator getModulesByType(ModuleType type) {
        if (type == null) {
            return null;
        }
        HashSet<ModuleDescriptor> moduleSet = new HashSet<ModuleDescriptor>();
        Iterator bundles = this.getModules();
        while (bundles.hasNext()) {
            ModuleDescriptor aModule = (ModuleDescriptor)bundles.next();
            if (!type.equals(aModule.getModuleType())) continue;
            moduleSet.add(aModule);
        }
        return moduleSet.iterator();
    }

    public void addDescriptor(Object descriptor) {
        if (descriptor instanceof EjbBundleDescriptor) {
            this.addEjbBundleDescriptor((EjbBundleDescriptor)descriptor);
        }
        if (descriptor instanceof WebBundleDescriptor) {
            this.addWebBundleDescriptor((WebBundleDescriptor)descriptor);
        }
        if (descriptor instanceof ConnectorDescriptor) {
            this.addRarDescriptor((ConnectorDescriptor)descriptor);
        }
    }

    public int getEjbComponentCount() {
        int count = 0;
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
            count += ejbd.getEjbs().size();
        }
        return count;
    }

    public int getRarComponentCount() {
        return this.getRarDescriptors().size();
    }

    public Vector getEjbReferenceDescriptors() {
        Vector ejbReferenceDescriptors = new Vector();
        Iterator itr = this.getNamedDescriptors().iterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            if (!(next instanceof EjbReferenceDescriptor)) continue;
            ejbReferenceDescriptors.addElement(next);
        }
        return ejbReferenceDescriptors;
    }

    public EjbBundleDescriptor getEjbBundleByName(String name) {
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            if (!ejbBundleDescriptor.getDisplayName().equals(name)) continue;
            return ejbBundleDescriptor;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbjarnamed", "This application has no ejb jars of name {0}", new Object[]{name}));
    }

    public BundleDescriptor getRelativeBundle(BundleDescriptor origin, String relativeTargetUri) {
        String targetBundleUri = null;
        BundleDescriptor targetBundle = null;
        try {
            String archiveUri = origin.getModuleDescriptor().getArchiveUri();
            URI originUri = new URI(archiveUri);
            URI resolvedUri = originUri.resolve(relativeTargetUri);
            targetBundleUri = resolvedUri.getPath();
        }
        catch (URISyntaxException use) {
            _logger.log(Level.FINE, "origin " + origin + " has invalid syntax", use);
        }
        if (targetBundleUri != null) {
            Descriptor module = this.getModuleByUri(targetBundleUri);
            targetBundle = module instanceof BundleDescriptor ? (BundleDescriptor)module : null;
        }
        return targetBundle;
    }

    public String getRelativeUri(BundleDescriptor origin, BundleDescriptor target) {
        String originUri = origin.getModuleDescriptor().getArchiveUri();
        String targetUri = target.getModuleDescriptor().getArchiveUri();
        StringTokenizer tokenizer = new StringTokenizer(originUri, "/");
        int numTokens = tokenizer.countTokens();
        int numSeparators = numTokens > 0 ? numTokens - 1 : 0;
        StringBuffer relativeUri = new StringBuffer();
        for (int i = 0; i < numSeparators; ++i) {
            relativeUri.append("../");
        }
        relativeUri.append(targetUri);
        return relativeUri.toString();
    }

    public EjbBundleDescriptor getEjbBundleByUri(String name) {
        Descriptor desc = this.getModuleByTypeAndUri(ModuleType.EJB, name);
        if (desc != null && desc instanceof EjbBundleDescriptor) {
            return (EjbBundleDescriptor)desc;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbjarnamed", "This application has no ejb jars of name {0}", new Object[]{name}));
    }

    public ModuleDescriptor getModuleDescriptorByUri(String uri) {
        Iterator itr = this.getModules();
        while (itr.hasNext()) {
            ModuleDescriptor aModule = (ModuleDescriptor)itr.next();
            if (!aModule.getArchiveUri().equals(uri)) continue;
            return aModule;
        }
        return null;
    }

    public Descriptor getModuleByUri(String uri) {
        ModuleDescriptor md = this.getModuleDescriptorByUri(uri);
        if (md != null) {
            return md.getDescriptor();
        }
        return null;
    }

    public Descriptor getModuleByTypeAndUri(ModuleType type, String uri) {
        Iterator itr = this.getModules();
        while (itr.hasNext()) {
            ModuleDescriptor aModule = (ModuleDescriptor)itr.next();
            if (!aModule.getModuleType().equals(type) || !aModule.getArchiveUri().equals(uri)) continue;
            return aModule.getDescriptor();
        }
        return null;
    }

    public EjbDescriptor getEjbByName(String ejbName) {
        Object ejbDescriptor = null;
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            if (!ejbBundleDescriptor.hasEjbByName(ejbName)) continue;
            return ejbBundleDescriptor.getEjbByName(ejbName);
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnobeannamed", "This application has no beans of name {0}", new Object[]{ejbName}));
    }

    public boolean hasEjbByName(String ejbName) {
        Object ejbDescriptor = null;
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            if (!ejbBundleDescriptor.hasEjbByName(ejbName)) continue;
            return true;
        }
        return false;
    }

    public ApplicationClientDescriptor getApplicationClientByName(String name) {
        Iterator itr = this.getApplicationClientDescriptors().iterator();
        while (itr.hasNext()) {
            ApplicationClientDescriptor next = (ApplicationClientDescriptor)itr.next();
            if (!next.getDisplayName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoappclientname", "This application has no application clients of name {0}", new Object[]{name}));
    }

    public ApplicationClientDescriptor getApplicationClientByUri(String name) {
        Descriptor desc = this.getModuleByTypeAndUri(ModuleType.CAR, name);
        if (desc != null && desc instanceof ApplicationClientDescriptor) {
            return (ApplicationClientDescriptor)desc;
        }
        throw new IllegalArgumentException(name);
    }

    public WebBundleDescriptor getWebBundleDescriptorByName(String name) {
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor next = (WebBundleDescriptor)itr.next();
            if (!next.getDisplayName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", new Object[]{name}));
    }

    public WebBundleDescriptor getWebBundleDescriptorByUri(String name) {
        Descriptor desc = this.getModuleByTypeAndUri(ModuleType.WAR, name);
        if (desc != null && desc instanceof WebBundleDescriptor) {
            return (WebBundleDescriptor)desc;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", new Object[]{name}));
    }

    public ConnectorDescriptor getRarDescriptorByUri(String name) {
        Descriptor desc = this.getModuleByTypeAndUri(ModuleType.RAR, name);
        if (desc != null && desc instanceof ConnectorDescriptor) {
            return (ConnectorDescriptor)desc;
        }
        throw new IllegalArgumentException(name);
    }

    public Set getJndiNameEnvironments() {
        HashSet jndiNameEnvironments = new HashSet();
        jndiNameEnvironments.addAll(this.getWebBundleDescriptors());
        jndiNameEnvironments.addAll(this.getApplicationClientDescriptors());
        jndiNameEnvironments.addAll(this.getEjbDescriptors());
        return jndiNameEnvironments;
    }

    public Set getServiceReferenceDescriptors() {
        HashSet serviceRefs = new HashSet();
        Set jndiNameEnvironments = this.getJndiNameEnvironments();
        Iterator iter = jndiNameEnvironments.iterator();
        while (iter.hasNext()) {
            JndiNameEnvironment next = (JndiNameEnvironment)iter.next();
            serviceRefs.addAll(next.getServiceReferenceDescriptors());
        }
        return serviceRefs;
    }

    public Set getWebServiceDescriptors() {
        HashSet webServiceDescriptors = new HashSet();
        HashSet bundles = new HashSet();
        bundles.addAll(this.getEjbBundleDescriptors());
        bundles.addAll(this.getWebBundleDescriptors());
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            BundleDescriptor next = (BundleDescriptor)iter.next();
            WebServicesDescriptor webServicesDesc = next.getWebServices();
            webServiceDescriptors.addAll(webServicesDesc.getWebServices());
        }
        return webServiceDescriptors;
    }

    public Set getWebBundleDescriptors() {
        return this.getBundleDescriptors(ModuleType.WAR);
    }

    public BundleDescriptor getStandaloneBundleDescriptor() {
        if (this.isVirtual()) {
            Iterator modules = this.getModules();
            if (modules.hasNext()) {
                ModuleDescriptor module = (ModuleDescriptor)modules.next();
                if (modules.hasNext()) {
                    throw new IllegalStateException("Virtual application contains more than one module");
                }
                return module.getDescriptor();
            }
            return null;
        }
        return null;
    }

    public Set getBundleDescriptors(ModuleType type) {
        if (type == null) {
            return null;
        }
        HashSet<BundleDescriptor> bundleSet = new HashSet<BundleDescriptor>();
        Iterator bundles = this.getModules();
        while (bundles.hasNext()) {
            ModuleDescriptor aModule = (ModuleDescriptor)bundles.next();
            if (!type.equals(aModule.getModuleType())) continue;
            if (aModule.getDescriptor() != null) {
                bundleSet.add(aModule.getDescriptor());
                continue;
            }
            DOLUtils.getDefaultLogger().fine("Null descriptor for module " + aModule.getArchiveUri());
        }
        return bundleSet;
    }

    public Set getBundleDescriptors() {
        HashSet<BundleDescriptor> bundleSet = new HashSet<BundleDescriptor>();
        Iterator bundles = this.getModules();
        while (bundles.hasNext()) {
            ModuleDescriptor aModule = (ModuleDescriptor)bundles.next();
            if (aModule.getDescriptor() != null) {
                bundleSet.add(aModule.getDescriptor());
                continue;
            }
            DOLUtils.getDefaultLogger().fine("Null descriptor for module " + aModule.getArchiveUri());
        }
        return bundleSet;
    }

    public void addWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        this.addBundleDescriptor(webBundleDescriptor);
    }

    private void addBundleDescriptor(BundleDescriptor bundleDescriptor) {
        ModuleDescriptor newModule = bundleDescriptor.getModuleDescriptor();
        this.addModule(newModule);
    }

    public void removeWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        webBundleDescriptor.removeNotificationListener(this);
        webBundleDescriptor.setApplication(null);
        this.getWebBundleDescriptors().remove(webBundleDescriptor);
        this.changed(true);
    }

    public Set getRarDescriptors() {
        return this.getBundleDescriptors(ModuleType.RAR);
    }

    public void addRarDescriptor(ConnectorDescriptor rarDescriptor) {
        this.addBundleDescriptor(rarDescriptor);
    }

    public void removeRarDescriptor(ConnectorDescriptor rarDescriptor) {
        rarDescriptor.removeNotificationListener(this);
        rarDescriptor.setApplication(null);
        this.getRarDescriptors().remove(rarDescriptor);
        this.changed(true);
    }

    public Set getEjbBundleDescriptors() {
        return this.getBundleDescriptors(ModuleType.EJB);
    }

    public void addEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        this.addBundleDescriptor(ejbBundleDescriptor);
    }

    public void removeEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        this.getEjbBundleDescriptors().remove(ejbBundleDescriptor);
        ejbBundleDescriptor.removeNotificationListener(this);
        ejbBundleDescriptor.setApplication(null);
        this.changed(true);
    }

    public Set getApplicationClientDescriptors() {
        return this.getBundleDescriptors(ModuleType.CAR);
    }

    public void addApplicationClientDescriptor(ApplicationClientDescriptor applicationClientDescriptor) {
        this.addBundleDescriptor(applicationClientDescriptor);
    }

    public void removeApplicationClientDescriptor(ApplicationClientDescriptor applicationClientDescriptor) {
        this.getApplicationClientDescriptors().remove(applicationClientDescriptor);
        applicationClientDescriptor.removeNotificationListener(this);
        applicationClientDescriptor.setApplication(null);
        this.changed(true);
    }

    public EjbCMPEntityDescriptor getCMPDescriptorFor(String className) {
        if (this.cmpDescriptors == null) {
            this.cmpDescriptors = new Hashtable();
            Iterator ejbBundles = this.getEjbBundleDescriptors().iterator();
            while (ejbBundles.hasNext()) {
                EjbBundleDescriptor bundle = (EjbBundleDescriptor)ejbBundles.next();
                Iterator ejbs = bundle.getEjbs().iterator();
                while (ejbs.hasNext()) {
                    EjbDescriptor ejb = (EjbDescriptor)ejbs.next();
                    if (!(ejb instanceof EjbCMPEntityDescriptor)) continue;
                    this.cmpDescriptors.put(ejb.getEjbImplClassName(), ejb);
                }
            }
        }
        return (EjbCMPEntityDescriptor)this.cmpDescriptors.get(className);
    }

    public Vector getNamedReferencePairs() {
        Vector pairs = new Vector();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            pairs.addAll(ejbBundleDescriptor.getNamedReferencePairs());
        }
        itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr.next();
            pairs.addAll(webBundleDescriptor.getNamedReferencePairs());
        }
        itr = this.getApplicationClientDescriptors().iterator();
        while (itr.hasNext()) {
            ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)itr.next();
            pairs.addAll(applicationClientDescriptor.getNamedReferencePairs());
        }
        return pairs;
    }

    public Collection getNamedDescriptors() {
        Vector namedDescriptors = new Vector();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            namedDescriptors.addAll(ejbBundleDescriptor.getNamedDescriptors());
        }
        itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr.next();
            namedDescriptors.addAll(webBundleDescriptor.getNamedDescriptors());
        }
        itr = this.getApplicationClientDescriptors().iterator();
        while (itr.hasNext()) {
            ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)itr.next();
            namedDescriptors.addAll(applicationClientDescriptor.getNamedDescriptors());
        }
        return namedDescriptors;
    }

    public Vector getEjbDescriptors() {
        Vector ejbDescriptors = new Vector();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            ejbDescriptors.addAll(ejbBundleDescriptor.getEjbs());
        }
        return ejbDescriptors;
    }

    public boolean containsCMPEntity() {
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            if (!((EjbBundleDescriptor)itr.next()).containsCMPEntity()) continue;
            return true;
        }
        return false;
    }

    public EjbDescriptor[] getSortedEjbDescriptors() {
        Vector ejbDesc = this.getEjbDescriptors();
        EjbDescriptor[] descs = ejbDesc.toArray(new EjbDescriptor[ejbDesc.size()]);
        Arrays.sort(descs, new Comparator(){

            public int compare(Object o1, Object o2) {
                EjbDescriptor desc1 = (EjbDescriptor)o1;
                EjbDescriptor desc2 = (EjbDescriptor)o2;
                String moduleUri1 = desc1.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                String moduleUri2 = desc2.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                return (moduleUri1 + desc1.getName()).compareTo(moduleUri2 + desc2.getName());
            }
        });
        return descs;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setUniqueId(long id) {
        _logger.log(Level.FINE, "[Application]uid: " + id);
        this.uniqueId = id;
        EjbDescriptor[] descs = this.getSortedEjbDescriptors();
        for (int i = 0; i < descs.length; ++i) {
            descs[i].setUniqueId(id | (long)i);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "[Application]desc name: " + descs[i].getName());
            _logger.log(Level.FINE, "[Application]desc id: " + descs[i].getUniqueId());
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setPassByReference(boolean passByReference) {
        this.passByReference = passByReference;
    }

    public boolean getPassByReference() {
        boolean passByReference = false;
        if (this.isPassByReferenceDefined()) {
            passByReference = this.passByReference;
        }
        return passByReference;
    }

    public boolean isPassByReferenceDefined() {
        boolean passByReferenceDefined = false;
        if (this.passByReference != null) {
            passByReferenceDefined = true;
        }
        return passByReferenceDefined;
    }

    public void addApplication(Application application) {
        Iterator itr = application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            this.addEjbBundleDescriptor(ejbBundleDescriptor);
        }
        itr = application.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr.next();
            this.addWebBundleDescriptor(webBundleDescriptor);
        }
        itr = application.getApplicationClientDescriptors().iterator();
        while (itr.hasNext()) {
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)itr.next();
            this.addApplicationClientDescriptor(acd);
        }
        itr = application.getRarDescriptors().iterator();
        while (itr.hasNext()) {
            ConnectorDescriptor rarDescriptor = (ConnectorDescriptor)itr.next();
            this.addRarDescriptor(rarDescriptor);
        }
    }

    public Set getArchivableDescriptors() {
        HashSet archivableDescriptors = new HashSet();
        archivableDescriptors.addAll(this.getEjbBundleDescriptors());
        archivableDescriptors.addAll(this.getWebBundleDescriptors());
        archivableDescriptors.addAll(this.getApplicationClientDescriptors());
        archivableDescriptors.addAll(this.getRarDescriptors());
        return archivableDescriptors;
    }

    public void setRoleMapper(SecurityRoleMapper roleMapper) {
        this.roleMapper = roleMapper;
        this.changed(true);
    }

    public boolean hasRuntimeInformation() {
        return true;
    }

    public SecurityRoleMapper getRoleMapper() {
        if (this.roleMapper == null) {
            SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryMgr.getFactory();
            if (factory == null) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.norolemapperfactorydefine", "This application has no role mapper factory defined"));
            }
            this.roleMapper = factory.getRoleMapper(this.getName());
        }
        return this.roleMapper;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void notification(NotificationEvent ne) {
        this.changed(true);
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            throw new RuntimeException("No class loader associated with application " + this.getName());
        }
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed() {
        NotificationEvent ne = new NotificationEvent(this, DESCRIPTOR_CHANGED, this);
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        Enumeration e = listenersClone.elements();
        while (e.hasMoreElements()) {
            NotificationListener nl = (NotificationListener)e.nextElement();
            nl.notification(ne);
        }
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Application");
        toStringBuffer.append("\n");
        super.print(toStringBuffer);
        toStringBuffer.append("\n smallIcon ").append(super.getSmallIconUri());
        Iterator itr = this.getModules();
        while (itr.hasNext()) {
            toStringBuffer.append("\n  Module : ");
            ((Descriptor)itr.next()).print(toStringBuffer);
        }
        toStringBuffer.append("\n EjbBundles: \n");
        if (this.getEjbBundleDescriptors() != null) {
            this.printDescriptorSet(this.getEjbBundleDescriptors(), toStringBuffer);
        }
        toStringBuffer.append("\n WebBundleDescriptors ");
        if (this.getWebBundleDescriptors() != null) {
            this.printDescriptorSet(this.getWebBundleDescriptors(), toStringBuffer);
        }
        toStringBuffer.append("\n applicationClientDescriptors ");
        if (this.getApplicationClientDescriptors() != null) {
            this.printDescriptorSet(this.getApplicationClientDescriptors(), toStringBuffer);
        }
        toStringBuffer.append("\n roles ").append(this.getRoles());
        toStringBuffer.append("\n RoleMapper ").append(this.getRoleMapper());
        toStringBuffer.append("\n Realm ").append(this.realm);
    }

    private void printDescriptorSet(Set descSet, StringBuffer sbuf) {
        Iterator itr = descSet.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj instanceof Descriptor) {
                ((Descriptor)obj).print(sbuf);
                continue;
            }
            sbuf.append(obj);
        }
    }

    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof ApplicationVisitor) {
            this.visit((ApplicationVisitor)((Object)aVisitor));
        } else {
            super.visit(aVisitor);
        }
    }

    public void visit(ApplicationVisitor aVisitor) {
        AppClientVisitor appclientVisitor;
        ConnectorVisitor connectorVisitor;
        WebBundleVisitor webVisitor;
        aVisitor.accept(this);
        EjbBundleVisitor ejbBundleVisitor = aVisitor.getEjbBundleVisitor();
        if (ejbBundleVisitor != null) {
            Iterator ejbBundles = this.getEjbBundleDescriptors().iterator();
            while (ejbBundles.hasNext()) {
                EjbBundleDescriptor anEjbBundle = (EjbBundleDescriptor)ejbBundles.next();
                anEjbBundle.visit(ejbBundleVisitor);
            }
        }
        if ((webVisitor = aVisitor.getWebBundleVisitor()) != null) {
            Iterator webBundles = this.getWebBundleDescriptors().iterator();
            while (webBundles.hasNext()) {
                WebBundleDescriptor aWebBundle = (WebBundleDescriptor)webBundles.next();
                if (aWebBundle == null) continue;
                aWebBundle.visit(webVisitor);
            }
        }
        if ((connectorVisitor = aVisitor.getConnectorVisitor()) != null) {
            Iterator connectors = this.getRarDescriptors().iterator();
            while (connectors.hasNext()) {
                ConnectorDescriptor aConnector = (ConnectorDescriptor)connectors.next();
                aConnector.visit(connectorVisitor);
            }
        }
        if ((appclientVisitor = aVisitor.getAppClientVisitor()) != null) {
            Iterator appclients = this.getApplicationClientDescriptors().iterator();
            while (appclients.hasNext()) {
                ApplicationClientDescriptor appclient = (ApplicationClientDescriptor)appclients.next();
                appclient.visit(appclientVisitor);
            }
        }
    }

    void doneSaving() {
        this.isDirty = false;
        this.changed(false);
    }

    public void doneOpening() {
        this.isDirty = false;
        this.changed(false);
    }

    private void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public boolean isApplication() {
        return true;
    }

    public void changed(boolean dirtyChange) {
        if (dirtyChange) {
            this.isDirty = true;
        }
        super.changed();
    }

    public ModuleType getModuleType() {
        return ModuleType.EAR;
    }
}

