/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployapi;

import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;

public class DeploymentFactoryInstaller {
    private static DeploymentFactoryInstaller dfInstaller = null;
    private final String J2EE_DEPLOYMENT_MANAGER_REPOSITORY = "lib" + File.separator + "deployment";
    private final String J2EE_DEPLOYMENT_MANAGER = "J2EE-DeploymentFactory-Implementation-Class";

    private DeploymentFactoryInstaller() {
    }

    public static DeploymentFactoryInstaller getInstaller() {
        if (dfInstaller == null) {
            dfInstaller = new DeploymentFactoryInstaller();
            dfInstaller.initialize();
        }
        return dfInstaller;
    }

    public File[] getListOfDeploymentFactoryFiles() {
        File repository = new File(System.getProperty("com.sun.aas.installRoot") + File.separator + this.J2EE_DEPLOYMENT_MANAGER_REPOSITORY);
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("J2EE Deployment factory repository = " + repository.getAbsolutePath());
        }
        if (!repository.exists()) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.deplyomentManagerLoadFailure", new Object[]{"Cannot find any deployment manager"});
            return null;
        }
        return repository.listFiles();
    }

    public void addDeploymentFactory(File newDM) throws IOException {
        int number = 1;
        File repository = new File(System.getProperty("com.sun.enterprise.home") + File.separator + this.J2EE_DEPLOYMENT_MANAGER_REPOSITORY);
        File to = new File(repository, newDM.getName());
        while (to.exists()) {
            to = new File(repository, newDM.getName() + number);
            ++number;
        }
        Archivist.copy(new BufferedInputStream(new FileInputStream(newDM)), new BufferedOutputStream(new FileOutputStream(to)));
        this.installDeploymentFactory(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installDeploymentFactory(File installedDM) throws IOException {
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Installing Deployment factory = " + installedDM.getAbsolutePath());
        }
        ZipFile jarFile = null;
        Manifest m = null;
        try {
            jarFile = new JarFile(installedDM);
            m = ((JarFile)jarFile).getManifest();
        }
        finally {
            jarFile.close();
            jarFile = null;
        }
        String className = m.getMainAttributes().getValue("J2EE-DeploymentFactory-Implementation-Class");
        URL[] urls = new URL[]{installedDM.toURL()};
        URLClassLoader urlClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        Class<?> factory = null;
        try {
            factory = urlClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.deplyomentManagerLoadFailure", new Object[]{"Unable to load declared DeploymentManagerFactory"});
            throw new IllegalArgumentException(className + " is not present in the " + installedDM.getName());
        }
        Object df = null;
        try {
            df = factory.newInstance();
        }
        catch (Exception ie) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.deplyomentManagerLoadFailure", new Object[]{className});
            ie.printStackTrace();
            throw new IllegalArgumentException("Cannot install " + installedDM.getName());
        }
        if (!(df instanceof DeploymentFactory)) {
            throw new IllegalArgumentException("The " + className + " declared as a DeploymentFactory does implement the DeploymentFactory interface");
        }
        DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)df);
    }

    protected void initialize() {
        File[] elligibleFiles = this.getListOfDeploymentFactoryFiles();
        if (elligibleFiles == null) {
            return;
        }
        for (int i = 0; i < elligibleFiles.length; ++i) {
            try {
                this.installDeploymentFactory(elligibleFiles[i]);
                continue;
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.deplyomentManagerLoadFailure", new Object[]{elligibleFiles[i].getName()});
            }
        }
    }
}

