/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.work.CommonWorkManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.WorkManager;

public class WorkManagerFactory {
    private static final String DEFAULT = "com.sun.enterprise.connectors.work.CommonWorkManager";
    private static final String WORK_MANAGER_CLASS = "workmanager.class";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public static WorkManager getWorkManager(String poolName) throws ConnectorRuntimeException {
        String className = null;
        String methodName = "getInstance";
        Class<?> cls = null;
        WorkManager wm = null;
        try {
            className = System.getProperty(WORK_MANAGER_CLASS, DEFAULT);
            if (className.equals(DEFAULT)) {
                return new CommonWorkManager(poolName);
            }
            cls = Class.forName(className);
            if (cls != null) {
                Method method = cls.getMethod("getInstance", new Class[0]);
                wm = (WorkManager)method.invoke(cls, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "workmanager.instantiation_error", e);
        }
        return wm;
    }
}

