/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.config.serverbeans.BackendPrincipal;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.authentication.EisBackendPrincipal;
import com.sun.enterprise.connectors.authentication.PrincipalAuthKey;
import com.sun.enterprise.deployment.ResourcePrincipal;
import java.util.HashMap;

public class SecurityMapUtils {
    private static ConnectorRegistry _registry = ConnectorRegistry.getInstance();

    public static boolean setSecurityMaps(String poolName, SecurityMap[] securityMaps) {
        HashMap<PrincipalAuthKey, ResourcePrincipal> securityMapsTable = new HashMap<PrincipalAuthKey, ResourcePrincipal>();
        boolean poolToBeRecreated = false;
        if (securityMaps == null || securityMaps.length == 0) {
            if (_registry.getSecurityMap(poolName) != null) {
                SecurityMapUtils.deleteSecurityMaps(poolName);
                return true;
            }
            return false;
        }
        for (int i = 0; i < securityMaps.length; ++i) {
            String[] principal = securityMaps[i].getPrincipal();
            ResourcePrincipal resourcePrinicipal = SecurityMapUtils.transformSecurityMap(securityMaps[i]);
            for (int j = 0; principal != null && j < principal.length; ++j) {
                PrincipalAuthKey key = SecurityMapUtils.getSecurityMapKey(null, null, principal[j], null);
                securityMapsTable.put(key, resourcePrinicipal);
            }
            String[] userGroup = securityMaps[i].getUserGroup();
            for (int j = 0; userGroup != null && j < userGroup.length; ++j) {
                PrincipalAuthKey key = SecurityMapUtils.getSecurityMapKey(null, null, null, userGroup[j]);
                securityMapsTable.put(key, resourcePrinicipal);
            }
        }
        _registry.addSecurityMap(poolName, securityMapsTable);
        poolToBeRecreated = SecurityMapUtils.isPoolToBeRecreated(poolName, securityMaps);
        SecurityMapUtils.createBackendPrincipalMapTable(poolName, securityMaps);
        return poolToBeRecreated;
    }

    private static void createBackendPrincipalMapTable(String poolName, SecurityMap[] securityMaps) {
        HashMap<String, EisBackendPrincipal> backendPrincipalMap = new HashMap<String, EisBackendPrincipal>();
        for (int i = 0; i < securityMaps.length; ++i) {
            BackendPrincipal backendprincipal = securityMaps[i].getBackendPrincipal();
            EisBackendPrincipal eisBackendPrincipal = SecurityMapUtils.getEisBackendPrincipal(securityMaps[i]);
            backendPrincipalMap.put(securityMaps[i].getName(), eisBackendPrincipal);
        }
        _registry.addBackendPrincipalMap(poolName, backendPrincipalMap);
    }

    public static void deleteSecurityMaps(String poolName) {
        _registry.removeSecurityMap(poolName);
        _registry.removeBackendPrincipalMap(poolName);
    }

    private static PrincipalAuthKey getSecurityMapKey(String rarName, String poolName, String principalName, String userGroup) {
        return new PrincipalAuthKey(rarName, poolName, principalName, userGroup);
    }

    private static ResourcePrincipal transformSecurityMap(SecurityMap securityMap) {
        BackendPrincipal backendPrincipal = securityMap.getBackendPrincipal();
        String userName = backendPrincipal.getUserName();
        String password = backendPrincipal.getPassword();
        ResourcePrincipal resPrincipal = new ResourcePrincipal(userName, password);
        return resPrincipal;
    }

    private static EisBackendPrincipal getEisBackendPrincipal(SecurityMap securityMap) {
        BackendPrincipal backendPrincipal = securityMap.getBackendPrincipal();
        String userName = backendPrincipal.getUserName();
        String password = backendPrincipal.getPassword();
        EisBackendPrincipal eisBackendPrincipal = new EisBackendPrincipal(userName, password);
        return eisBackendPrincipal;
    }

    private static boolean isPoolToBeRecreated(String poolName, SecurityMap[] securityMap) {
        HashMap backendPrincipalMap = _registry.getBackendPrincipalMap(poolName);
        if (backendPrincipalMap == null) {
            return true;
        }
        if (securityMap.length != backendPrincipalMap.size()) {
            return true;
        }
        for (int i = 0; i < securityMap.length; ++i) {
            EisBackendPrincipal inTableBackendPrincipal = (EisBackendPrincipal)backendPrincipalMap.get(securityMap[i].getName());
            if (inTableBackendPrincipal == null) {
                return true;
            }
            EisBackendPrincipal newBackendPrincipal = SecurityMapUtils.getEisBackendPrincipal(securityMap[i]);
            if (newBackendPrincipal.equals(inTableBackendPrincipal)) continue;
            return true;
        }
        return false;
    }
}

