/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.system;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.jms.IASJmsUtil;
import com.sun.enterprise.jms.JmsProviderLifecycle;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MQAdministrator {
    static Logger logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(ConnectorRuntime.class);
    private String target = null;
    private JMSAdmin jmsAdmin = null;

    public MQAdministrator() {
        this.createJmsAdmin();
    }

    public MQAdministrator(String target) throws ConnectorRuntimeException {
        this.target = target;
        this.jmsAdmin = this.getJmsAdmin(target);
    }

    private JMSAdmin getJmsAdmin(String target) throws ConnectorRuntimeException {
        try {
            if (target == null) {
                return JmsProviderLifecycle.getJMSAdmin();
            }
            JmsService js = this.getJmsService(target);
            JmsHost host = js.getJmsHostByName(js.getDefaultJmsHost());
            if (host == null || host.equals("")) {
                host = js.getJmsHost(0);
            }
            String hostName = host.getHost();
            String port = host.getPort();
            String adminUser = host.getAdminUserName();
            String adminPassword = host.getAdminPassword();
            String url = hostName + (port == null ? "" : ":" + port);
            if (adminUser == null) {
                return IASJmsUtil.getJMSAdminFactory().getJMSAdmin(url);
            }
            return IASJmsUtil.getJMSAdminFactory().getJMSAdmin(url, adminUser, adminPassword);
        }
        catch (ConnectorRuntimeException cre) {
            throw cre;
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private JmsService getJmsService(String target) throws ConnectorRuntimeException {
        JmsService js = null;
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            ConfigContext cc = sc.getConfigContext();
            Domain domain = ServerBeansFactory.getDomainBean(cc);
            Cluster cl = domain.getClusters().getClusterByName(target);
            if (cl != null) {
                String ref = cl.getConfigRef();
                Config conf = domain.getConfigs().getConfigByName(ref);
                js = conf.getJmsService();
            } else {
                Server s = domain.getServers().getServerByName(target);
                String ref = s.getConfigRef();
                Config conf = domain.getConfigs().getConfigByName(ref);
                js = conf.getJmsService();
            }
        }
        catch (Exception cre) {
            throw this.handleException(cre);
        }
        if (js != null) {
            return js;
        }
        String i18nMsg = localStrings.getString("connecor.no.jmsservice");
        throw new ConnectorRuntimeException(i18nMsg);
    }

    public JMSAdmin getJmsAdmin() {
        return this.jmsAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createPhysicalDestination(String destName, boolean isQueue) throws ConnectorRuntimeException {
        connected = false;
        try {
            this.jmsAdmin.connectToProvider();
            connected = true;
            dests = this.jmsAdmin.getProviderDestinations();
            props = new Properties();
            type = 1;
            if (isQueue) {
                props.put(IASJmsUtil.getMaxActiveConsumersProperty(), IASJmsUtil.getDefaultMaxActiveConsumers());
                type = 0;
            }
            for (i = 0; i < dests[0].length; ++i) {
                MQAdministrator.logger.fine("Destination is " + dests[0][i]);
                MQAdministrator.logger.fine("Destination type is " + dests[1][i]);
                MQAdministrator.logger.fine("New Destination is " + destName);
                MQAdministrator.logger.fine("New Destination type is " + type);
                if (!dests[0][i].equals(destName) || !dests[1][i].equals(String.valueOf(type))) continue;
                MQAdministrator.logger.log(Level.INFO, "jmservice.destination.already.autocreated", new Object[]{destName});
                var9_9 = null;
                if (connected == false) return;
                ** GOTO lbl48
            }
            this.jmsAdmin.createProviderDestination(destName, type, (Map)props);
            MQAdministrator.logger.log(Level.INFO, "jmservice.destination.autocreated", new Object[]{destName});
            ** GOTO lbl54
        }
        catch (Exception e) {
            MQAdministrator.logger.log(Level.WARNING, "jmsservice.destination.autocreatefailed", e);
            var9_11 = null;
            if (connected == false) return;
            try {
                this.jmsAdmin.disconnectFromProvider();
                return;
            }
            catch (Throwable t) {
                MQAdministrator.logger.log(Level.WARNING, "" + t.getMessage(), t);
                return;
            }
        }
        {
            catch (Throwable var8_17) {
                var9_12 = null;
                if (connected == false) throw var8_17;
                ** try [egrp 2[TRYBLOCK] [6 : 316->328)] { 
lbl43:
                // 1 sources

                this.jmsAdmin.disconnectFromProvider();
                throw var8_17;
lbl45:
                // 1 sources

                catch (Throwable t) {
                    MQAdministrator.logger.log(Level.WARNING, "" + t.getMessage(), t);
                }
                throw var8_17;
            }
lbl48:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [6 : 316->328)] { 
lbl49:
            // 1 sources

            this.jmsAdmin.disconnectFromProvider();
            return;
lbl51:
            // 1 sources

            catch (Throwable t) {
                MQAdministrator.logger.log(Level.WARNING, "" + t.getMessage(), t);
            }
            return;
lbl54:
            // 1 sources

            var9_10 = null;
            if (connected == false) return;
            try {}
            catch (Throwable t) {}
            MQAdministrator.logger.log(Level.WARNING, "" + t.getMessage(), t);
            return;
            this.jmsAdmin.disconnectFromProvider();
            return;
        }
    }

    private void createJmsAdmin() {
        try {
            ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
            JmsService jmsService_ = ServerBeansFactory.getJmsServiceBean(ctx);
            JmsHost hostBean = jmsService_.getJmsHostByName(jmsService_.getDefaultJmsHost());
            if (hostBean == null) {
                logger.log(Level.WARNING, "jmsservice.defaulthost.notconfigured");
                hostBean = jmsService_.getJmsHost(0);
            }
            String hostName = hostBean.getHost();
            String port = hostBean.getPort();
            String user = hostBean.getAdminUserName();
            String password = hostBean.getAdminPassword();
            String url = hostName + (port == null ? "" : ":" + port);
            this.jmsAdmin = user == null ? IASJmsUtil.getJMSAdminFactory().getJMSAdmin(url) : IASJmsUtil.getJMSAdminFactory().getJMSAdmin(url, user, password);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private ConnectorRuntimeException handleException(Exception e) {
        logger.log(Level.WARNING, "" + e.getMessage(), e);
        ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
        cre.initCause(e);
        return cre;
    }
}

