/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.system;

import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.connectors.system.MQUrl;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class MQAddressList {
    static Logger logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    ArrayList urlList = new ArrayList();
    JmsService jmsService = null;

    public MQAddressList(JmsService service) {
        this.jmsService = service;
    }

    public void setup() {
        JmsHost[] hosts = this.jmsService.getJmsHost();
        for (int i = 0; i < hosts.length; ++i) {
            MQUrl url = this.createUrl(hosts[i]);
            this.urlList.add(url);
        }
    }

    public String toString() {
        String s = "";
        Iterator it = this.urlList.iterator();
        while (it.hasNext()) {
            s = s + it.next().toString() + ",";
        }
        return s;
    }

    public void addMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.add(url);
    }

    public void removeMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.remove(url);
    }

    public void updateMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.remove(url);
        this.urlList.add(url);
    }

    private MQUrl createUrl(JmsHost host) {
        String name = host.getName();
        String hostName = host.getHost();
        String port = host.getPort();
        MQUrl url = new MQUrl(name);
        url.setHost(hostName);
        url.setPort(port);
        if (this.jmsService != null) {
            String service;
            String scheme = this.jmsService.getMqScheme();
            if (scheme != null && !scheme.trim().equals("")) {
                url.setScheme(scheme);
            }
            if ((service = this.jmsService.getMqService()) != null && !service.trim().equals("")) {
                url.setService(service);
            }
        }
        return url;
    }
}

