/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.authentication;

import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.authentication.PrincipalAuthKey;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicPasswordAuthenticationService
implements AuthenticationService {
    private String rarName_;
    private String poolName_;
    ConnectorRegistry connectorRegistry_ = ConnectorRegistry.getInstance();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public BasicPasswordAuthenticationService(String rarName, String poolName) {
        this.rarName_ = rarName;
        this.poolName_ = poolName;
        _logger.log(Level.FINE, "Contructor:BasicPasswordAuthenticationService");
    }

    public Principal mapPrincipal(String principalName) {
        PrincipalAuthKey key = this.getSecurityMapKey(principalName);
        return this.doMap(key);
    }

    public Principal mapUserGroup(String userGroupName) {
        PrincipalAuthKey key = this.getSecurityMapKey(userGroupName + "#");
        return this.doMap(key);
    }

    private Principal doMap(PrincipalAuthKey key) {
        HashMap principalMapTable = this.connectorRegistry_.getSecurityMap(this.poolName_);
        if (principalMapTable == null) {
            return null;
        }
        Principal mappedPrincipal = (Principal)principalMapTable.get(key);
        if (mappedPrincipal != null) {
            _logger.log(Level.FINE, "BasicPasswordAuthenticationService: Found the mapping : ", key);
            return mappedPrincipal;
        }
        _logger.log(Level.FINE, "BasicPasswordAuthenticationService: mapping not found : ", key);
        key = this.getMetaSecurityMapKey();
        _logger.log(Level.FINE, "BasicPasswordAuthenticationService:mapping for metachar *");
        return (Principal)principalMapTable.get(key);
    }

    private PrincipalAuthKey getSecurityMapKey(String principalName) {
        return new PrincipalAuthKey(null, null, principalName, null);
    }

    private PrincipalAuthKey getMetaSecurityMapKey() {
        return new PrincipalAuthKey(null, null, "*", null);
    }
}

