/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.connectors.ConnectionManagerFactory;
import com.sun.enterprise.connectors.ConnectorAdminObjectAdminServiceImpl;
import com.sun.enterprise.connectors.ConnectorAdminServicesFactory;
import com.sun.enterprise.connectors.ConnectorConfigurationParserServiceImpl;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorConnectionPoolAdminServiceImpl;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorResourceAdminServiceImpl;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorSecurityAdminServiceImpl;
import com.sun.enterprise.connectors.ConnectorServiceImpl;
import com.sun.enterprise.connectors.ResourceAdapterAdminServiceImpl;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.system.MQAdministrator;
import com.sun.enterprise.connectors.util.JmsRaMapping;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public final class ConnectorRuntime
implements ConnectorConstants {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static ConnectorRegistry _registry = null;
    private static ConnectorRuntime _runtime;
    private boolean debug = true;
    private int environment = 2;
    private static ConnectorAdminObjectAdminServiceImpl adminObjectAdmService;
    private static ConnectorConfigurationParserServiceImpl configParserAdmService;
    private static ConnectorConnectionPoolAdminServiceImpl ccPoolAdmService;
    private static ConnectorResourceAdminServiceImpl connectorResourceAdmService;
    private static ConnectorSecurityAdminServiceImpl connectorSecurityAdmService;
    private static ResourceAdapterAdminServiceImpl resourceAdapterAdmService;
    private static ConnectorServiceImpl connectorService;

    public static ConnectorRuntime getRuntime() {
        if (_runtime == null) {
            _runtime = new ConnectorRuntime();
            Utility.setDataDirectProperty();
            ConnectorRuntime.createServices();
        }
        return _runtime;
    }

    public void initialize(int environment) {
        this.environment = environment;
        this.initServices();
    }

    public int getEnviron() {
        return this.environment;
    }

    private ConnectorRuntime() {
        _registry = ConnectorRegistry.getInstance();
    }

    private static void createServices() {
        adminObjectAdmService = (ConnectorAdminObjectAdminServiceImpl)ConnectorAdminServicesFactory.getService("AdminObjectResource");
        ccPoolAdmService = (ConnectorConnectionPoolAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorConnectionPool");
        connectorResourceAdmService = (ConnectorResourceAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorResource");
        connectorSecurityAdmService = (ConnectorSecurityAdminServiceImpl)ConnectorAdminServicesFactory.getService("Security");
        resourceAdapterAdmService = (ResourceAdapterAdminServiceImpl)ConnectorAdminServicesFactory.getService("ResourceAdapter");
        configParserAdmService = new ConnectorConfigurationParserServiceImpl();
        connectorService = new ConnectorServiceImpl();
    }

    private void initServices() {
        ConnectorServiceImpl.initialize(this.getEnviron());
    }

    public void destroyActiveResourceAdapter(String moduleName) throws ConnectorRuntimeException {
        resourceAdapterAdmService.destroyActiveResourceAdapter(moduleName);
    }

    public void destroyActiveResourceAdapter(String moduleName, boolean cascade) throws ConnectorRuntimeException {
        resourceAdapterAdmService.destroyActiveResourceAdapter(moduleName, cascade);
    }

    public void createActiveResourceAdapter(ConnectorDescriptor connectorDescriptor, String moduleName, String moduleDir, boolean writeSunDescriptor) throws ConnectorRuntimeException {
        resourceAdapterAdmService.createActiveResourceAdapter(connectorDescriptor, moduleName, moduleDir, writeSunDescriptor);
    }

    public void createActiveResourceAdapter(String moduleDir, String moduleName, boolean writeSunDescriptor) throws ConnectorRuntimeException {
        resourceAdapterAdmService.createActiveResourceAdapter(moduleDir, moduleName, writeSunDescriptor);
    }

    public ConnectionManager obtainConnectionManager(String poolName) throws ConnectorRuntimeException {
        ConnectionManager mgr = ConnectionManagerFactory.getAvailableConnectionManager(poolName);
        return mgr;
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(String poolName) throws ConnectorRuntimeException {
        return ccPoolAdmService.obtainManagedConnectionFactory(poolName);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, ElementProperty[] props, SecurityMap[] securityMaps) throws ConnectorRuntimeException {
        ccPoolAdmService.createConnectorConnectionPool(ccp, connectionDefinitionName, rarName, props, securityMaps);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, ConnectionDefDescriptor cdd, String rarName) throws ConnectorRuntimeException {
        ccPoolAdmService.createConnectorConnectionPool(ccp, cdd, rarName);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj, ConnectorDescriptorInfo connectorDescInfo) throws ConnectorRuntimeException {
        ccPoolAdmService.createConnectorConnectionPool(connectorPoolObj, connectorDescInfo);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj, String security, Set configProperties) throws ConnectorRuntimeException {
        ccPoolAdmService.createConnectorConnectionPool(connectorPoolObj, security, configProperties);
    }

    public void createConnectorResource(String jndiName, String poolName, String resourceType) throws ConnectorRuntimeException {
        connectorResourceAdmService.createConnectorResource(jndiName, poolName, resourceType);
    }

    public String getDefaultPoolName(String jndiName) {
        return connectorService.getDefaultPoolName(jndiName);
    }

    public static boolean isJmsRa() {
        return ResourceAdapterAdminServiceImpl.isJmsRa();
    }

    public String getDefaultPoolName(String moduleName, String connectionDefName) {
        return connectorService.getDefaultPoolName(moduleName, connectionDefName);
    }

    public String getDefaultResourceName(String moduleName, String connectionDefName) {
        return connectorService.getDefaultResourceName(moduleName, connectionDefName);
    }

    public void addAdminObject(String appName, String connectorName, String jndiName, String adminObjectType, Properties props) throws ConnectorRuntimeException {
        adminObjectAdmService.addAdminObject(appName, connectorName, jndiName, adminObjectType, props);
    }

    public void deleteAdminObject(String jndiName) throws ConnectorRuntimeException {
        adminObjectAdmService.deleteAdminObject(jndiName);
    }

    public void deleteConnectorConnectionPool(String poolName) throws ConnectorRuntimeException {
        ccPoolAdmService.deleteConnectorConnectionPool(poolName);
    }

    public void deleteConnectorConnectionPool(String poolName, boolean cascade) throws ConnectorRuntimeException {
        ccPoolAdmService.deleteConnectorConnectionPool(poolName, cascade);
    }

    public void deleteConnectorResource(String jndiName) throws ConnectorRuntimeException {
        connectorResourceAdmService.deleteConnectorResource(jndiName);
    }

    public AuthenticationService getAuthenticationService(String rarName, String poolName) {
        return connectorSecurityAdmService.getAuthenticationService(rarName, poolName);
    }

    public JmsRaMapping getJmsRaMapping() {
        return resourceAdapterAdmService.getJmsRaMapping();
    }

    public String getSecurityPermissionSpec(String moduleName) throws ConnectorRuntimeException {
        return configParserAdmService.getSecurityPermissionSpec(moduleName);
    }

    public boolean configureSecurityMaps(String poolName, SecurityMap[] securityMaps) {
        return connectorSecurityAdmService.configureSecurityMaps(poolName, securityMaps);
    }

    public void unconfigureSecurityMaps(String poolName) {
        connectorSecurityAdmService.unconfigureSecurityMaps(poolName);
    }

    public boolean testConnectionPool(String poolName) throws ResourceException {
        return ccPoolAdmService.testConnectionPool(poolName);
    }

    public boolean isRarDeployed(String moduleName) {
        return resourceAdapterAdmService.isRarDeployed(moduleName);
    }

    public void reCreateActiveResourceAdapter(String moduleName) throws ConnectorRuntimeException {
        resourceAdapterAdmService.reCreateActiveResourceAdapter(moduleName);
    }

    public boolean stopAndRemoveActiveResourceAdapter(String moduleName) {
        return resourceAdapterAdmService.stopAndRemoveActiveResourceAdapter(moduleName);
    }

    public void killAllPools(String moduleName) {
        ccPoolAdmService.killAllPools(moduleName);
    }

    public void killPool(String poolName) {
        ccPoolAdmService.killPool(poolName);
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) throws ConnectorRuntimeException {
        resourceAdapterAdmService.addResourceAdapterConfig(rarName, raConfig);
    }

    public void deleteResourceAdapterConfig(String rarName) {
        resourceAdapterAdmService.deleteResourceAdapterConfig(rarName);
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        return ccPoolAdmService.reconfigureConnectorConnectionPool(ccp);
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp, Set excludedProps) throws ConnectorRuntimeException {
        return ccPoolAdmService.reconfigureConnectorConnectionPool(ccp, excludedProps);
    }

    public void recreateConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        ccPoolAdmService.recreateConnectorConnectionPool(ccp);
    }

    public String[] getConnectionDefinitionNames(String rarName) throws ConnectorRuntimeException {
        return configParserAdmService.getConnectionDefinitionNames(rarName);
    }

    public String[] getAdminObjectInterfaceNames(String rarName) throws ConnectorRuntimeException {
        return configParserAdmService.getAdminObjectInterfaceNames(rarName);
    }

    public Properties getResourceAdapterConfigProps(String rarName) throws ConnectorRuntimeException {
        return rarName.indexOf("#") == -1 ? configParserAdmService.getResourceAdapterConfigProps(rarName) : new Properties();
    }

    public Properties getMCFConfigProps(String rarName, String connectionDefName) throws ConnectorRuntimeException {
        return rarName.indexOf("#") == -1 ? configParserAdmService.getMCFConfigProps(rarName, connectionDefName) : new Properties();
    }

    public Properties getAdminObjectConfigProps(String rarName, String adminObjectIntf) throws ConnectorRuntimeException {
        return rarName.indexOf("#") == -1 ? configParserAdmService.getAdminObjectConfigProps(rarName, adminObjectIntf) : new Properties();
    }

    public Properties getConnectorConfigJavaBeans(String rarName, String connectionDefName, String type) throws ConnectorRuntimeException {
        return configParserAdmService.getConnectorConfigJavaBeans(rarName, connectionDefName, type);
    }

    public String getActivationSpecClass(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        return configParserAdmService.getActivationSpecClass(rarName, messageListenerType);
    }

    public String[] getMessageListenerTypes(String rarName) throws ConnectorRuntimeException {
        return configParserAdmService.getMessageListenerTypes(rarName);
    }

    public Properties getMessageListenerConfigProps(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        return rarName.indexOf("#") == -1 ? configParserAdmService.getMessageListenerConfigProps(rarName, messageListenerType) : new Properties();
    }

    public Properties getMessageListenerConfigPropTypes(String rarName, String messageListenerType) throws ConnectorRuntimeException {
        return configParserAdmService.getMessageListenerConfigPropTypes(rarName, messageListenerType);
    }

    public static boolean isServer() {
        return connectorService.isServer();
    }

    public void loadDeferredResourceAdapter(String rarName) throws ConnectorRuntimeException {
        connectorService.loadDeferredResourceAdapter(rarName);
    }

    public boolean checkAndLoadResource(String resName) {
        return connectorService.checkAndLoadResource(resName);
    }

    public boolean checkAccessibility(String rarName, ClassLoader loader) {
        return connectorService.checkAccessibility(rarName, loader);
    }

    public static Set getConnectionDefinitionProperties(String connectionDefinitionClassName) {
        return ConnectorConnectionPoolAdminServiceImpl.getConnectionDefinitionProperties(connectionDefinitionClassName);
    }

    public static Map getConnectionDefinitionPropertiesAndDefaults(String connectionDefinitionClassName) {
        return ConnectorConnectionPoolAdminServiceImpl.getConnectionDefinitionPropertiesAndDefaults(connectionDefinitionClassName);
    }

    public void switchOnMatching(String rarName, String poolName) {
        connectorService.switchOnMatching(rarName, poolName);
    }

    public void switchOnMatchingInJndi(String poolName) throws ConnectorRuntimeException {
        ccPoolAdmService.switchOnMatching(poolName);
    }

    public ConnectorDescriptor getConnectorDescriptor(String rarName) throws ConnectorRuntimeException {
        return connectorService.getConnectorDescriptor(rarName);
    }

    public static void stopAllActiveResourceAdapters() {
        resourceAdapterAdmService.stopAllActiveResourceAdapters();
    }

    public Map getResourceAdapterBeanProperties(String pathToDeployableUnit) {
        return configParserAdmService.getRABeanProperties(pathToDeployableUnit);
    }

    public void initializeConnectorMonitoring() {
        connectorService.initializeConnectorMonitoring();
    }

    public Object getJMSAdmin(String target) throws ConnectorRuntimeException {
        MQAdministrator admin = new MQAdministrator(target);
        return admin.getJmsAdmin();
    }

    public Connection getConnection(String jndiName, String user, String password) throws SQLException {
        return ccPoolAdmService.getConnection(jndiName, user, password);
    }

    public Connection getConnection(String jndiName) throws SQLException {
        return ccPoolAdmService.getConnection(jndiName);
    }

    public boolean isConnectorConnectionPoolDeployed(String poolName) {
        return ccPoolAdmService.isConnectorConnectionPoolDeployed(poolName);
    }

    static {
        adminObjectAdmService = null;
        configParserAdmService = null;
        ccPoolAdmService = null;
        connectorResourceAdmService = null;
        connectorSecurityAdmService = null;
        resourceAdapterAdmService = null;
        connectorService = null;
    }
}

