/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectorAdminService;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorServiceImpl;
import com.sun.enterprise.server.ResourcesUtil;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class ConnectorResourceAdminServiceImpl
extends ConnectorServiceImpl
implements ConnectorAdminService {
    public void createConnectorResource(String jndiName, String poolName, String resourceType) throws ConnectorRuntimeException {
        String errMsg = "rardeployment.jndi_lookup_failed";
        String name = poolName;
        try {
            ConnectorConnectionPool connectorConnectionPool = null;
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            InitialContext ic = new InitialContext();
            try {
                connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
            }
            catch (NamingException ne) {
                this.checkAndLoadPoolResource(poolName);
            }
            connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
            ConnectorDescriptorInfo cdi = connectorConnectionPool.getConnectorDescriptorInfo();
            Reference ref = new Reference(connectorConnectionPool.getConnectorDescriptorInfo().getConnectionFactoryClass(), "com.sun.enterprise.naming.factory.ConnectorObjectFactory", null);
            StringRefAddr addr = new StringRefAddr("poolName", poolName);
            ref.add(addr);
            addr = new StringRefAddr("rarName", cdi.getRarName());
            ref.add(addr);
            errMsg = "Failed to bind connector resource in JNDI";
            name = jndiName;
            Switch.getSwitch().getNamingManager().publishObject(jndiName, (Object)ref, true);
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(errMsg);
            cre.initCause(ne);
            _logger.log(Level.SEVERE, errMsg, name);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    public void deleteConnectorResource(String jndiName) throws ConnectorRuntimeException {
        try {
            InitialContext ic = new InitialContext();
            ic.unbind(jndiName);
        }
        catch (NamingException ne) {
            ResourcesUtil resUtil = ResourcesUtil.getInstance();
            if (resUtil.resourceBelongsToSystemRar(jndiName)) {
                return;
            }
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to delete connector resource from jndi");
            cre.initCause(ne);
            _logger.log(Level.SEVERE, "rardeployment.connectorresource_removal_from_jndi_error", jndiName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }
}

