/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.MCFInfo;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class ConnectorRegistry {
    protected static ConnectorRegistry connectorRegistryInstance;
    protected Hashtable resourceAdapters = new Hashtable();
    protected HashMap factories = new HashMap();
    protected HashMap securityMaps = new HashMap();
    protected HashMap backendPrincipalMaps = new HashMap();
    protected HashMap resourceAdapterConfig = new HashMap();
    static Logger _logger;

    public static ConnectorRegistry getInstance() {
        if (connectorRegistryInstance == null) {
            connectorRegistryInstance = new ConnectorRegistry();
            _logger.log(Level.FINE, "creating new connector registry");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "returning the connector registry");
        }
        return connectorRegistryInstance;
    }

    protected ConnectorRegistry() {
        _logger.log(Level.FINE, "initialized the connector registry");
    }

    public void addActiveResourceAdapter(String rarModuleName, ActiveResourceAdapter rar) {
        this.resourceAdapters.put(rarModuleName, rar);
        _logger.log(Level.FINE, "Added the active resource adapter to connector registry", rarModuleName);
    }

    public boolean removeActiveResourceAdapter(String rarModuleName) {
        if (this.resourceAdapters.remove(rarModuleName) == null) {
            _logger.log(Level.FINE, "Failed to remove the resource adapter from connector registry", rarModuleName);
            return false;
        }
        _logger.log(Level.FINE, "removed the active resource adapter from connector registry", rarModuleName);
        return true;
    }

    public ActiveResourceAdapter getActiveResourceAdapter(String rarModuleName) {
        if (rarModuleName != null) {
            _logger.log(Level.FINE, "returning/found the resource adapter from connector registry", rarModuleName);
            return (ActiveResourceAdapter)this.resourceAdapters.get(rarModuleName);
        }
        _logger.log(Level.FINE, "Resourceadapter not found in connector registry.Returning null", rarModuleName);
        return null;
    }

    public boolean isMCFCreated(String poolName) {
        return this.factories.containsKey(poolName);
    }

    public boolean removeManagedConnectionFactory(String poolName) {
        if (this.factories.remove(poolName) == null) {
            _logger.log(Level.FINE, "Failed to remove the MCF from connector registry.", poolName);
            return false;
        }
        _logger.log(Level.FINE, "Removed the MCF from connector registry.", poolName);
        return true;
    }

    public void addManagedConnectionFactory(String poolName, MCFInfo info) {
        this.factories.put(poolName, info);
        _logger.log(Level.FINE, "Added MCF to connector registry.", poolName);
    }

    public ManagedConnectionFactory getManagedConnectionFactory(String poolName) {
        if (poolName != null) {
            _logger.log(Level.FINE, "Returning the MCF from connector registry.", poolName);
            MCFInfo info = (MCFInfo)this.factories.get(poolName);
            if (info != null) {
                return info.get();
            }
        }
        return null;
    }

    public Subject getDefaultSubject(String poolName) {
        MCFInfo info;
        if (poolName != null && (info = (MCFInfo)this.factories.get(poolName)) != null) {
            return info.getSubject();
        }
        return null;
    }

    public boolean isRegistered(String rarModuleName) {
        _logger.log(Level.FINE, "Checking for MCF presence in connector registry.", rarModuleName);
        return this.resourceAdapters.containsKey(rarModuleName);
    }

    public ConnectorDescriptor getDescriptor(String rarModuleName) {
        ActiveResourceAdapter ar = null;
        if (rarModuleName != null) {
            ar = (ActiveResourceAdapter)this.resourceAdapters.get(rarModuleName);
        }
        if (ar != null) {
            _logger.log(Level.FINE, "Found/returing Connector descriptor in connector registry.", rarModuleName);
            return ar.getDescriptor();
        }
        _logger.log(Level.FINE, "Couldnot find Connector descriptor in connector registry.", rarModuleName);
        return null;
    }

    public HashMap getSecurityMap(String poolName) {
        if (poolName != null) {
            _logger.log(Level.FINE, "Returing the security map from connector registry.", poolName);
            return (HashMap)this.securityMaps.get(poolName);
        }
        return null;
    }

    public void addSecurityMap(String key, HashMap value) {
        if (key != null) {
            _logger.log(Level.FINE, "Adding the security map to connector registry.", key);
            this.securityMaps.put(key, value);
        }
    }

    public boolean removeSecurityMap(String key) {
        if (this.securityMaps.remove(key) == null) {
            _logger.log(Level.FINE, "failed to remove the security map from connector registry.", key);
            return false;
        }
        _logger.log(Level.FINE, "Removed the security map from connector registry.", key);
        return true;
    }

    public HashMap getBackendPrincipalMap(String poolName) {
        if (poolName != null) {
            _logger.log(Level.FINE, "Returing the backendPrincipal map from connector registry.", poolName);
            return (HashMap)this.backendPrincipalMaps.get(poolName);
        }
        return null;
    }

    public void addBackendPrincipalMap(String key, HashMap value) {
        if (key != null) {
            _logger.log(Level.FINE, "Adding the backendPrincipal map to connector registry.", key);
            this.backendPrincipalMaps.put(key, value);
        }
    }

    public boolean removeBackendPrincipalMap(String key) {
        if (this.backendPrincipalMaps.remove(key) == null) {
            _logger.log(Level.FINE, "failed to remove the backendPrincipalmap from registry.", key);
            return false;
        }
        _logger.log(Level.FINE, "Removed the backendPrincipal map from registry.", key);
        return true;
    }

    public ResourceAdapterConfig getResourceAdapterConfig(String rarName) {
        if (rarName != null) {
            _logger.log(Level.FINE, "Returing the resourceadapter Config from registry.", rarName);
            return (ResourceAdapterConfig)this.resourceAdapterConfig.get(rarName);
        }
        return null;
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) {
        if (rarName != null) {
            _logger.log(Level.FINE, "Adding the resourceAdapter Config to connector registry.", rarName);
            this.resourceAdapterConfig.put(rarName, raConfig);
        }
    }

    public boolean removeResourceAdapterConfig(String rarName) {
        if (this.resourceAdapterConfig.remove(rarName) == null) {
            _logger.log(Level.FINE, "failed to remove the resourceAdapter config from registry.", rarName);
            return false;
        }
        _logger.log(Level.FINE, "Removed the resourceAdapter config map from registry.", rarName);
        return true;
    }

    public ActiveResourceAdapter[] getAllActiveResourceAdapters() {
        return this.resourceAdapters.values().toArray(new ActiveResourceAdapter[0]);
    }

    public int getTxLevel(String poolName) {
        MCFInfo info;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ConnectorRegistry.getTxLevel - poolName => " + poolName);
        }
        if (poolName != null && (info = (MCFInfo)this.factories.get(poolName)) != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ConnRegistry.getTxLevel - txLevel => " + info.getTransactionSupport());
            }
            return info.getTransactionSupport();
        }
        return -1;
    }

    public ResourcePrincipal getDefaultResourcePrincipal(String poolName) throws ConnectorRuntimeException {
        MCFInfo info;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ConnectorRegistry.getDefaultResourcePrincipal - poolName:" + poolName);
        }
        if (poolName != null && (info = (MCFInfo)this.factories.get(poolName)) != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ConnRegistry.getTxLevel - defult resourceprin => " + info.getResourcePrincipal());
            }
            return info.getResourcePrincipal();
        }
        throw new ConnectorRuntimeException("null default principal");
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

