/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.enterprise.iiop.PEORBConfigurator;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.resource.AbstractConnectorAllocator;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ConnectorAllocator;
import com.sun.enterprise.resource.LocalTxConnectorAllocator;
import com.sun.enterprise.resource.NoTxConnectorAllocator;
import com.sun.enterprise.resource.PoolManagerImpl;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class ConnectionManagerImpl
implements ConnectionManager,
Serializable {
    private String jndiName;
    private String poolName;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private String rarName;
    private ResourcePrincipal defaultPrin = null;

    public ConnectionManagerImpl(String poolName) {
        this.poolName = poolName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public Object allocateNonTxConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        String localJndiName = this.jndiName;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Allocating NonTxConnection");
        }
        if (!this.jndiName.endsWith("__nontx")) {
            localJndiName = this.jndiName + "__nontx";
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Adding __nontx to jndiname");
            }
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("lookup happened from a __nontx datasource directly");
        }
        return this.allocateConnection(mcf, cxRequestInfo, localJndiName);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.allocateConnection(mcf, cxRequestInfo, this.jndiName);
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo, String jndiNameToUse) throws ResourceException {
        AuthenticationService authService;
        PoolManager poolmgr = Switch.getSwitch().getPoolManager();
        boolean resourceShareable = true;
        ResourceReferenceDescriptor ref = poolmgr.getResourceReference(jndiNameToUse);
        if (ref != null) {
            String shareableStr = ref.getSharingScope();
            if (shareableStr.equals(ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE)) {
                resourceShareable = false;
            }
        }
        if (ref == null) {
            _logger.log(Level.FINE, "poolmgr.no_resource_reference", jndiNameToUse);
            return this.internalGetConnection(mcf, this.defaultPrin, cxRequestInfo, resourceShareable, jndiNameToUse);
        }
        String auth = ref.getAuthorization();
        if (auth.equals(ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION)) {
            if (cxRequestInfo == null) {
                StringManager localStrings = StringManager.getManager(ConnectionManagerImpl.class);
                String msg = localStrings.getString("con_mgr.null_userpass");
                throw new ResourceException(msg);
            }
            ConnectorRuntime.getRuntime().switchOnMatching(this.rarName, this.poolName);
            return this.internalGetConnection(mcf, null, cxRequestInfo, resourceShareable, jndiNameToUse);
        }
        ResourcePrincipal prin = null;
        Principal callerPrincipal = null;
        SecurityContext securityContext = null;
        ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
        if (connectorRuntime.isServer() && (securityContext = SecurityContext.getCurrent()) != null && (callerPrincipal = securityContext.getCallerPrincipal()) != null && (authService = connectorRuntime.getAuthenticationService(this.rarName, this.poolName)) != null) {
            String callerPrincipalName = callerPrincipal.getName();
            prin = (ResourcePrincipal)authService.mapPrincipal(callerPrincipalName);
        }
        if (prin == null) {
            prin = ref.getResourcePrincipal();
            if (prin == null) {
                _logger.log(Level.FINE, "default-resource-principal notspecified for " + jndiNameToUse + ". Defaulting to" + " user/password specified in the pool");
                prin = this.defaultPrin;
            } else if (!prin.equals(this.defaultPrin)) {
                ConnectorRuntime.getRuntime().switchOnMatching(this.rarName, this.poolName);
            }
        }
        return this.internalGetConnection(mcf, prin, cxRequestInfo, resourceShareable, jndiNameToUse);
    }

    private Object internalGetConnection(ManagedConnectionFactory mcf, ResourcePrincipal prin, ConnectionRequestInfo cxRequestInfo, boolean shareable, String jndiNameToUse) throws ResourceException {
        try {
            PoolManager poolmgr = Switch.getSwitch().getPoolManager();
            ResourceSpec spec = new ResourceSpec(jndiNameToUse, 1);
            spec.setConnectionPoolName(this.poolName);
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            ManagedConnectionFactory freshMCF = registry.getManagedConnectionFactory(this.poolName);
            if (!freshMCF.equals(mcf)) {
                _logger.log(Level.INFO, "conmgr.mcf_not_equal");
            }
            ConnectorDescriptor desc = registry.getDescriptor(this.rarName);
            Subject subject = null;
            ClientSecurityInfo info = null;
            if (prin == null) {
                info = new ClientSecurityInfo(cxRequestInfo);
            } else {
                info = new ClientSecurityInfo(prin);
                subject = prin.equals(this.defaultPrin) ? registry.getDefaultSubject(this.poolName) : this.createSubject(mcf, prin);
            }
            int txLevel = registry.getTxLevel(this.poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ConnectionMgr: poolName " + this.poolName + "  txLevel : " + txLevel);
            }
            AbstractConnectorAllocator alloc = null;
            switch (txLevel) {
                case 0: {
                    alloc = new NoTxConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc);
                    return poolmgr.getResource(spec, alloc, info);
                }
                case 1: {
                    if (!shareable) {
                        StringManager localStrings = StringManager.getManager(ConnectionManagerImpl.class);
                        String i18nMsg = localStrings.getString("con_mgr.resource_not_shareable");
                        throw new ResourceAllocationException(i18nMsg);
                    }
                    alloc = new LocalTxConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc);
                    return poolmgr.getResource(spec, alloc, info);
                }
                case 2: {
                    if (this.rarName.equals(ConnectorRuntime.DEFAULT_JMS_ADAPTER)) {
                        shareable = false;
                    }
                    spec.setShareableXAResource(shareable);
                    alloc = new ConnectorAllocator(poolmgr, mcf, spec, subject, cxRequestInfo, info, desc, shareable);
                    return poolmgr.getResource(spec, alloc, info);
                }
            }
            StringManager localStrings = StringManager.getManager(ConnectionManagerImpl.class);
            String i18nMsg = localStrings.getString("con_mgr.illegal_tx_level", txLevel + " ");
            throw new IllegalStateException(i18nMsg);
        }
        catch (PoolingException ex) {
            _logger.log(Level.WARNING, "poolmgr.get_connection_failure", ex.getMessage());
            StringManager localStrings = StringManager.getManager(ConnectionManagerImpl.class);
            String i18nMsg = localStrings.getString("con_mgr.error_creating_connection", ex.getMessage());
            ResourceAllocationException rae = new ResourceAllocationException(i18nMsg);
            rae.initCause((Throwable)ex);
            throw rae;
        }
    }

    public void setRarName(String _rarName) {
        this.rarName = _rarName;
    }

    public String getRarName() {
        return this.rarName;
    }

    public void initialize() throws ConnectorRuntimeException {
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        ManagedConnectionFactory mcf = runtime.obtainManagedConnectionFactory(this.poolName);
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        this.defaultPrin = registry.getDefaultResourcePrincipal(this.poolName);
        Switch sw = Switch.getSwitch();
        if (sw.getContainerType() == 0) {
            try {
                PEORBConfigurator.initTransactionService(null);
                if (sw.getPoolManager() == null) {
                    sw.setPoolManager(new PoolManagerImpl());
                }
                if (sw.getTransactionManager() == null) {
                    sw.setTransactionManager(new J2EETransactionManagerOpt());
                }
                if (sw.getNamingManager() == null) {
                    sw.setNamingManager(new NamingManagerImpl());
                }
                this.jndiName = ResourceInstaller.getPMJndiName(this.jndiName);
            }
            catch (Exception e) {
                throw (ConnectorRuntimeException)new ConnectorRuntimeException(e.getMessage()).initCause(e);
            }
        }
    }

    private Subject createSubject(ManagedConnectionFactory mcf, final ResourcePrincipal prin) {
        String password = prin.getPassword();
        if (password == null) {
            password = "";
        }
        final PasswordCredential pc = new PasswordCredential(prin.getName(), password.toCharArray());
        pc.setManagedConnectionFactory(mcf);
        final Subject tempSubject = new Subject();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                tempSubject.getPrincipals().add(prin);
                tempSubject.getPrivateCredentials().add(pc);
                return null;
            }
        });
        return tempSubject;
    }
}

