/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.util;

public final class ConfigXPathHelper {
    public static final String XPATH_SEPARATOR = "/";
    private static char SEPARATOR_CHAR = (char)47;
    private static char OPENBRACKET_CHAR = (char)91;
    private static char CLOSEBRACKET_CHAR = (char)93;
    private static char ESCAPE_CHAR = (char)92;

    public static String getAbsoluteIdXpathExpression(String childTagName, String nameId, String valueId) {
        if (childTagName.startsWith(XPATH_SEPARATOR)) {
            return childTagName + "[@" + nameId + "='" + valueId + "']";
        }
        return XPATH_SEPARATOR + childTagName + "[@" + nameId + "='" + valueId + "']";
    }

    public static String getLastNodeName(String xPath) {
        char ch;
        int idx = xPath.length() - 1;
        int idxEnd = -1;
        if (idx >= 0 && (ch = xPath.charAt(idx)) == CLOSEBRACKET_CHAR) {
            --idx;
            idx = idxEnd = ConfigXPathHelper.bypassBrackets(xPath, idx);
        }
        while (idx >= 0 && ((ch = xPath.charAt(idx)) != SEPARATOR_CHAR || ConfigXPathHelper.isEscapedChar(xPath, idx))) {
            --idx;
        }
        ++idx;
        if (idxEnd <= 0 || idxEnd == xPath.length() - 1) {
            return xPath.substring(idx);
        }
        return xPath.substring(idx, idxEnd + 1);
    }

    public static String getParentXPath(String xPath) {
        char ch;
        int idx = xPath.length() - 1;
        if (idx >= 0 && (ch = xPath.charAt(idx)) == CLOSEBRACKET_CHAR) {
            --idx;
            idx = ConfigXPathHelper.bypassBrackets(xPath, idx);
        }
        while (idx >= 0 && ((ch = xPath.charAt(idx)) != SEPARATOR_CHAR || ConfigXPathHelper.isEscapedChar(xPath, idx))) {
            --idx;
        }
        if (idx <= 0) {
            return XPATH_SEPARATOR;
        }
        return xPath.substring(0, idx);
    }

    private static int bypassBrackets(String xPath, int idx) {
        char ch;
        while (idx >= 0 && ((ch = xPath.charAt(idx)) != OPENBRACKET_CHAR || ConfigXPathHelper.isEscapedChar(xPath, idx))) {
            --idx;
        }
        return idx - 1;
    }

    private static boolean isEscapedChar(String xPath, int idx) {
        if (idx <= 0) {
            return false;
        }
        int count = 0;
        while (--idx >= 0 && xPath.charAt(idx) == ESCAPE_CHAR) {
            ++count;
        }
        return count % 2 == 1;
    }
}

