/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class Server
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String APPLICATION_REF = "ApplicationRef";
    public static final String RESOURCE_REF = "ResourceRef";
    public static final String SYSTEM_PROPERTY = "SystemProperty";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public Server() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public Server(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("application-ref", APPLICATION_REF, 66096, ApplicationRef.class);
        this.createAttribute(APPLICATION_REF, "enabled", "Enabled", 1, null, "true");
        this.createAttribute(APPLICATION_REF, "virtual-servers", "VirtualServers", 513, null, null);
        this.createAttribute(APPLICATION_REF, "lb-enabled", "LbEnabled", 1, null, "false");
        this.createAttribute(APPLICATION_REF, "disable-timeout-in-minutes", "DisableTimeoutInMinutes", 1, null, "30");
        this.createAttribute(APPLICATION_REF, "ref", "Ref", 257, null, null);
        this.createProperty("resource-ref", RESOURCE_REF, 66096, ResourceRef.class);
        this.createAttribute(RESOURCE_REF, "enabled", "Enabled", 1, null, "true");
        this.createAttribute(RESOURCE_REF, "ref", "Ref", 257, null, null);
        this.createProperty("system-property", SYSTEM_PROPERTY, 66096, SystemProperty.class);
        this.createAttribute(SYSTEM_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(SYSTEM_PROPERTY, "value", "Value", 257, null, null);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setApplicationRef(int index, ApplicationRef value) {
        this.setValue(APPLICATION_REF, index, value);
    }

    public ApplicationRef getApplicationRef(int index) {
        return (ApplicationRef)this.getValue(APPLICATION_REF, index);
    }

    public void setApplicationRef(ApplicationRef[] value) {
        this.setValue(APPLICATION_REF, value);
    }

    public ApplicationRef[] getApplicationRef() {
        return (ApplicationRef[])this.getValues(APPLICATION_REF);
    }

    public int sizeApplicationRef() {
        return this.size(APPLICATION_REF);
    }

    public int addApplicationRef(ApplicationRef value) throws ConfigException {
        return this.addApplicationRef(value, true);
    }

    public int addApplicationRef(ApplicationRef value, boolean overwrite) throws ConfigException {
        ApplicationRef old = this.getApplicationRefByRef(value.getRef());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(Server.class).getString("cannotAddDuplicate", APPLICATION_REF));
        }
        return this.addValue(APPLICATION_REF, value, overwrite);
    }

    public int removeApplicationRef(ApplicationRef value) {
        return this.removeValue(APPLICATION_REF, value);
    }

    public int removeApplicationRef(ApplicationRef value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(APPLICATION_REF, value, overwrite);
    }

    public ApplicationRef getApplicationRefByRef(String id) {
        ApplicationRef[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getApplicationRef()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.REF)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setResourceRef(int index, ResourceRef value) {
        this.setValue(RESOURCE_REF, index, value);
    }

    public ResourceRef getResourceRef(int index) {
        return (ResourceRef)this.getValue(RESOURCE_REF, index);
    }

    public void setResourceRef(ResourceRef[] value) {
        this.setValue(RESOURCE_REF, value);
    }

    public ResourceRef[] getResourceRef() {
        return (ResourceRef[])this.getValues(RESOURCE_REF);
    }

    public int sizeResourceRef() {
        return this.size(RESOURCE_REF);
    }

    public int addResourceRef(ResourceRef value) throws ConfigException {
        return this.addResourceRef(value, true);
    }

    public int addResourceRef(ResourceRef value, boolean overwrite) throws ConfigException {
        ResourceRef old = this.getResourceRefByRef(value.getRef());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(Server.class).getString("cannotAddDuplicate", RESOURCE_REF));
        }
        return this.addValue(RESOURCE_REF, value, overwrite);
    }

    public int removeResourceRef(ResourceRef value) {
        return this.removeValue(RESOURCE_REF, value);
    }

    public int removeResourceRef(ResourceRef value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(RESOURCE_REF, value, overwrite);
    }

    public ResourceRef getResourceRefByRef(String id) {
        ResourceRef[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getResourceRef()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.REF)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setSystemProperty(int index, SystemProperty value) {
        this.setValue(SYSTEM_PROPERTY, index, value);
    }

    public SystemProperty getSystemProperty(int index) {
        return (SystemProperty)this.getValue(SYSTEM_PROPERTY, index);
    }

    public void setSystemProperty(SystemProperty[] value) {
        this.setValue(SYSTEM_PROPERTY, value);
    }

    public SystemProperty[] getSystemProperty() {
        return (SystemProperty[])this.getValues(SYSTEM_PROPERTY);
    }

    public int sizeSystemProperty() {
        return this.size(SYSTEM_PROPERTY);
    }

    public int addSystemProperty(SystemProperty value) throws ConfigException {
        return this.addSystemProperty(value, true);
    }

    public int addSystemProperty(SystemProperty value, boolean overwrite) throws ConfigException {
        SystemProperty old = this.getSystemPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(Server.class).getString("cannotAddDuplicate", SYSTEM_PROPERTY));
        }
        return this.addValue(SYSTEM_PROPERTY, value, overwrite);
    }

    public int removeSystemProperty(SystemProperty value) {
        return this.removeValue(SYSTEM_PROPERTY, value);
    }

    public int removeSystemProperty(SystemProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(SYSTEM_PROPERTY, value, overwrite);
    }

    public SystemProperty getSystemPropertyByName(String id) {
        SystemProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getSystemProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(Server.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getName() {
        return this.getAttributeValue(ServerTags.NAME);
    }

    public void setName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.NAME, v, overwrite);
    }

    public void setName(String v) {
        this.setAttributeValue(ServerTags.NAME, v);
    }

    public String getConfigRef() {
        return this.getAttributeValue(ServerTags.CONFIG_REF);
    }

    public void setConfigRef(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.CONFIG_REF, v, overwrite);
    }

    public void setConfigRef(String v) {
        this.setAttributeValue(ServerTags.CONFIG_REF, v);
    }

    public String getNodeAgentRef() {
        return this.getAttributeValue(ServerTags.NODE_AGENT_REF);
    }

    public void setNodeAgentRef(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.NODE_AGENT_REF, v, overwrite);
    }

    public void setNodeAgentRef(String v) {
        this.setAttributeValue(ServerTags.NODE_AGENT_REF, v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "server" + (this.canHaveSiblings() ? "[@name='" + this.getAttributeValue("name") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        attr = attr.trim();
        return null;
    }

    public void dump(StringBuffer str, String indent) {
        ConfigBean n;
        int i;
        str.append(indent);
        str.append("ApplicationRef[" + this.sizeApplicationRef() + "]");
        for (i = 0; i < this.sizeApplicationRef(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getApplicationRef(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(APPLICATION_REF, i, str, indent);
        }
        str.append(indent);
        str.append("ResourceRef[" + this.sizeResourceRef() + "]");
        for (i = 0; i < this.sizeResourceRef(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getResourceRef(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(RESOURCE_REF, i, str, indent);
        }
        str.append(indent);
        str.append("SystemProperty[" + this.sizeSystemProperty() + "]");
        for (i = 0; i < this.sizeSystemProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getSystemProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(SYSTEM_PROPERTY, i, str, indent);
        }
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("Server\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

