/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class MessageSecurityConfig
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String PROVIDER_CONFIG = "ProviderConfig";

    public MessageSecurityConfig() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public MessageSecurityConfig(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("provider-config", PROVIDER_CONFIG, 66112, ProviderConfig.class);
        this.createAttribute(PROVIDER_CONFIG, "provider-id", "ProviderId", 257, null, null);
        this.createAttribute(PROVIDER_CONFIG, "provider-type", "ProviderType", 257, null, null);
        this.createAttribute(PROVIDER_CONFIG, "class-name", "ClassName", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setProviderConfig(int index, ProviderConfig value) {
        this.setValue(PROVIDER_CONFIG, index, value);
    }

    public ProviderConfig getProviderConfig(int index) {
        return (ProviderConfig)this.getValue(PROVIDER_CONFIG, index);
    }

    public void setProviderConfig(ProviderConfig[] value) {
        this.setValue(PROVIDER_CONFIG, value);
    }

    public ProviderConfig[] getProviderConfig() {
        return (ProviderConfig[])this.getValues(PROVIDER_CONFIG);
    }

    public int sizeProviderConfig() {
        return this.size(PROVIDER_CONFIG);
    }

    public int addProviderConfig(ProviderConfig value) throws ConfigException {
        return this.addProviderConfig(value, true);
    }

    public int addProviderConfig(ProviderConfig value, boolean overwrite) throws ConfigException {
        ProviderConfig old = this.getProviderConfigByProviderId(value.getProviderId());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(MessageSecurityConfig.class).getString("cannotAddDuplicate", PROVIDER_CONFIG));
        }
        return this.addValue(PROVIDER_CONFIG, value, overwrite);
    }

    public int removeProviderConfig(ProviderConfig value) {
        return this.removeValue(PROVIDER_CONFIG, value);
    }

    public int removeProviderConfig(ProviderConfig value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(PROVIDER_CONFIG, value, overwrite);
    }

    public ProviderConfig getProviderConfigByProviderId(String id) {
        ProviderConfig[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getProviderConfig()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.PROVIDER_ID)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getAuthLayer() {
        return this.getAttributeValue(ServerTags.AUTH_LAYER);
    }

    public void setAuthLayer(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.AUTH_LAYER, v, overwrite);
    }

    public void setAuthLayer(String v) {
        this.setAttributeValue(ServerTags.AUTH_LAYER, v);
    }

    public String getDefaultProvider() {
        return this.getAttributeValue(ServerTags.DEFAULT_PROVIDER);
    }

    public void setDefaultProvider(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DEFAULT_PROVIDER, v, overwrite);
    }

    public void setDefaultProvider(String v) {
        this.setAttributeValue(ServerTags.DEFAULT_PROVIDER, v);
    }

    public String getDefaultClientProvider() {
        return this.getAttributeValue(ServerTags.DEFAULT_CLIENT_PROVIDER);
    }

    public void setDefaultClientProvider(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DEFAULT_CLIENT_PROVIDER, v, overwrite);
    }

    public void setDefaultClientProvider(String v) {
        this.setAttributeValue(ServerTags.DEFAULT_CLIENT_PROVIDER, v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "message-security-config" + (this.canHaveSiblings() ? "[@auth-layer='" + this.getAttributeValue("auth-layer") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        attr = attr.trim();
        return null;
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append("ProviderConfig[" + this.sizeProviderConfig() + "]");
        for (int i = 0; i < this.sizeProviderConfig(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            ProviderConfig n = this.getProviderConfig(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(PROVIDER_CONFIG, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("MessageSecurityConfig\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

