/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ModuleLogLevels;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class LogService
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String MODULE_LOG_LEVELS = "ModuleLogLevels";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public LogService() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public LogService(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("module-log-levels", MODULE_LOG_LEVELS, 66064, ModuleLogLevels.class);
        this.createAttribute(MODULE_LOG_LEVELS, "root", "Root", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "server", "Server", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "ejb-container", "EjbContainer", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "cmp-container", "CmpContainer", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "mdb-container", "MdbContainer", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "web-container", "WebContainer", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "classloader", "Classloader", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "configuration", "Configuration", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "naming", "Naming", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "security", "Security", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "jts", "Jts", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "jta", "Jta", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "admin", "Admin", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "deployment", "Deployment", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "verifier", "Verifier", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "jaxr", "Jaxr", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "jaxrpc", "Jaxrpc", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "saaj", "Saaj", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "corba", "Corba", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "javamail", "Javamail", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "jms", "Jms", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "connector", "Connector", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "jdo", "Jdo", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "cmp", "Cmp", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "util", "Util", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "resource-adapter", "ResourceAdapter", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "synchronization", "Synchronization", 1, null, "INFO");
        this.createAttribute(MODULE_LOG_LEVELS, "node-agent", "NodeAgent", 1, null, "INFO");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setModuleLogLevels(ModuleLogLevels value) {
        this.setValue(MODULE_LOG_LEVELS, value);
    }

    public ModuleLogLevels getModuleLogLevels() {
        return (ModuleLogLevels)this.getValue(MODULE_LOG_LEVELS);
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(LogService.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getFile() {
        return this.getAttributeValue(ServerTags.FILE);
    }

    public void setFile(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.FILE, v, overwrite);
    }

    public void setFile(String v) {
        this.setAttributeValue(ServerTags.FILE, v);
    }

    public boolean isUseSystemLogging() {
        return LogService.toBoolean(this.getAttributeValue(ServerTags.USE_SYSTEM_LOGGING));
    }

    public void setUseSystemLogging(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.USE_SYSTEM_LOGGING, "" + v, overwrite);
    }

    public void setUseSystemLogging(boolean v) {
        this.setAttributeValue(ServerTags.USE_SYSTEM_LOGGING, "" + v);
    }

    public String getLogHandler() {
        return this.getAttributeValue(ServerTags.LOG_HANDLER);
    }

    public void setLogHandler(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.LOG_HANDLER, v, overwrite);
    }

    public void setLogHandler(String v) {
        this.setAttributeValue(ServerTags.LOG_HANDLER, v);
    }

    public String getLogFilter() {
        return this.getAttributeValue(ServerTags.LOG_FILTER);
    }

    public void setLogFilter(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.LOG_FILTER, v, overwrite);
    }

    public void setLogFilter(String v) {
        this.setAttributeValue(ServerTags.LOG_FILTER, v);
    }

    public boolean isLogToConsole() {
        return LogService.toBoolean(this.getAttributeValue(ServerTags.LOG_TO_CONSOLE));
    }

    public void setLogToConsole(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.LOG_TO_CONSOLE, "" + v, overwrite);
    }

    public void setLogToConsole(boolean v) {
        this.setAttributeValue(ServerTags.LOG_TO_CONSOLE, "" + v);
    }

    public String getLogRotationLimitInBytes() {
        return this.getAttributeValue(ServerTags.LOG_ROTATION_LIMIT_IN_BYTES);
    }

    public void setLogRotationLimitInBytes(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.LOG_ROTATION_LIMIT_IN_BYTES, v, overwrite);
    }

    public void setLogRotationLimitInBytes(String v) {
        this.setAttributeValue(ServerTags.LOG_ROTATION_LIMIT_IN_BYTES, v);
    }

    public String getLogRotationTimelimitInMinutes() {
        return this.getAttributeValue(ServerTags.LOG_ROTATION_TIMELIMIT_IN_MINUTES);
    }

    public void setLogRotationTimelimitInMinutes(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.LOG_ROTATION_TIMELIMIT_IN_MINUTES, v, overwrite);
    }

    public void setLogRotationTimelimitInMinutes(String v) {
        this.setAttributeValue(ServerTags.LOG_ROTATION_TIMELIMIT_IN_MINUTES, v);
    }

    public boolean isAlarms() {
        return LogService.toBoolean(this.getAttributeValue(ServerTags.ALARMS));
    }

    public void setAlarms(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ALARMS, "" + v, overwrite);
    }

    public void setAlarms(boolean v) {
        this.setAttributeValue(ServerTags.ALARMS, "" + v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "log-service";
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals(ServerTags.USE_SYSTEM_LOGGING)) {
            return "false".trim();
        }
        if (attr.equals(ServerTags.LOG_TO_CONSOLE)) {
            return "false".trim();
        }
        if (attr.equals(ServerTags.LOG_ROTATION_LIMIT_IN_BYTES)) {
            return "500000".trim();
        }
        if (attr.equals(ServerTags.LOG_ROTATION_TIMELIMIT_IN_MINUTES)) {
            return "0".trim();
        }
        if (attr.equals(ServerTags.ALARMS)) {
            return "false".trim();
        }
        return null;
    }

    public static String getDefaultUseSystemLogging() {
        return "false".trim();
    }

    public static String getDefaultLogToConsole() {
        return "false".trim();
    }

    public static String getDefaultLogRotationLimitInBytes() {
        return "500000".trim();
    }

    public static String getDefaultLogRotationTimelimitInMinutes() {
        return "0".trim();
    }

    public static String getDefaultAlarms() {
        return "false".trim();
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(MODULE_LOG_LEVELS);
        ConfigBean n = this.getModuleLogLevels();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(MODULE_LOG_LEVELS, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("LogService\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

