/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class JmxConnector
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String SSL = "Ssl";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public JmxConnector() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public JmxConnector(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("ssl", SSL, 66064, Ssl.class);
        this.createAttribute(SSL, "cert-nickname", "CertNickname", 257, null, null);
        this.createAttribute(SSL, "ssl2-enabled", "Ssl2Enabled", 1, null, "false");
        this.createAttribute(SSL, "ssl2-ciphers", "Ssl2Ciphers", 513, null, null);
        this.createAttribute(SSL, "ssl3-enabled", "Ssl3Enabled", 1, null, "true");
        this.createAttribute(SSL, "ssl3-tls-ciphers", "Ssl3TlsCiphers", 513, null, null);
        this.createAttribute(SSL, "tls-enabled", "TlsEnabled", 1, null, "true");
        this.createAttribute(SSL, "tls-rollback-enabled", "TlsRollbackEnabled", 1, null, "true");
        this.createAttribute(SSL, "client-auth-enabled", "ClientAuthEnabled", 1, null, "false");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setSsl(Ssl value) {
        this.setValue(SSL, value);
    }

    public Ssl getSsl() {
        return (Ssl)this.getValue(SSL);
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(JmxConnector.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getName() {
        return this.getAttributeValue(ServerTags.NAME);
    }

    public void setName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.NAME, v, overwrite);
    }

    public void setName(String v) {
        this.setAttributeValue(ServerTags.NAME, v);
    }

    public boolean isEnabled() {
        return JmxConnector.toBoolean(this.getAttributeValue(ServerTags.ENABLED));
    }

    public void setEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ENABLED, "" + v, overwrite);
    }

    public void setEnabled(boolean v) {
        this.setAttributeValue(ServerTags.ENABLED, "" + v);
    }

    public String getProtocol() {
        return this.getAttributeValue(ServerTags.PROTOCOL);
    }

    public void setProtocol(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.PROTOCOL, v, overwrite);
    }

    public void setProtocol(String v) {
        this.setAttributeValue(ServerTags.PROTOCOL, v);
    }

    public String getAddress() {
        return this.getAttributeValue(ServerTags.ADDRESS);
    }

    public void setAddress(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ADDRESS, v, overwrite);
    }

    public void setAddress(String v) {
        this.setAttributeValue(ServerTags.ADDRESS, v);
    }

    public String getPort() {
        return this.getAttributeValue(ServerTags.PORT);
    }

    public void setPort(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.PORT, v, overwrite);
    }

    public void setPort(String v) {
        this.setAttributeValue(ServerTags.PORT, v);
    }

    public boolean isAcceptAll() {
        return JmxConnector.toBoolean(this.getAttributeValue(ServerTags.ACCEPT_ALL));
    }

    public void setAcceptAll(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ACCEPT_ALL, "" + v, overwrite);
    }

    public void setAcceptAll(boolean v) {
        this.setAttributeValue(ServerTags.ACCEPT_ALL, "" + v);
    }

    public String getAuthRealmName() {
        return this.getAttributeValue(ServerTags.AUTH_REALM_NAME);
    }

    public void setAuthRealmName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.AUTH_REALM_NAME, v, overwrite);
    }

    public void setAuthRealmName(String v) {
        this.setAttributeValue(ServerTags.AUTH_REALM_NAME, v);
    }

    public boolean isSecurityEnabled() {
        return JmxConnector.toBoolean(this.getAttributeValue(ServerTags.SECURITY_ENABLED));
    }

    public void setSecurityEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.SECURITY_ENABLED, "" + v, overwrite);
    }

    public void setSecurityEnabled(boolean v) {
        this.setAttributeValue(ServerTags.SECURITY_ENABLED, "" + v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "jmx-connector" + (this.canHaveSiblings() ? "[@name='" + this.getAttributeValue("name") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals(ServerTags.ENABLED)) {
            return "true".trim();
        }
        if (attr.equals(ServerTags.PROTOCOL)) {
            return "rmi_jrmp".trim();
        }
        if (attr.equals(ServerTags.ACCEPT_ALL)) {
            return "false".trim();
        }
        if (attr.equals(ServerTags.SECURITY_ENABLED)) {
            return "true".trim();
        }
        return null;
    }

    public static String getDefaultEnabled() {
        return "true".trim();
    }

    public static String getDefaultProtocol() {
        return "rmi_jrmp".trim();
    }

    public static String getDefaultAcceptAll() {
        return "false".trim();
    }

    public static String getDefaultSecurityEnabled() {
        return "true".trim();
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(SSL);
        ConfigBean n = this.getSsl();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SSL, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("JmxConnector\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

