/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class JavaConfig
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String PROFILER = "Profiler";
    public static final String JVM_OPTIONS = "JvmOptions";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public JavaConfig() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public JavaConfig(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("profiler", PROFILER, 66064, Profiler.class);
        this.createAttribute(PROFILER, "name", "Name", 257, null, null);
        this.createAttribute(PROFILER, "classpath", "Classpath", 513, null, null);
        this.createAttribute(PROFILER, "native-library-path", "NativeLibraryPath", 513, null, null);
        this.createAttribute(PROFILER, "enabled", "Enabled", 1, null, "true");
        this.createProperty("jvm-options", JVM_OPTIONS, 65842, String.class);
        this.createProperty("property", ELEMENT_PROPERTY, 66098, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setProfiler(Profiler value) {
        this.setValue(PROFILER, value);
    }

    public Profiler getProfiler() {
        return (Profiler)this.getValue(PROFILER);
    }

    public void setJvmOptions(String[] value) {
        this.setValue(JVM_OPTIONS, value);
    }

    public String[] getJvmOptions() {
        return (String[])this.getValues(JVM_OPTIONS);
    }

    public int sizeJvmOptions() {
        return this.size(JVM_OPTIONS);
    }

    public int addJvmOptions(String value) throws ConfigException {
        return this.addJvmOptions(value, true);
    }

    public int addJvmOptions(String value, boolean overwrite) throws ConfigException {
        return this.addValue(JVM_OPTIONS, value, overwrite);
    }

    public int removeJvmOptions(String value) {
        return this.removeValue(JVM_OPTIONS, value);
    }

    public int removeJvmOptions(String value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(JVM_OPTIONS, value, overwrite);
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(JavaConfig.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getJavaHome() {
        return this.getAttributeValue(ServerTags.JAVA_HOME);
    }

    public void setJavaHome(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.JAVA_HOME, v, overwrite);
    }

    public void setJavaHome(String v) {
        this.setAttributeValue(ServerTags.JAVA_HOME, v);
    }

    public boolean isDebugEnabled() {
        return JavaConfig.toBoolean(this.getAttributeValue(ServerTags.DEBUG_ENABLED));
    }

    public void setDebugEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DEBUG_ENABLED, "" + v, overwrite);
    }

    public void setDebugEnabled(boolean v) {
        this.setAttributeValue(ServerTags.DEBUG_ENABLED, "" + v);
    }

    public String getDebugOptions() {
        return this.getAttributeValue(ServerTags.DEBUG_OPTIONS);
    }

    public void setDebugOptions(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DEBUG_OPTIONS, v, overwrite);
    }

    public void setDebugOptions(String v) {
        this.setAttributeValue(ServerTags.DEBUG_OPTIONS, v);
    }

    public String getRmicOptions() {
        return this.getAttributeValue(ServerTags.RMIC_OPTIONS);
    }

    public void setRmicOptions(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.RMIC_OPTIONS, v, overwrite);
    }

    public void setRmicOptions(String v) {
        this.setAttributeValue(ServerTags.RMIC_OPTIONS, v);
    }

    public String getJavacOptions() {
        return this.getAttributeValue(ServerTags.JAVAC_OPTIONS);
    }

    public void setJavacOptions(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.JAVAC_OPTIONS, v, overwrite);
    }

    public void setJavacOptions(String v) {
        this.setAttributeValue(ServerTags.JAVAC_OPTIONS, v);
    }

    public String getClasspathPrefix() {
        return this.getAttributeValue(ServerTags.CLASSPATH_PREFIX);
    }

    public void setClasspathPrefix(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.CLASSPATH_PREFIX, v, overwrite);
    }

    public void setClasspathPrefix(String v) {
        this.setAttributeValue(ServerTags.CLASSPATH_PREFIX, v);
    }

    public String getClasspathSuffix() {
        return this.getAttributeValue(ServerTags.CLASSPATH_SUFFIX);
    }

    public void setClasspathSuffix(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.CLASSPATH_SUFFIX, v, overwrite);
    }

    public void setClasspathSuffix(String v) {
        this.setAttributeValue(ServerTags.CLASSPATH_SUFFIX, v);
    }

    public String getServerClasspath() {
        return this.getAttributeValue(ServerTags.SERVER_CLASSPATH);
    }

    public void setServerClasspath(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.SERVER_CLASSPATH, v, overwrite);
    }

    public void setServerClasspath(String v) {
        this.setAttributeValue(ServerTags.SERVER_CLASSPATH, v);
    }

    public String getNativeLibraryPathPrefix() {
        return this.getAttributeValue(ServerTags.NATIVE_LIBRARY_PATH_PREFIX);
    }

    public void setNativeLibraryPathPrefix(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.NATIVE_LIBRARY_PATH_PREFIX, v, overwrite);
    }

    public void setNativeLibraryPathPrefix(String v) {
        this.setAttributeValue(ServerTags.NATIVE_LIBRARY_PATH_PREFIX, v);
    }

    public String getNativeLibraryPathSuffix() {
        return this.getAttributeValue(ServerTags.NATIVE_LIBRARY_PATH_SUFFIX);
    }

    public void setNativeLibraryPathSuffix(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.NATIVE_LIBRARY_PATH_SUFFIX, v, overwrite);
    }

    public void setNativeLibraryPathSuffix(String v) {
        this.setAttributeValue(ServerTags.NATIVE_LIBRARY_PATH_SUFFIX, v);
    }

    public String getBytecodePreprocessors() {
        return this.getAttributeValue(ServerTags.BYTECODE_PREPROCESSORS);
    }

    public void setBytecodePreprocessors(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.BYTECODE_PREPROCESSORS, v, overwrite);
    }

    public void setBytecodePreprocessors(String v) {
        this.setAttributeValue(ServerTags.BYTECODE_PREPROCESSORS, v);
    }

    public boolean isEnvClasspathIgnored() {
        return JavaConfig.toBoolean(this.getAttributeValue(ServerTags.ENV_CLASSPATH_IGNORED));
    }

    public void setEnvClasspathIgnored(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ENV_CLASSPATH_IGNORED, "" + v, overwrite);
    }

    public void setEnvClasspathIgnored(boolean v) {
        this.setAttributeValue(ServerTags.ENV_CLASSPATH_IGNORED, "" + v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "java-config";
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals(ServerTags.JAVA_HOME)) {
            return "${com.sun.aas.javaRoot}".trim();
        }
        if (attr.equals(ServerTags.DEBUG_ENABLED)) {
            return "false".trim();
        }
        if (attr.equals(ServerTags.DEBUG_OPTIONS)) {
            return "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n".trim();
        }
        if (attr.equals(ServerTags.RMIC_OPTIONS)) {
            return "-iiop -poa -alwaysgenerate -keepgenerated -g".trim();
        }
        if (attr.equals(ServerTags.JAVAC_OPTIONS)) {
            return "-g".trim();
        }
        if (attr.equals(ServerTags.ENV_CLASSPATH_IGNORED)) {
            return "true".trim();
        }
        return null;
    }

    public static String getDefaultJavaHome() {
        return "${com.sun.aas.javaRoot}".trim();
    }

    public static String getDefaultDebugEnabled() {
        return "false".trim();
    }

    public static String getDefaultDebugOptions() {
        return "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n".trim();
    }

    public static String getDefaultRmicOptions() {
        return "-iiop -poa -alwaysgenerate -keepgenerated -g".trim();
    }

    public static String getDefaultJavacOptions() {
        return "-g".trim();
    }

    public static String getDefaultEnvClasspathIgnored() {
        return "true".trim();
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(PROFILER);
        ConfigBean n = this.getProfiler();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(PROFILER, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("JavaConfig\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

