/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class HttpListener
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String SSL = "Ssl";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public HttpListener() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public HttpListener(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("ssl", SSL, 66064, Ssl.class);
        this.createAttribute(SSL, "cert-nickname", "CertNickname", 257, null, null);
        this.createAttribute(SSL, "ssl2-enabled", "Ssl2Enabled", 1, null, "false");
        this.createAttribute(SSL, "ssl2-ciphers", "Ssl2Ciphers", 513, null, null);
        this.createAttribute(SSL, "ssl3-enabled", "Ssl3Enabled", 1, null, "true");
        this.createAttribute(SSL, "ssl3-tls-ciphers", "Ssl3TlsCiphers", 513, null, null);
        this.createAttribute(SSL, "tls-enabled", "TlsEnabled", 1, null, "true");
        this.createAttribute(SSL, "tls-rollback-enabled", "TlsRollbackEnabled", 1, null, "true");
        this.createAttribute(SSL, "client-auth-enabled", "ClientAuthEnabled", 1, null, "false");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setSsl(Ssl value) {
        this.setValue(SSL, value);
    }

    public Ssl getSsl() {
        return (Ssl)this.getValue(SSL);
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(HttpListener.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getId() {
        return this.getAttributeValue(ServerTags.ID);
    }

    public void setId(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ID, v, overwrite);
    }

    public void setId(String v) {
        this.setAttributeValue(ServerTags.ID, v);
    }

    public String getAddress() {
        return this.getAttributeValue(ServerTags.ADDRESS);
    }

    public void setAddress(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ADDRESS, v, overwrite);
    }

    public void setAddress(String v) {
        this.setAttributeValue(ServerTags.ADDRESS, v);
    }

    public String getPort() {
        return this.getAttributeValue(ServerTags.PORT);
    }

    public void setPort(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.PORT, v, overwrite);
    }

    public void setPort(String v) {
        this.setAttributeValue(ServerTags.PORT, v);
    }

    public String getExternalPort() {
        return this.getAttributeValue(ServerTags.EXTERNAL_PORT);
    }

    public void setExternalPort(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.EXTERNAL_PORT, v, overwrite);
    }

    public void setExternalPort(String v) {
        this.setAttributeValue(ServerTags.EXTERNAL_PORT, v);
    }

    public String getFamily() {
        return this.getAttributeValue(ServerTags.FAMILY);
    }

    public void setFamily(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.FAMILY, v, overwrite);
    }

    public void setFamily(String v) {
        this.setAttributeValue(ServerTags.FAMILY, v);
    }

    public boolean isBlockingEnabled() {
        return HttpListener.toBoolean(this.getAttributeValue(ServerTags.BLOCKING_ENABLED));
    }

    public void setBlockingEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.BLOCKING_ENABLED, "" + v, overwrite);
    }

    public void setBlockingEnabled(boolean v) {
        this.setAttributeValue(ServerTags.BLOCKING_ENABLED, "" + v);
    }

    public String getAcceptorThreads() {
        return this.getAttributeValue(ServerTags.ACCEPTOR_THREADS);
    }

    public void setAcceptorThreads(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ACCEPTOR_THREADS, v, overwrite);
    }

    public void setAcceptorThreads(String v) {
        this.setAttributeValue(ServerTags.ACCEPTOR_THREADS, v);
    }

    public boolean isSecurityEnabled() {
        return HttpListener.toBoolean(this.getAttributeValue(ServerTags.SECURITY_ENABLED));
    }

    public void setSecurityEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.SECURITY_ENABLED, "" + v, overwrite);
    }

    public void setSecurityEnabled(boolean v) {
        this.setAttributeValue(ServerTags.SECURITY_ENABLED, "" + v);
    }

    public String getDefaultVirtualServer() {
        return this.getAttributeValue(ServerTags.DEFAULT_VIRTUAL_SERVER);
    }

    public void setDefaultVirtualServer(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DEFAULT_VIRTUAL_SERVER, v, overwrite);
    }

    public void setDefaultVirtualServer(String v) {
        this.setAttributeValue(ServerTags.DEFAULT_VIRTUAL_SERVER, v);
    }

    public String getServerName() {
        return this.getAttributeValue(ServerTags.SERVER_NAME);
    }

    public void setServerName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.SERVER_NAME, v, overwrite);
    }

    public void setServerName(String v) {
        this.setAttributeValue(ServerTags.SERVER_NAME, v);
    }

    public String getRedirectPort() {
        return this.getAttributeValue(ServerTags.REDIRECT_PORT);
    }

    public void setRedirectPort(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.REDIRECT_PORT, v, overwrite);
    }

    public void setRedirectPort(String v) {
        this.setAttributeValue(ServerTags.REDIRECT_PORT, v);
    }

    public boolean isXpoweredBy() {
        return HttpListener.toBoolean(this.getAttributeValue(ServerTags.XPOWERED_BY));
    }

    public void setXpoweredBy(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.XPOWERED_BY, "" + v, overwrite);
    }

    public void setXpoweredBy(boolean v) {
        this.setAttributeValue(ServerTags.XPOWERED_BY, "" + v);
    }

    public boolean isEnabled() {
        return HttpListener.toBoolean(this.getAttributeValue(ServerTags.ENABLED));
    }

    public void setEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ENABLED, "" + v, overwrite);
    }

    public void setEnabled(boolean v) {
        this.setAttributeValue(ServerTags.ENABLED, "" + v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "http-listener" + (this.canHaveSiblings() ? "[@id='" + this.getAttributeValue("id") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals(ServerTags.FAMILY)) {
            return "inet".trim();
        }
        if (attr.equals(ServerTags.BLOCKING_ENABLED)) {
            return "false".trim();
        }
        if (attr.equals(ServerTags.ACCEPTOR_THREADS)) {
            return "10".trim();
        }
        if (attr.equals(ServerTags.SECURITY_ENABLED)) {
            return "false".trim();
        }
        if (attr.equals(ServerTags.XPOWERED_BY)) {
            return "true".trim();
        }
        if (attr.equals(ServerTags.ENABLED)) {
            return "true".trim();
        }
        return null;
    }

    public static String getDefaultFamily() {
        return "inet".trim();
    }

    public static String getDefaultBlockingEnabled() {
        return "false".trim();
    }

    public static String getDefaultAcceptorThreads() {
        return "10".trim();
    }

    public static String getDefaultSecurityEnabled() {
        return "false".trim();
    }

    public static String getDefaultXpoweredBy() {
        return "true".trim();
    }

    public static String getDefaultEnabled() {
        return "true".trim();
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(SSL);
        ConfigBean n = this.getSsl();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SSL, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("HttpListener\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

