/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.ReferenceHelperBase;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;

public class ApplicationHelper
extends ReferenceHelperBase {
    protected static final StringManager _strMgr = StringManager.getManager(ApplicationHelper.class);
    private static ApplicationHelper _theInstance;

    protected Server[] getReferencingServers(ConfigContext configContext, String name) throws ConfigException {
        return ServerHelper.getServersReferencingApplication(configContext, name);
    }

    protected Cluster[] getReferencingClusters(ConfigContext configContext, String name) throws ConfigException {
        return ClusterHelper.getClustersReferencingApplication(configContext, name);
    }

    private static synchronized ApplicationHelper getInstance() {
        if (_theInstance == null) {
            _theInstance = new ApplicationHelper();
        }
        return _theInstance;
    }

    public static boolean isApplicationReferenced(ConfigContext configContext, String appName) throws ConfigException {
        return ApplicationHelper.getInstance().isReferenced(configContext, appName);
    }

    public static boolean isApplicationReferencedByServerOnly(ConfigContext configContext, String appName, String serverName) throws ConfigException {
        return ApplicationHelper.getInstance().isReferencedByServerOnly(configContext, appName, serverName);
    }

    public static boolean isApplicationReferencedByClusterOnly(ConfigContext configContext, String appName, String clusterName) throws ConfigException {
        return ApplicationHelper.getInstance().isReferencedByClusterOnly(configContext, appName, clusterName);
    }

    public static String getApplicationReferenceesAsString(ConfigContext configContext, String appName) throws ConfigException {
        return ApplicationHelper.getInstance().getReferenceesAsString(configContext, appName);
    }

    public static String getApplicationType(ConfigContext ctx, String id) throws ConfigException {
        ConfigBean appBean = ApplicationHelper.findApplication(ctx, id);
        if (appBean instanceof J2eeApplication) {
            return "J2eeApplication";
        }
        if (appBean instanceof EjbModule) {
            return "EjbModule";
        }
        if (appBean instanceof WebModule) {
            return "WebModule";
        }
        if (appBean instanceof LifecycleModule) {
            return "LifecycleModule";
        }
        if (appBean instanceof AppclientModule) {
            return "AppclientModule";
        }
        if (appBean instanceof ConnectorModule) {
            return "ConnectorModule";
        }
        return null;
    }

    public static ConfigBean findApplication(ConfigContext configContext, String appName) throws ConfigException {
        Applications root = ((Domain)configContext.getRootConfigBean()).getApplications();
        ConfigBean app = root.getJ2eeApplicationByName(appName);
        if (app != null) {
            return app;
        }
        app = root.getEjbModuleByName(appName);
        if (app != null) {
            return app;
        }
        app = root.getWebModuleByName(appName);
        if (app != null) {
            return app;
        }
        app = root.getConnectorModuleByName(appName);
        if (app != null) {
            return app;
        }
        app = root.getAppclientModuleByName(appName);
        if (app != null) {
            return app;
        }
        app = root.getLifecycleModuleByName(appName);
        if (app != null) {
            return app;
        }
        return null;
    }

    public static String[] getApplicationsInDomain(ConfigContext configContext) throws ConfigException {
        ArrayList<String> result = new ArrayList<String>();
        Domain domain = ConfigAPIHelper.getDomainConfigBean(configContext);
        Applications applications = domain.getApplications();
        AppclientModule[] appclients = applications.getAppclientModule();
        for (int i = 0; i < appclients.length; ++i) {
            result.add(appclients[i].getName());
        }
        ConnectorModule[] connectors = applications.getConnectorModule();
        for (int i = 0; i < connectors.length; ++i) {
            result.add(connectors[i].getName());
        }
        EjbModule[] ebjs = applications.getEjbModule();
        for (int i = 0; i < ebjs.length; ++i) {
            result.add(ebjs[i].getName());
        }
        J2eeApplication[] apps = applications.getJ2eeApplication();
        for (int i = 0; i < apps.length; ++i) {
            result.add(apps[i].getName());
        }
        LifecycleModule[] lifecycles = applications.getLifecycleModule();
        for (int i = 0; i < lifecycles.length; ++i) {
            result.add(lifecycles[i].getName());
        }
        WebModule[] webs = applications.getWebModule();
        for (int i = 0; i < webs.length; ++i) {
            result.add(webs[i].getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean isSystemApp(ConfigContext ctx, String appId) throws ConfigException {
        ConfigBean bean = ApplicationHelper.findApplication(ctx, appId);
        if (bean == null) {
            throw new ConfigException(_strMgr.getString("noSuchApplication", appId));
        }
        String objectType = null;
        try {
            objectType = bean.getAttributeValue(ServerTags.OBJECT_TYPE);
        }
        catch (Exception ex) {
            return false;
        }
        return objectType.equals("system-all") || objectType.equals("system-admin") || objectType.equals("system-instance");
    }
}

