/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.clientbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.clientbeans.AuthRealm;
import com.sun.enterprise.config.clientbeans.ClientCredential;
import com.sun.enterprise.config.clientbeans.ClientTags;
import com.sun.enterprise.config.clientbeans.ElementProperty;
import com.sun.enterprise.config.clientbeans.LogService;
import com.sun.enterprise.config.clientbeans.MessageSecurityConfig;
import com.sun.enterprise.config.clientbeans.TargetServer;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GraphManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ClientContainer
extends ConfigBean
implements Serializable {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.config");
    static Vector comparators = new Vector();
    private static final long serialVersionUID = 1L;
    public static final String TARGET_SERVER = "TargetServer";
    public static final String AUTH_REALM = "AuthRealm";
    public static final String CLIENT_CREDENTIAL = "ClientCredential";
    public static final String LOG_SERVICE = "LogService";
    public static final String MESSAGE_SECURITY_CONFIG = "MessageSecurityConfig";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public ClientContainer() {
        this(null, Common.USE_DEFAULT_VALUES);
    }

    public ClientContainer(Node doc, int options) {
        this(Common.NO_DEFAULT_VALUES);
        this.initFromNode(doc, options);
    }

    protected void initFromNode(Node doc, int options) {
        if (doc == null && (doc = GraphManager.createRootElementNode((String)"client-container")) == null) {
            throw new RuntimeException(Common.getMessage((String)"CantCreateDOMRoot_msg", (Object)"client-container"));
        }
        Node n = GraphManager.getElementNode((String)"client-container", (Node)doc);
        if (n == null) {
            throw new RuntimeException(Common.getMessage((String)"DocRootNotInDOMGraph_msg", (Object)"client-container", (Object)doc.getFirstChild().getNodeName()));
        }
        this.graphManager.setXmlDocument(doc);
        this.createBean(n, this.graphManager());
        this.initialize(options);
    }

    public ClientContainer(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.initOptions(options);
    }

    protected void initOptions(int options) {
        this.graphManager = new GraphManager((BaseBean)this);
        this.createRoot("client-container", "ClientContainer", 544, ClientContainer.class);
        this.createProperty("target-server", TARGET_SERVER, 66080, TargetServer.class);
        this.createAttribute(TARGET_SERVER, "name", "Name", 257, null, null);
        this.createAttribute(TARGET_SERVER, "address", "Address", 257, null, null);
        this.createAttribute(TARGET_SERVER, "port", "Port", 257, null, null);
        this.createProperty("auth-realm", AUTH_REALM, 66064, AuthRealm.class);
        this.createAttribute(AUTH_REALM, "name", "Name", 257, null, null);
        this.createAttribute(AUTH_REALM, "classname", "Classname", 257, null, null);
        this.createProperty("client-credential", CLIENT_CREDENTIAL, 66064, ClientCredential.class);
        this.createAttribute(CLIENT_CREDENTIAL, "user-name", "UserName", 257, null, null);
        this.createAttribute(CLIENT_CREDENTIAL, "password", "Password", 257, null, null);
        this.createAttribute(CLIENT_CREDENTIAL, "realm", "Realm", 513, null, null);
        this.createProperty("log-service", LOG_SERVICE, 66064, LogService.class);
        this.createAttribute(LOG_SERVICE, "file", "File", 513, null, null);
        this.createAttribute(LOG_SERVICE, "level", "Level", 1, null, "SEVERE");
        this.createProperty("message-security-config", MESSAGE_SECURITY_CONFIG, 66096, MessageSecurityConfig.class);
        this.createAttribute(MESSAGE_SECURITY_CONFIG, "auth-layer", "AuthLayer", 257, null, null);
        this.createAttribute(MESSAGE_SECURITY_CONFIG, "default-provider", "DefaultProvider", 513, null, null);
        this.createAttribute(MESSAGE_SECURITY_CONFIG, "default-client-provider", "DefaultClientProvider", 513, null, null);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.createAttribute("send-password", "SendPassword", 1, null, "true");
        this.initialize(options);
    }

    void initialize(int options) {
        this.setAttributeValue(ClientTags.SEND_PASSWORD, "true");
    }

    public void setTargetServer(TargetServer value) {
        this.setValue(TARGET_SERVER, value);
    }

    public TargetServer getTargetServer() {
        return (TargetServer)this.getValue(TARGET_SERVER);
    }

    public void setAuthRealm(AuthRealm value) {
        this.setValue(AUTH_REALM, value);
    }

    public AuthRealm getAuthRealm() {
        return (AuthRealm)this.getValue(AUTH_REALM);
    }

    public void setClientCredential(ClientCredential value) {
        this.setValue(CLIENT_CREDENTIAL, value);
    }

    public ClientCredential getClientCredential() {
        return (ClientCredential)this.getValue(CLIENT_CREDENTIAL);
    }

    public void setLogService(LogService value) {
        this.setValue(LOG_SERVICE, value);
    }

    public LogService getLogService() {
        return (LogService)this.getValue(LOG_SERVICE);
    }

    public void setMessageSecurityConfig(int index, MessageSecurityConfig value) {
        this.setValue(MESSAGE_SECURITY_CONFIG, index, value);
    }

    public MessageSecurityConfig getMessageSecurityConfig(int index) {
        return (MessageSecurityConfig)this.getValue(MESSAGE_SECURITY_CONFIG, index);
    }

    public void setMessageSecurityConfig(MessageSecurityConfig[] value) {
        this.setValue(MESSAGE_SECURITY_CONFIG, value);
    }

    public MessageSecurityConfig[] getMessageSecurityConfig() {
        return (MessageSecurityConfig[])this.getValues(MESSAGE_SECURITY_CONFIG);
    }

    public int sizeMessageSecurityConfig() {
        return this.size(MESSAGE_SECURITY_CONFIG);
    }

    public int addMessageSecurityConfig(MessageSecurityConfig value) throws ConfigException {
        return this.addMessageSecurityConfig(value, true);
    }

    public int addMessageSecurityConfig(MessageSecurityConfig value, boolean overwrite) throws ConfigException {
        MessageSecurityConfig old = this.getMessageSecurityConfigByAuthLayer(value.getAuthLayer());
        if (old != null) {
            throw new ConfigException("MessageSecurityConfig Already Exists: cannot add duplicate");
        }
        return this.addValue(MESSAGE_SECURITY_CONFIG, value, overwrite);
    }

    public int removeMessageSecurityConfig(MessageSecurityConfig value) {
        return this.removeValue(MESSAGE_SECURITY_CONFIG, value);
    }

    public int removeMessageSecurityConfig(MessageSecurityConfig value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(MESSAGE_SECURITY_CONFIG, value, overwrite);
    }

    public MessageSecurityConfig getMessageSecurityConfigByAuthLayer(String id) {
        MessageSecurityConfig[] o = this.getMessageSecurityConfig();
        if (o == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ClientTags.AUTH_LAYER)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException("ElementProperty Already Exists: cannot add duplicate");
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o = this.getElementProperty();
        if (o == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ClientTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public boolean isSendPassword() {
        return ClientContainer.toBoolean(this.getAttributeValue(ClientTags.SEND_PASSWORD));
    }

    public void setSendPassword(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ClientTags.SEND_PASSWORD, "" + v, overwrite);
        this.changed();
    }

    public void setSendPassword(boolean v) {
        this.setAttributeValue(ClientTags.SEND_PASSWORD, "" + v);
        this.changed();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "client-container";
        return ret;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static ClientContainer createGraph(Node doc) {
        return new ClientContainer(doc, Common.NO_DEFAULT_VALUES);
    }

    public static ClientContainer createGraph(InputStream in) {
        return ClientContainer.createGraph(in, false);
    }

    public static ClientContainer createGraph(InputStream in, boolean validate) {
        try {
            Document doc = GraphManager.createXmlDocument((InputStream)in, (boolean)validate);
            return ClientContainer.createGraph(doc);
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "config.graph_create_exception", t);
            throw new RuntimeException(Common.getMessage((String)"DOMGraphCreateFailed_msg", (Object)t.getMessage()));
        }
    }

    public static ClientContainer createGraph() {
        return new ClientContainer();
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if (attr.equals(ClientTags.SEND_PASSWORD)) {
            return "true";
        }
        return null;
    }

    public static String getDefaultSendPassword() {
        return "true";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int MAX_SIZE = 65535;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        byte[] array = baos.toByteArray();
        int numStrings = array.length / 65535;
        int leftover = array.length % 65535;
        out.writeInt(numStrings + (0 == leftover ? 0 : 1));
        out.writeInt(65535);
        int offset = 0;
        for (int i = 0; i < numStrings; ++i) {
            out.writeUTF(new String(array, offset, 65535));
            offset += 65535;
        }
        if (leftover > 0) {
            int count = array.length - offset;
            out.writeUTF(new String(array, offset, count));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.init(comparators, new GenBeans.Version(1, 0, 8));
        int numStrings = in.readInt();
        int max_size = in.readInt();
        StringBuffer sb = new StringBuffer(numStrings * max_size);
        for (int i = 0; i < numStrings; ++i) {
            sb.append(in.readUTF());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(sb.toString().getBytes());
        Document doc = GraphManager.createXmlDocument((InputStream)bais, (boolean)false);
        this.initOptions(Common.NO_DEFAULT_VALUES);
        this.initFromNode(doc, Common.NO_DEFAULT_VALUES);
    }

    public void dump(StringBuffer str, String indent) {
        int i;
        str.append(indent);
        str.append(TARGET_SERVER);
        ConfigBean n = this.getTargetServer();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(TARGET_SERVER, 0, str, indent);
        str.append(indent);
        str.append(AUTH_REALM);
        n = this.getAuthRealm();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(AUTH_REALM, 0, str, indent);
        str.append(indent);
        str.append(CLIENT_CREDENTIAL);
        n = this.getClientCredential();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(CLIENT_CREDENTIAL, 0, str, indent);
        str.append(indent);
        str.append(LOG_SERVICE);
        n = this.getLogService();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(LOG_SERVICE, 0, str, indent);
        str.append(indent);
        str.append("MessageSecurityConfig[" + this.sizeMessageSecurityConfig() + "]");
        for (i = 0; i < this.sizeMessageSecurityConfig(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getMessageSecurityConfig(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(MESSAGE_SECURITY_CONFIG, i, str, indent);
        }
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("ClientContainer\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

