/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigRuntimeException;
import com.sun.enterprise.config.impl.ConfigContextImpl;
import com.sun.enterprise.config.pluggable.ConfigEnvironment;
import com.sun.enterprise.config.pluggable.EnvironmentFactory;
import java.util.Hashtable;

public class ConfigContextFactory {
    private static Hashtable _ctxCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConfigContext createConfigContext(String url, String rootClass) {
        ConfigEnvironment ce = ConfigContextFactory.getConfigEnvironment();
        ce.setUrl(url);
        ce.setRootClass(rootClass);
        return ConfigContextFactory.createConfigContext(ce);
    }

    public static ConfigContext createConfigContext(ConfigEnvironment ce) {
        if (!ce.isCachingEnabled()) {
            return ConfigContextFactory.newConfigContext(ce);
        }
        ConfigContext context = ConfigContextFactory.getConfigContextFromCache(ce.getUrl());
        if (context == null) {
            context = ConfigContextFactory.newConfigContext(ce);
            ConfigContextFactory.addConfigContextToCache(ce.getUrl(), context);
        }
        return context;
    }

    public static void removeConfigContext(ConfigContext ctx) {
        String url = ctx.getUrl();
        ConfigContextFactory.removeConfigContext(url);
    }

    public static synchronized void removeConfigContext(String url) {
        Object obj = _ctxCache.remove(url);
        ConfigContextFactory.invalidateConfigContext(obj);
    }

    public static synchronized void replaceConfigContext(ConfigContext oldCtx, ConfigContext newCtx) throws ConfigException {
        if (!$assertionsDisabled && oldCtx == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && newCtx == null) {
            throw new AssertionError();
        }
        String url = oldCtx.getUrl();
        if (!_ctxCache.containsKey(url)) {
            throw new ConfigException("Old ConfigContext is not found. Cannot replace with new one");
        }
        _ctxCache.put(url, newCtx);
    }

    public static boolean enableLastModifiedCheck(ConfigContext ctx, boolean value) {
        return ((ConfigContextImpl)ctx).enableLastModifiedCheck(value);
    }

    private static ConfigEnvironment getConfigEnvironment() {
        ConfigEnvironment ce = null;
        try {
            ce = EnvironmentFactory.getEnvironmentFactory().getConfigEnvironment();
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("err_getting_config_env", "err_getting_config_env", e);
        }
        return ce;
    }

    public static ConfigContext getConfigContextFromCache(String url) {
        return (ConfigContext)_ctxCache.get(url);
    }

    private static ConfigContext newConfigContext(ConfigEnvironment ce) {
        return new ConfigContextImpl(ce);
    }

    private static void addConfigContextToCache(String url, ConfigContext ctx) {
        _ctxCache.put(url, ctx);
    }

    private static void invalidateConfigContext(Object obj) {
        try {
            if (obj != null) {
                ((ConfigContextImpl)obj).cleanup();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        $assertionsDisabled = !ConfigContextFactory.class.desiredAssertionStatus();
        _ctxCache = new Hashtable();
    }
}

