/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import javax.management.Notification;

public class ConfigContextEvent
extends Notification {
    public static final String PRE_ACCESS = "PRE_ACCESS";
    public static final String POST_ACCESS = "POST_ACCESS";
    public static final String PRE_ADD_CHANGE = "PRE_ADD_CHANGE";
    public static final String POST_ADD_CHANGE = "POST_ADD_CHANGE";
    public static final String PRE_UPDATE_CHANGE = "PRE_UPDATE_CHANGE";
    public static final String POST_UPDATE_CHANGE = "POST_UPDATE_CHANGE";
    public static final String PRE_DELETE_CHANGE = "PRE_DELETE_CHANGE";
    public static final String POST_DELETE_CHANGE = "POST_DELETE_CHANGE";
    public static final String PRE_SET_CHANGE = "PRE_SET_CHANGE";
    public static final String POST_SET_CHANGE = "POST_SET_CHANGE";
    public static final String PRE_FLUSH_CHANGE = "PRE_FLUSH_CHANGE";
    public static final String POST_FLUSH_CHANGE = "POST_FLUSH_CHANGE";
    private static long eventCounter = 0L;
    private String name;
    private Object value;
    private String choice;
    private String beanName;
    private Object classObject;

    public ConfigContextEvent(ConfigContext ctx, String eventType) {
        super(eventType, (Object)ctx, ++eventCounter, System.currentTimeMillis());
    }

    public ConfigContextEvent(ConfigContext ctx, String eventType, String name, Object value, String choice) {
        this(ctx, eventType, name, value, choice, null);
    }

    public ConfigContextEvent(ConfigContext ctx, String eventType, String name, Object value, String choice, String beanName) {
        this(ctx, eventType);
        this.name = name;
        this.value = value;
        this.choice = choice;
        this.beanName = beanName;
    }

    public Object getObject() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getChoice() {
        return this.choice;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public ConfigContext getConfigContext() {
        return (ConfigContext)this.getSource();
    }

    public String toString() {
        return this.getClass().getName() + " -- " + " [Id:" + this.getSequenceNumber() + ", ts:" + this.getTimeStamp() + "]";
    }

    public Object getClassObject() {
        return this.classObject;
    }

    public void setClassObject(Object obj) {
        this.classObject = obj;
    }

    public ConfigBean getValidationTarget() throws ConfigException {
        String choice = this.getChoice();
        if (choice.equals("ADD")) {
            return (ConfigBean)this.getObject();
        }
        if (choice.equals("DELETE")) {
            return (ConfigBean)this.getObject();
        }
        if (choice.equals("UPDATE")) {
            return (ConfigBean)this.getClassObject();
        }
        if (choice.equals("SET")) {
            if (null == this.getBeanName()) {
                if (this.getName().equals("Description")) {
                    throw new ConfigException("Internal error - invalid condition - attempting to validate a SET operation with a \"Description\" object");
                }
                return (ConfigBean)this.getObject();
            }
            return (ConfigBean)this.getClassObject();
        }
        throw new ConfigException("Internal error - invalid choice received: \"" + choice + "\". Only expecting ADD, DELETE, UPDATE or SET");
    }
}

