/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appclient.ACCEntityResolver;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.appclient.DummyRoleMapperFactory;
import com.sun.enterprise.appclient.HttpAuthenticator;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.clientbeans.ClientBeansFactory;
import com.sun.enterprise.config.clientbeans.ClientContainer;
import com.sun.enterprise.config.clientbeans.ClientCredential;
import com.sun.enterprise.config.clientbeans.ElementProperty;
import com.sun.enterprise.config.clientbeans.Security;
import com.sun.enterprise.config.clientbeans.Ssl;
import com.sun.enterprise.config.clientbeans.TargetServer;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.InputJarArchive;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.security.GUIErrorDialog;
import com.sun.enterprise.security.KeyTool;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.logging.ACCLogManager;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import com.sun.web.server.HttpsURLStreamHandlerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;

public class Main {
    private static final String CLIENT = "-client";
    private static final String NAME = "-name";
    private static final String MAIN_CLASS = "-mainclass";
    private static final String TEXT_AUTH = "-textauth";
    private static final String XML_PATH = "-xml";
    private static final String ACC_CONFIG_XML = "-configxml";
    private static final String DEFAULT_CLIENT_CONTAINER_XML = "sun-acc.xml";
    private static final String SUNACC_XML_URL = "sun-acc.xml.url";
    private static final String NO_APP_INVOKE = "-noappinvoke";
    private static final String USER = "-user";
    private static final String PASSWORD = "-password";
    private static final String PASSWORD_FILE = "-passwordfile";
    private static final String LOGIN_NAME = "j2eelogin.name";
    private static final String LOGIN_PASSWORD = "j2eelogin.password";
    private static final String DASH = "-";
    private static Logger _logger;
    private static final boolean debug = false;
    private static StringManager localStrings;
    private static boolean guiAuth;
    private static boolean runClient;
    private static String host;
    private static String port;

    public static void main(String[] args) {
        new Main(args);
    }

    public Main(String[] args) {
        String arg = null;
        String clientJar = null;
        String displayName = null;
        String mainClass = null;
        String xmlPath = null;
        String accConfigXml = null;
        Vector<String> appArgs = new Vector<String>();
        int i = 0;
        guiAuth = Boolean.valueOf(System.getProperty("auth.gui", "true"));
        if (args.length < 1) {
            Main.usage();
        } else {
            while (i < args.length) {
                if ((arg = args[i++]).equals(CLIENT)) {
                    if (i < args.length && !args[i].startsWith(DASH)) {
                        clientJar = args[i++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(NAME) && !args[i].startsWith(DASH)) {
                    if (i < args.length && mainClass == null) {
                        displayName = args[i++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(MAIN_CLASS) && !args[i].startsWith(DASH)) {
                    if (i < args.length && displayName == null) {
                        mainClass = args[i++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(XML_PATH)) {
                    if (i < args.length && xmlPath == null) {
                        xmlPath = args[i++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(ACC_CONFIG_XML)) {
                    if (i < args.length && accConfigXml == null) {
                        accConfigXml = args[i++];
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(TEXT_AUTH)) {
                    guiAuth = false;
                    continue;
                }
                if (arg.equals(NO_APP_INVOKE)) {
                    runClient = false;
                    continue;
                }
                if (arg.equals(USER)) {
                    if (i < args.length) {
                        System.setProperty(LOGIN_NAME, args[i++]);
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(PASSWORD)) {
                    if (i < args.length) {
                        System.setProperty(LOGIN_PASSWORD, args[i++]);
                        continue;
                    }
                    Main.usage();
                    continue;
                }
                if (arg.equals(PASSWORD_FILE)) {
                    if (i < args.length) {
                        try {
                            System.setProperty(LOGIN_PASSWORD, this.loadPasswordFromFile(args[i++]));
                            continue;
                        }
                        catch (IOException ex) {
                            throw new IllegalArgumentException(ex.getMessage());
                        }
                    }
                    Main.usage();
                    continue;
                }
                appArgs.add(arg);
            }
        }
        if (clientJar == null) {
            Main.usage();
        }
        if (xmlPath != null) {
            Main.validateXMLFile(xmlPath);
        } else if (accConfigXml != null) {
            Main.validateXMLFile(accConfigXml);
            xmlPath = accConfigXml;
        }
        _logger = LogDomains.getLogger("javax.enterprise.system.container.appclient");
        LogManager logMgr = LogManager.getLogManager();
        if (logMgr instanceof ACCLogManager) {
            ((ACCLogManager)logMgr).init(xmlPath);
        }
        Utility.checkJVMVersion();
        J2EESecurityManager securityMgr = new J2EESecurityManager();
        System.setSecurityManager(securityMgr);
        KeyTool.initProvider();
        try {
            SSLUtils.initStoresAtStartup();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, "main.ssl_keystore_init_failed", e);
            }
            _logger.log(Level.WARNING, "main.ssl_keystore_init_failed");
        }
        try {
            Main.setTargetServerProperties(xmlPath);
            boolean exitCode = false;
            AppContainer container = null;
            Cleanup cleanup = new Cleanup();
            Runtime runtime = Runtime.getRuntime();
            runtime.addShutdownHook(cleanup);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL.setURLStreamHandlerFactory(new HttpsURLStreamHandlerFactory());
                    return null;
                }
            });
            File appClientFile = new File(clientJar);
            URL[] urls = new URL[]{appClientFile.toURL()};
            URLClassLoader jcl = new URLClassLoader(urls);
            Thread.currentThread().setContextClassLoader(jcl);
            ApplicationClientDescriptor appDesc = null;
            this.registerRoleMapperFactory();
            if (FileUtil.isEARFile(appClientFile)) {
                ApplicationClientDescriptor next;
                Application app = null;
                try {
                    ApplicationArchivist arch = new ApplicationArchivist();
                    arch.setClassLoader(jcl);
                    app = (Application)arch.open(appClientFile);
                }
                catch (Throwable t) {
                    _logger.log(Level.WARNING, "acc.failed_load_client_desc", clientJar);
                    throw t;
                }
                app.setClassLoader(jcl);
                appDesc = null;
                int appclientCount = 0;
                Iterator itr = app.getApplicationClientDescriptors().iterator();
                while (itr.hasNext()) {
                    next = (ApplicationClientDescriptor)itr.next();
                    ++appclientCount;
                }
                itr = app.getApplicationClientDescriptors().iterator();
                while (itr.hasNext()) {
                    next = (ApplicationClientDescriptor)itr.next();
                    if (appclientCount == 1) {
                        if (mainClass != null && !next.getMainClassName().equals(mainClass)) {
                            next.setMainClassName(mainClass);
                        }
                        appDesc = next;
                        break;
                    }
                    if (mainClass != null) {
                        if (!next.getMainClassName().equals(mainClass)) continue;
                        appDesc = next;
                        break;
                    }
                    if (displayName == null) {
                        _logger.log(Level.SEVERE, "acc.no_mainclass_or_displayname");
                        System.exit(1);
                        continue;
                    }
                    if (displayName == null || !next.getName().equals(displayName)) continue;
                    if (appDesc == null) {
                        appDesc = next;
                        continue;
                    }
                    _logger.log(Level.WARNING, "acc.duplicate_display_name");
                    System.exit(1);
                }
                if (appDesc != null) {
                    container = new AppContainer(appDesc, guiAuth);
                }
            } else {
                try {
                    AppClientArchivist arch = new AppClientArchivist();
                    arch.setClassLoader(jcl);
                    appDesc = (ApplicationClientDescriptor)arch.open(appClientFile);
                }
                catch (Throwable t) {
                    _logger.log(Level.WARNING, "main.appclient_descriptors_failed", displayName == null ? mainClass : displayName);
                    throw t;
                }
                container = new AppContainer(appDesc, guiAuth);
            }
            if (container == null) {
                _logger.log(Level.WARNING, "acc.no_client_desc", displayName == null ? mainClass : displayName);
                System.exit(1);
            }
            Authenticator.setDefault(new HttpAuthenticator(container));
            _logger.log(Level.INFO, "acc.orb_host_name", host);
            _logger.log(Level.INFO, "acc.orb_port_number", port);
            Properties props = new Properties();
            props.put("org.omg.CORBA.ORBInitialHost", host);
            props.put("org.omg.CORBA.ORBInitialPort", port);
            String appMainClass = container.preInvoke(props);
            cleanup.setAppContainer(container);
            Class<?> cl = jcl.loadClass(appMainClass);
            _logger.log(Level.INFO, "acc.load_app_class", appMainClass);
            String[] applicationArgs = new String[appArgs.size()];
            for (int sz = 0; sz < applicationArgs.length; ++sz) {
                applicationArgs[sz] = (String)appArgs.elementAt(sz);
            }
            if (appDesc.hasWebServiceClients()) {
                File moduleFile;
                if (appDesc.getApplication() == null || appDesc.getApplication().isVirtual()) {
                    moduleFile = appClientFile;
                } else {
                    InputJarArchive earFile = new InputJarArchive();
                    earFile.open(appClientFile.getAbsolutePath());
                    String moduleName = appDesc.getModuleDescriptor().getArchiveUri();
                    InputStream is = earFile.getEntry(moduleName);
                    moduleFile = File.createTempFile("appclient", ".jar");
                    moduleFile.deleteOnExit();
                    FileOutputStream os = new FileOutputStream(moduleFile);
                    Archivist.copy(new BufferedInputStream(is), new BufferedOutputStream(os));
                    earFile.close();
                }
                Iterator itr = appDesc.getServiceReferenceDescriptors().iterator();
                while (itr.hasNext()) {
                    ServiceReferenceDescriptor serviceRef = (ServiceReferenceDescriptor)itr.next();
                    serviceRef.setWsdlFileUrl(FileUtil.getEntryAsUrl(moduleFile, serviceRef.getWsdlFileUri()));
                }
            }
            if (runClient) {
                Utility.invokeApplicationMain(cl, applicationArgs);
                _logger.info("Application main() finished normally");
            }
            this.shutDownSystemAdapters();
        }
        catch (InvocationTargetException ite) {
            Throwable tt = ite.getTargetException();
            _logger.log(Level.WARNING, "acc.app_exception", tt);
            this.shutDownSystemAdapters();
            System.exit(1);
        }
        catch (Throwable t) {
            if (t instanceof FailedLoginException) {
                _logger.info("acc.login_error");
                boolean isGui = Boolean.valueOf(System.getProperty("auth.gui", "true"));
                String errorMessage = localStrings.getString("main.exception.loginError", "Incorrect login and/or password");
                if (isGui) {
                    GUIErrorDialog ged = new GUIErrorDialog(errorMessage);
                    ged.show();
                }
            }
            _logger.log(Level.WARNING, "acc.app_exception", t);
            if (t instanceof NamingException) {
                _logger.log(Level.WARNING, "acc.naming_exception_received");
            }
            this.shutDownSystemAdapters();
            System.exit(1);
        }
    }

    private static void setTargetServerProperties(String clientXmlLocation) throws ConfigException {
        try {
            if (clientXmlLocation == null || clientXmlLocation.equals("")) {
                clientXmlLocation = DEFAULT_CLIENT_CONTAINER_XML;
            }
            System.setProperty(SUNACC_XML_URL, clientXmlLocation);
            _logger.log(Level.INFO, "acc.using_xml_location", clientXmlLocation);
            ConfigContext ctx = ConfigFactory.createConfigContext(clientXmlLocation, true, false, false, ClientContainer.class, new ACCEntityResolver());
            ClientContainer cc = ClientBeansFactory.getClientBean(ctx);
            host = cc.getTargetServer().getAddress();
            port = cc.getTargetServer().getPort();
            Main.setSSLData(cc);
            ClientCredential cCrd = cc.getClientCredential();
            if (cCrd != null) {
                if (System.getProperty(LOGIN_NAME) == null) {
                    _logger.config("using login name from client container xml...");
                    System.setProperty(LOGIN_NAME, cCrd.getUserName());
                }
                if (System.getProperty(LOGIN_PASSWORD) == null) {
                    _logger.config("using password from client container xml...");
                    System.setProperty(LOGIN_PASSWORD, cCrd.getPassword());
                }
            }
            ElementProperty[] props = cc.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                if (props[i].getName().equals("ssl") && props[i].getValue().equals("required")) {
                    ORBManager.getCSIv2Props().put("com.sun.CSIV2.ssl.client.required", "true");
                }
                if (props[i].getName().equals("com.sun.appserv.iiop.loadbalancingpolicy")) {
                    System.setProperty(props[i].getName(), props[i].getValue());
                }
                if (!props[i].getName().equals("com.sun.appserv.iiop.endpoints")) continue;
                System.setProperty(props[i].getName(), props[i].getValue());
            }
        }
        catch (ConfigException t) {
            _logger.log(Level.WARNING, "acc.acc_xml_file_error", new Object[]{clientXmlLocation, t.getMessage()});
            _logger.log(Level.FINE, "exception : " + t.toString(), t);
            throw t;
        }
    }

    private static void setSSLData(ClientContainer cc) {
        try {
            TargetServer tServer = cc.getTargetServer();
            Security security = tServer.getSecurity();
            if (security == null) {
                _logger.fine("No Security input set in ClientContainer.xml");
                return;
            }
            Ssl ssl = security.getSsl();
            if (ssl == null) {
                _logger.fine("No SSL input set in ClientContainer.xml");
                return;
            }
            SSLUtils.setAppclientSsl(ssl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void validateXMLFile(String xmlFullName) {
        if (xmlFullName == null || xmlFullName.startsWith(DASH)) {
            Main.usage();
        }
        try {
            File f = new File(xmlFullName);
            if (f != null && f.exists() && f.isFile() && f.canRead()) {
                return;
            }
            Main.xmlMessage(xmlFullName);
            Main.usage();
        }
        catch (Exception ex) {
            Main.xmlMessage(xmlFullName);
            Main.usage();
        }
    }

    private void shutDownSystemAdapters() {
        try {
            PoolManager poolmgr = Switch.getSwitch().getPoolManager();
            if (poolmgr != null) {
                Switch.getSwitch().getPoolManager().killFreeConnectionsInPools();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            ActiveResourceAdapter activeRar = registry.getActiveResourceAdapter(ConnectorRuntime.DEFAULT_JMS_ADAPTER);
            if (activeRar != null) {
                activeRar.destroy();
            }
        }
        catch (Exception e) {
            _logger.fine("Exception caught while shutting down system adapter:" + e.getMessage());
        }
    }

    private static void usage() {
        System.out.println(localStrings.getString("main.usage", "appclient -client <appjar> [-mainclass <appClass-name>|-name <display-name>] [-xml <xml>] [-textauth] [app-args]"));
        System.exit(1);
    }

    private static void xmlMessage(String xmlFullName) {
        System.out.println(localStrings.getString("main.cannot_read_clientContainer_xml", xmlFullName, "Client Container xml: " + xmlFullName + " not found or unable to read.\nYou may want to use the -xml option to locate your configuration xml."));
    }

    private final void registerRoleMapperFactory() {
        SaxParserHandler sph = new SaxParserHandler();
        DummyRoleMapperFactory srmf = new DummyRoleMapperFactory();
        SecurityRoleMapperFactoryMgr.registerFactory(srmf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadPasswordFromFile(String fileName) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(fileName));
            Properties props = new Properties();
            props.load(inputStream);
            String string = props.getProperty("PASSWORD");
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    static {
        localStrings = StringManager.getManager(Main.class);
        runClient = true;
    }

    private static class Cleanup
    extends Thread {
        private AppContainer appContainer = null;
        private boolean cleanedUp = false;

        public void setAppContainer(AppContainer container) {
            this.appContainer = container;
        }

        public void run() {
            this.cleanUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanUp() {
            if (!this.cleanedUp) {
                try {
                    if (this.appContainer != null) {
                        this.appContainer.postInvoke();
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.cleanedUp = true;
                }
            }
        }
    }
}

