/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.logging.LogDomains;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class HttpAuthenticator
extends Authenticator {
    public static final boolean debug = false;
    private AppContainer container = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.appclient");

    public HttpAuthenticator(AppContainer container) {
        this.container = container;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        String user = null;
        String password = null;
        Subject subject = null;
        String scheme = this.getRequestingScheme();
        _logger.fine("scheme=" + scheme);
        _logger.fine("requesting prompt=" + this.getRequestingPrompt());
        _logger.fine("requesting protocol=" + this.getRequestingProtocol());
        ClientSecurityContext cont = ClientSecurityContext.getCurrent();
        subject = cont.getSubject();
        user = this.getUserName(subject);
        password = this.getPassword(subject);
        if (user == null || password == null) {
            try {
                _logger.fine("Initiating login again...");
                LoginContextDriver.doClientLogin(1, AppContainer.getCallbackHandler());
                cont = ClientSecurityContext.getCurrent();
                subject = cont.getSubject();
                user = this.getUserName(subject);
                password = this.getPassword(subject);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Exception " + e.toString(), e);
                return null;
            }
        }
        _logger.fine("Username:" + user + " Password:" + password);
        return new PasswordAuthentication(user, password.toCharArray());
    }

    private String getUserName(Subject s) {
        String user = null;
        if (s == null) {
            return null;
        }
        Set<Principal> principalSet = s.getPrincipals();
        Iterator<Principal> itr = principalSet.iterator();
        if (itr.hasNext()) {
            Principal p = itr.next();
            user = p.getName();
        }
        return user;
    }

    private String getPassword(Subject s) {
        Object o;
        String password = null;
        if (s == null) {
            return null;
        }
        Set<Object> credentials = s.getPrivateCredentials();
        Iterator<Object> credIter = credentials.iterator();
        if (credIter.hasNext() && (o = credIter.next()) instanceof PasswordCredential) {
            PasswordCredential pc = (PasswordCredential)o;
            password = pc.getPassword();
        }
        return password;
    }
}

