/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.iiop.PEORBConfigurator;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.LoginCallbackHandler;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.security.auth.callback.CallbackHandler;

public class AppContainer {
    public static final int USERNAME_PASSWORD = 1;
    public static final int CERTIFICATE = 2;
    public static final int ALL = 3;
    private static final boolean debug = false;
    private ApplicationClientDescriptor descriptor = null;
    private Switch sw = Switch.getSwitch();
    private NamingManager nm = null;
    private static CallbackHandler handler = null;
    private boolean guiAuth = true;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.appclient");

    public AppContainer(ApplicationClientDescriptor desc, boolean useGuiAuth) {
        this.sw.setContainerType(1);
        this.descriptor = desc;
        this.guiAuth = useGuiAuth;
    }

    public static CallbackHandler getCallbackHandler() {
        return handler;
    }

    public String preInvoke(Properties props) throws Exception {
        InitialContext ic = new InitialContext(props);
        ComponentInvocation ci = new ComponentInvocation(null, this);
        InvocationManagerImpl im = new InvocationManagerImpl();
        this.sw.setInvocationManager(im);
        PEORBConfigurator.initTransactionService(null);
        J2EETransactionManagerImpl tm = new J2EETransactionManagerImpl();
        this.sw.setTransactionManager(tm);
        im.preInvoke(ci);
        String callbackHandler = this.descriptor.getCallbackHandler();
        _logger.fine("Callback Handler:" + callbackHandler);
        this.initializeCallbackHandler(callbackHandler);
        boolean doLogin = Boolean.valueOf(System.getProperty("startup.login", "false"));
        if (doLogin) {
            _logger.info("acc.init_login");
            String loginMech = System.getProperty("com.sun.enterprise.loginMech", "password");
            if (loginMech.equalsIgnoreCase("ssl")) {
                LoginContextDriver.doClientLogin(2, handler);
            } else if (loginMech.equalsIgnoreCase("all")) {
                LoginContextDriver.doClientLogin(3, handler);
            } else {
                LoginContextDriver.doClientLogin(1, handler);
            }
        }
        this.nm = new NamingManagerImpl(ic);
        this.sw.setNamingManager(this.nm);
        String mainClass = this.descriptor.getMainClassName();
        this.sw.setDescriptorFor(this, this.descriptor);
        this.nm.bindObjects(this.descriptor);
        return mainClass;
    }

    public void postInvoke() throws Exception {
        this.nm.unbindObjects(this.descriptor);
    }

    private void initializeCallbackHandler(String callbackHandler) {
        Class<?> handlerClass = null;
        handler = null;
        try {
            if (callbackHandler != null) {
                handlerClass = Class.forName(callbackHandler);
                handler = (CallbackHandler)handlerClass.newInstance();
            } else {
                handler = new LoginCallbackHandler(this.guiAuth);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Could not instantiate specified callback handler:" + e.getMessage(), e);
            _logger.info("acc.using_default_callback");
            handler = new LoginCallbackHandler(this.guiAuth);
        }
    }
}

