/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.target;

import com.sun.enterprise.admin.target.ConfigTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.util.i18n.StringManager;

public class NodeAgentTarget
extends Target {
    private static final StringManager strMgr = StringManager.getManager(NodeAgentTarget.class);

    protected NodeAgentTarget(String name, ConfigContext cc) {
        super(name, cc);
    }

    public TargetType getType() {
        return TargetType.NODE_AGENT;
    }

    public String getTargetObjectName(String[] tokens) {
        this.checkTokens(tokens, 1);
        return tokens[0] + ":type=node-agent,category=config,name=" + this.getName();
    }

    public ConfigTarget getConfigTarget() throws Exception {
        throw new ConfigException(strMgr.getString("target.no_config_for_node_agent"));
    }

    public String getConfigRef() throws ConfigException {
        return null;
    }

    public Server[] getServers() throws ConfigException {
        return ServerHelper.getServersOfANodeAgent(this.getConfigContext(), this.getName());
    }

    public Cluster[] getClusters() throws ConfigException {
        return ClusterHelper.getClustersForNodeAgent(this.getConfigContext(), this.getName());
    }

    public Config[] getConfigs() throws ConfigException {
        throw new ConfigException(strMgr.getString("target.not_supported", "getConfigs", this.getType().getName()));
    }

    public ApplicationRef[] getApplicationRefs() throws ConfigException {
        throw new ConfigException(strMgr.getString("target.not_supported", "getApplicationRefs", this.getType().getName()));
    }

    public ResourceRef[] getResourceRefs() throws ConfigException {
        throw new ConfigException(strMgr.getString("target.not_supported", "getResourceRefs", this.getType().getName()));
    }

    public NodeAgent[] getNodeAgents() throws ConfigException {
        NodeAgent[] agents = new NodeAgent[]{NodeAgentHelper.getNodeAgentByName(this.getConfigContext(), this.getName())};
        return agents;
    }
}

