/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;

public class ListModulesInApplicationTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : ListModulesInApplicationTester <instance-name> <app-name>";

    public ListModulesInApplicationTester() {
        super("App Tester");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length != 2) {
            this.getWriter().println(ListModulesInApplicationTester.getUsageString());
            return -1;
        }
        AppServerInstance instance = this.getServerInstance(params[0]);
        DeployedApplicationComponentBean application = instance.getDeployedApplication(params[1]);
        this.listAllModules(application);
        this.listEjbModules(application);
        this.listWebModules(application);
        return 0;
    }

    private AppServerInstance getServerInstance(String name) throws Exception {
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(name);
        return si;
    }

    private void listAllModules(DeployedApplicationComponentBean application) throws Exception {
        String[] modules = application.getAllModules();
        for (int i = 0; i < modules.length; ++i) {
            this.getWriter().println("Module[" + i + "] = " + modules[i]);
        }
    }

    private void listWebModules(DeployedApplicationComponentBean application) throws Exception {
        ServerModelIterator it = application.getWebModules();
        while (it.hasNext()) {
            this.getWriter().println("Web module: " + it.next());
        }
    }

    private void listEjbModules(DeployedApplicationComponentBean application) throws Exception {
        ServerModelIterator it = application.getEJBModules();
        while (it.hasNext()) {
            this.getWriter().println("Ejb module: " + it.next());
        }
    }

    public static void main(String[] args) throws Exception {
        new ListModulesInApplicationTester().execute(args);
    }
}

