/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.beans.AuthDb;
import com.sun.enterprise.admin.servermodel.beans.HttpServiceComponentBean;
import com.sun.enterprise.admin.servermodel.beans.VirtualServer;
import com.sun.enterprise.admin.servermodel.beans.VirtualServerClass;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;

public class ListAuthDbsTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : ListAuthDbsTester <instance-name> <vsClassId> <virtualServerId>";

    public ListAuthDbsTester() {
        super("AuthDB Tester");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length != 3) {
            this.getWriter().println(ListAuthDbsTester.getUsageString());
            return -1;
        }
        AppServerInstance instance = this.getServerInstance(params[0]);
        HttpServiceComponentBean httpService = instance.getHttpService();
        VirtualServerClass vsClass = httpService.getVirtualServerClass(params[1]);
        VirtualServer vs = vsClass.getVirtualServer(params[2]);
        ServerModelIterator it = vs.getAuthDbs();
        while (it.hasNext()) {
            AuthDb authDb = (AuthDb)it.next();
            this.getWriter().println("Auth Db = " + authDb);
        }
        return 0;
    }

    private AppServerInstance getServerInstance(String name) throws Exception {
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(name);
        return si;
    }

    public static void main(String[] args) throws Exception {
        new ListAuthDbsTester().execute(args);
    }
}

