/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.beans.JVMComponentBean;
import com.sun.enterprise.admin.servermodel.beans.Profiler;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;
import java.util.HashMap;

public class JvmConfigTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : JvmConfigTester <instance-name>";

    public JvmConfigTester() {
        super("Java config tester");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length != 1) {
            this.getWriter().println(JvmConfigTester.getUsageString());
            return -1;
        }
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(params[0]);
        JVMComponentBean component = si.getJVMComponent();
        this.printJVMAttributes(component);
        this.testProfiler(component);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        new JvmConfigTester().execute(args);
    }

    private void printJVMAttributes(JVMComponentBean component) throws Exception {
        String[] jvmOptions = component.getJvmOptions();
        if (jvmOptions != null) {
            this.getWriter().println("Printing Jvm options");
            for (int i = 0; i < jvmOptions.length; ++i) {
                this.getWriter().println(jvmOptions[i]);
            }
        }
    }

    private void testProfiler(JVMComponentBean jvm) throws Exception {
        if (!jvm.isProfilerExists()) {
            jvm.createProfiler("jprobe");
        }
        Profiler profiler = jvm.getProfiler("jprobe");
        this.printProfilerAttributes(profiler);
        this.setProfilerAttributes(profiler);
        this.printProfilerAttributes(profiler);
    }

    private void printProfilerAttributes(Profiler profiler) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Object value = profiler.getAttribute("name");
        attributes.put("name", value);
        value = profiler.getAttribute("classpath");
        attributes.put("classpath", value);
        value = profiler.getAttribute("nativeLibraryPath");
        attributes.put("nativeLibraryPath", value);
        value = profiler.getAttribute("enabled");
        attributes.put("enabled", value);
        this.getWriter().println(attributes);
        String[] jvmOptions = profiler.getJvmOptions();
        if (jvmOptions != null) {
            this.getWriter().println("Printing Profiler Jvm options");
            for (int i = 0; i < jvmOptions.length; ++i) {
                this.getWriter().println(jvmOptions[i]);
            }
        }
    }

    private void setProfilerAttributes(Profiler profiler) throws Exception {
        profiler.setAttribute("classpath", "a/b/c");
        profiler.setAttribute("nativeLibraryPath", "b/c");
        profiler.setAttribute("enabled", new Boolean(false));
        profiler.setJvmOptions(new String[]{"-DDebug=1"});
    }
}

