/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;

public class DeleteResourceTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : DeleteResourceTester <instance-name> <jndi-name><res-type>(persistence|jndi|jdbc|mail|custom|jms)";

    public DeleteResourceTester() {
        super("j2ee resource tester");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length != 3) {
            this.getWriter().println(DeleteResourceTester.getUsageString());
            return -1;
        }
        this.checkResourceType(params[2]);
        this.deleteResource(params[0], params[1], params[2]);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        new DeleteResourceTester().execute(args);
    }

    private void checkResourceType(String resType) throws Exception {
        if (!(resType.equals("persistence") || resType.equals("custom") || resType.equals("jndi") || resType.equals("jdbc") || resType.equals("jms") || resType.equals("mail"))) {
            throw new Exception("Invalid resource type. Resource type should beone of persistence, jndi, mail, jms, jdbc, custom");
        }
    }

    private void deleteResource(String instanceName, String jndiName, String resourceType) throws Exception {
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(instanceName);
        if (resourceType.equals("persistence")) {
            si.deletePersistenceManagerFactoryResource(jndiName);
        } else if (resourceType.equals("jndi")) {
            si.deleteJNDIResource(jndiName);
        } else if (resourceType.equals("jdbc")) {
            si.deleteJDBCResource(jndiName);
        } else if (resourceType.equals("custom")) {
            si.deleteCustomResource(jndiName);
        } else if (resourceType.equals("jms")) {
            si.deleteJMSResource(jndiName);
        } else if (resourceType.equals("mail")) {
            si.deleteJavaMailResource(jndiName);
        }
    }
}

