/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.beans.HttpServiceComponentBean;
import com.sun.enterprise.admin.servermodel.beans.ServerComponent;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;

public class CreateHttpQosTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : CreateHttpQosTester <instance-name> <bandwidthLimit> <enforceBandWidthLimit> <connectionLimit> <enforceConnectionLimit>";

    public CreateHttpQosTester() {
        super("Http QOS");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length != 5) {
            this.getWriter().println(CreateHttpQosTester.getUsageString());
            return -1;
        }
        AppServerInstance instance = this.getServerInstance(params[0]);
        HttpServiceComponentBean httpService = instance.getHttpService();
        if (!httpService.isHttpQosCreated()) {
            httpService.createHttpQos();
        } else {
            this.getWriter().println("HTTP QOS already exists for this component");
            httpService.removeHttpQos();
            httpService.createHttpQos();
        }
        this.setHttpQosAttributes(httpService, Integer.valueOf(params[1]), Boolean.valueOf(params[2]), Integer.valueOf(params[3]), Boolean.valueOf(params[4]));
        return 0;
    }

    private AppServerInstance getServerInstance(String name) throws Exception {
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(name);
        return si;
    }

    private void setHttpQosAttributes(ServerComponent httpService, Integer bandWidthLimit, Boolean enforceBandWidthLimit, Integer connectionLimit, Boolean enforceConnectionLimit) throws Exception {
        httpService.setAttribute("bandwidthLimit", bandWidthLimit);
        httpService.setAttribute("enforceBandwidthLimit", enforceBandWidthLimit);
        httpService.setAttribute("connectionLimit", connectionLimit);
        httpService.setAttribute("enforceConnectionLimit", enforceConnectionLimit);
    }

    public static void main(String[] args) throws Exception {
        new CreateHttpQosTester().execute(args);
    }
}

