/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.beans;

import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.servermodel.beans.IiopListener;
import com.sun.enterprise.admin.servermodel.beans.ServerComponent;
import com.sun.enterprise.admin.servermodel.controllers.Controller;
import com.sun.enterprise.admin.servermodel.controllers.ORBComponentController;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;
import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.Debug;
import java.io.Serializable;
import javax.management.ObjectName;

public class ORBComponentBean
extends ServerComponent
implements Serializable {
    private transient ORBComponentController controller = new ORBComponentController(this);

    public ORBComponentBean(String identifier) {
        super(identifier);
    }

    public Controller getController() {
        return null;
    }

    public void addIiopListener(String id, String address) throws AFException {
        this.controller.addIiopListener(id, address);
    }

    public void removeIiopListener(String id) throws AFException {
        this.controller.removeIiopListener(id);
    }

    public ServerModelIterator getIiopListeners() throws AFException {
        return this.controller.getIiopListeners();
    }

    public IiopListener getIiopListener(String id) throws AFException {
        IiopListener iiopListener = null;
        try {
            ObjectName orbObjectName = new ObjectName(super.getIdentifier());
            Debug.println("ORB object name = " + orbObjectName);
            String instanceName = orbObjectName.getKeyProperty("instance-name");
            ObjectName mbeanName = ObjectNames.getIiopListenerObjectName(instanceName, id);
            Assert.assertit(mbeanName != null, "null value returned");
            Debug.println("Iiop listener object name = " + mbeanName);
            iiopListener = new IiopListener(mbeanName.toString(), id);
            iiopListener.setContextHolder(this.getContextHolder());
        }
        catch (Exception e) {
            throw new AFException(e.getLocalizedMessage());
        }
        return iiopListener;
    }

    public boolean isSSLCreated() throws AFException {
        return this.controller.isSSLCreated();
    }

    public void createSSL(String certNickName) throws AFException {
        this.controller.createSSL(certNickName);
    }

    public void deleteSSL() throws AFException {
        this.controller.deleteSSL();
    }
}

