/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.common.EntityStatus;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.exception.J2EEConnectorModuleException;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.event.AdminEventCache;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ManagedStandaloneConnectorModule
extends ConfigMBeanBase
implements ConfigAttributeName.StandaloneConnectorModule {
    private static final String[][] MAPLIST = new String[][]{{"name", "@" + ServerTags.NAME}, {"location", "@" + ServerTags.LOCATION}, {"description", "@" + PSEUDO_ATTR_DESCRIPTION}};
    private static final String[] ATTRIBUTES = new String[]{"name, String,     R", "location, String,     RW", "description, String,     RW"};
    private static final String[] OPERATIONS = new String[]{"getStatus(),   INFO", "enable(),      ACTION", "disable(),     ACTION", "start(),       ACTION", "stop(),        ACTION", "getState(),    INFO"};

    public ManagedStandaloneConnectorModule() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedStandaloneConnectorModule(String instanceName, String moduleName) throws MBeanConfigException {
        this();
        this.initialize("connector-module", new String[]{instanceName, moduleName});
    }

    public EntityStatus getStatus() throws J2EEConnectorModuleException {
        EntityStatus status = null;
        try {
            boolean isModuleEnabled = true;
            status = new EntityStatus();
            if (isModuleEnabled) {
                status.setEnabled();
            } else {
                status.setDisabled();
            }
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getStatus", e);
            throw new J2EEConnectorModuleException(e.getMessage());
        }
        return status;
    }

    public void disable() throws J2EEConnectorModuleException {
    }

    public void stop() throws J2EEConnectorModuleException {
        try {
            String moduleName = (String)this.getAttribute("name");
            this.multicastAdminEvent(moduleName, "disable");
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "stop", e);
            throw new J2EEConnectorModuleException(e.getMessage());
        }
    }

    public Integer getState() throws J2EEConnectorModuleException {
        try {
            String moduleName = (String)this.getAttribute("name");
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ServerContext serverContext = ApplicationServer.getServerContext();
            ObjectName objName = new ObjectName(serverContext.getDefaultDomainName() + ":" + "j2eeType=ResourceAdapterModule," + "name=" + (String)this.getAttribute("name") + "," + "J2EEApplication=" + "null" + "," + "J2EEServer=" + serverContext.getInstanceName());
            Integer intObj = (Integer)mbs.getAttribute(objName, "state");
            return intObj;
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getState", e);
            throw new J2EEConnectorModuleException(e.getMessage());
        }
    }

    public void enable() throws J2EEConnectorModuleException {
    }

    public void start() throws J2EEConnectorModuleException {
        try {
            String moduleName = (String)this.getAttribute("name");
            this.multicastAdminEvent(moduleName, "enable");
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "start", e);
            throw new J2EEConnectorModuleException(e.getMessage());
        }
    }

    private void multicastAdminEvent(String entityName, String actionCode) throws J2EEConnectorModuleException {
        String instanceName = super.getServerInstanceName();
        InstanceEnvironment instEnv = new InstanceEnvironment(instanceName);
        ModuleDeployEvent event = new ModuleDeployEvent(instanceName, entityName, "connector", actionCode);
        RMIClient serverInstancePinger = AdminChannel.getRMIClient(instanceName);
        if (serverInstancePinger.getInstanceStatusCode() != 0) {
            return;
        }
        AdminEventResult multicastResult = AdminEventMulticaster.multicastEvent(event);
        if (!"success".equals(multicastResult.getResultCode())) {
            AdminEventCache cache = AdminEventCache.getInstance(instanceName);
            cache.setRestartNeeded(true);
        }
    }
}

