/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.admin.server.core.mbean.config.SslBase;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.util.i18n.StringManager;

public class ManagedORBListener
extends ConfigMBeanBase
implements ConfigAttributeName.ORBListener {
    private static final String[][] MAPLIST = new String[][]{{"id", "@" + ServerTags.ID}, {"address", "@" + ServerTags.ADDRESS}, {"port", "@" + ServerTags.PORT}, {"enabled", "@" + ServerTags.ENABLED}};
    private static final String[] ATTRIBUTES = new String[]{"id, String,  R", "address, String,  RW", "port, int,     RW", "enabled, Boolean, RW"};
    private static final String[] OPERATIONS = new String[]{"createSsl(String certNickname, Boolean ssl2Enabled, String ssl2Ciphers, Boolean ssl3Enabled, String ssl3TlsCiphers, Boolean tlsEnabled, Boolean tlsRollbackEnabled, Boolean clientAuthEnabled), ACTION", "deleteSsl(), ACTION", "isSslCreated(), INFO"};
    private static StringManager localStrings = StringManager.getManager(ManagedORBListener.class);

    public ManagedORBListener() throws MBeanConfigException {
        Object[] mergedAttrs = ManagedORBListener.MergeAttributesWithAnotherMbean(MAPLIST, ATTRIBUTES, SslBase.MAPLIST, SslBase.ATTRIBUTES, ServerTags.SSL, null);
        this.setDescriptions((String[][])mergedAttrs[0], (String[])mergedAttrs[1], OPERATIONS);
    }

    public ManagedORBListener(String instanceName, String listenerId) throws MBeanConfigException {
        this();
        this.initialize("orblistener", new String[]{instanceName, listenerId});
    }

    public boolean isSslCreated() throws ConfigException {
        IiopListener listener = (IiopListener)this.getConfigBeanByXPath(this.getBasePath());
        return listener.getSsl() != null;
    }

    public void deleteSsl() throws ConfigException {
        IiopListener listener = (IiopListener)this.getConfigBeanByXPath(this.getBasePath());
        listener.setSsl(null);
        this.getConfigContext().flush();
    }

    public void createSsl(String certNickname, Boolean ssl2Enabled, String ssl2Ciphers, Boolean ssl3Enabled, String ssl3TlsCiphers, Boolean tlsEnabled, Boolean tlsRollbackEnabled, Boolean clientAuthEnabled) throws ConfigException {
        IiopListener listener;
        block11: {
            listener = (IiopListener)this.getConfigBeanByXPath(this.getBasePath());
            try {
                if (listener.getSsl() != null) {
                    listener = null;
                    String msg = localStrings.getString("admin.server.core.mbean.config.orblistener_has_ssl_created");
                    throw new ConfigException(msg);
                }
            }
            catch (ConfigException e) {
                if (listener != null) break block11;
                throw e;
            }
        }
        Ssl ssl = new Ssl();
        if (certNickname != null) {
            ssl.setCertNickname(certNickname);
        }
        if (ssl2Ciphers != null) {
            ssl.setSsl2Ciphers(ssl2Ciphers);
        }
        if (ssl3TlsCiphers != null) {
            ssl.setSsl3TlsCiphers(ssl3TlsCiphers);
        }
        if (ssl2Enabled != null) {
            ssl.setSsl2Enabled(ssl2Enabled);
        }
        if (ssl3Enabled != null) {
            ssl.setSsl3Enabled(ssl3Enabled);
        }
        if (tlsEnabled != null) {
            ssl.setTlsEnabled(tlsEnabled);
        }
        if (tlsRollbackEnabled != null) {
            ssl.setTlsRollbackEnabled(tlsRollbackEnabled);
        }
        if (clientAuthEnabled != null) {
            ssl.setClientAuthEnabled(clientAuthEnabled);
        }
        listener.setSsl(ssl);
        this.getConfigContext().flush();
    }
}

