/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.admin.server.core.mbean.config.SslBase;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.config.serverbeans.SslClientConfig;
import com.sun.enterprise.util.i18n.StringManager;

public class ManagedORBComponent
extends ConfigMBeanBase
implements ConfigAttributeName.OrbComponent {
    private static StringManager localStrings = StringManager.getManager(ManagedORBComponent.class);
    private static final String ORB_ATTRIBUTE = ServerTags.ORB + "/" + "@";
    private static final String[][] MAPLIST = new String[][]{{"msgSize", ORB_ATTRIBUTE + ServerTags.MESSAGE_FRAGMENT_SIZE}, {"maxConnections", ORB_ATTRIBUTE + ServerTags.MAX_CONNECTIONS}};
    private static final String[] ATTRIBUTES = new String[]{"msgSize, int,      RW", "maxConnections, int,      RW"};
    private static final String[] OPERATIONS = new String[]{"createORBListener(String id, String address, Integer port, Boolean enabled), ACTION", "deleteORBListener(String id), ACTION", "listORBListeners(), INFO", "createSsl(String certNickname, Boolean ssl2Enabled, String ssl2Ciphers, Boolean ssl3Enabled, String ssl3TlsCiphers, Boolean tlsEnabled, Boolean tlsRollbackEnabled, Boolean clientAuthEnabled), ACTION", "deleteSsl(), ACTION", "isSslCreated(), INFO"};

    public ManagedORBComponent() throws MBeanConfigException {
        Object[] mergedAttrs = ManagedORBComponent.MergeAttributesWithAnotherMbean(MAPLIST, ATTRIBUTES, SslBase.MAPLIST, SslBase.ATTRIBUTES, ServerTags.SSL_CLIENT_CONFIG + "/" + ServerTags.SSL, null);
        this.setDescriptions((String[][])mergedAttrs[0], (String[])mergedAttrs[1], OPERATIONS);
    }

    public ManagedORBComponent(String instanceName) throws MBeanConfigException {
        this();
        this.initialize("orb", new String[]{instanceName});
    }

    public void createORBListener(String id, String address, Integer port, Boolean enabled) throws ConfigException {
        IiopListener listener = new IiopListener();
        if (id != null) {
            listener.setId(id);
        }
        if (address != null) {
            listener.setAddress(address);
        }
        if (port != null) {
            listener.setPort(port.toString());
        }
        if (enabled != null) {
            listener.setEnabled(enabled);
        }
        IiopService service = (IiopService)this.getConfigBeanByXPath(ServerXPathHelper.getIIOPServiceXpath());
        service.addIiopListener(listener);
        this.getConfigContext().flush();
    }

    public void deleteORBListener(String id) throws ConfigException {
        IiopService service = (IiopService)this.getConfigBeanByXPath(ServerXPathHelper.getIIOPServiceXpath());
        IiopListener listener = service.getIiopListenerById(id);
        if (listener != null) {
            service.removeIiopListener(listener);
        }
        this.getConfigContext().flush();
    }

    public String[] listORBListeners() throws ConfigException {
        IiopService service = (IiopService)this.getConfigBeanByXPath(ServerXPathHelper.getIIOPServiceXpath());
        IiopListener[] listeners = service.getIiopListener();
        String[] res = new String[listeners.length];
        for (int i = 0; i < listeners.length; ++i) {
            res[i] = listeners[i].getId();
        }
        return res;
    }

    public boolean isSslCreated() throws ConfigException {
        IiopService service = (IiopService)this.getBaseConfigBean();
        SslClientConfig config = service.getSslClientConfig();
        if (config == null) {
            return false;
        }
        return config.getSsl() != null;
    }

    public void deleteSsl() throws ConfigException {
        IiopService service = (IiopService)this.getBaseConfigBean();
        service.setSslClientConfig(null);
        this.getConfigContext().flush();
    }

    public void createSsl(String certNickname, Boolean ssl2Enabled, String ssl2Ciphers, Boolean ssl3Enabled, String ssl3TlsCiphers, Boolean tlsEnabled, Boolean tlsRollbackEnabled, Boolean clientAuthEnabled) throws ConfigException {
        if (this.isSslCreated()) {
            String msg = localStrings.getString("admin.server.core.mbean.config.iiopservice_has_ssl_created");
            throw new ConfigException(msg);
        }
        IiopService service = (IiopService)this.getBaseConfigBean();
        SslClientConfig config = service.getSslClientConfig();
        if (config == null) {
            config = new SslClientConfig();
        }
        Ssl ssl = new Ssl();
        if (certNickname != null) {
            ssl.setCertNickname(certNickname);
        }
        if (ssl2Ciphers != null) {
            ssl.setSsl2Ciphers(ssl2Ciphers);
        }
        if (ssl3TlsCiphers != null) {
            ssl.setSsl3TlsCiphers(ssl3TlsCiphers);
        }
        if (ssl2Enabled != null) {
            ssl.setSsl2Enabled(ssl2Enabled);
        }
        if (ssl3Enabled != null) {
            ssl.setSsl3Enabled(ssl3Enabled);
        }
        if (tlsEnabled != null) {
            ssl.setTlsEnabled(tlsEnabled);
        }
        if (tlsRollbackEnabled != null) {
            ssl.setTlsRollbackEnabled(tlsRollbackEnabled);
        }
        if (clientAuthEnabled != null) {
            ssl.setClientAuthEnabled(clientAuthEnabled);
        }
        config.setSsl(ssl);
        service.setSslClientConfig(config);
        this.getConfigContext().flush();
    }
}

