/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx;

import com.sun.enterprise.admin.common.CombinedPatternMatcher;
import com.sun.enterprise.admin.common.ObjectNameHelper;
import com.sun.enterprise.admin.server.core.jmx.IRepository;
import com.sun.enterprise.admin.server.core.jmx.storage.MBeanManufacturer;
import com.sun.enterprise.admin.server.core.jmx.storage.PersistenceChecker;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class DomainRepository
implements IRepository {
    private static final Logger sLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private Hashtable mDomainTable = new Hashtable();

    public boolean contains(ObjectName objectName) {
        return this.find(objectName) != null;
    }

    public int getCount(String domainName) {
        return ((Hashtable)this.mDomainTable.get(domainName)).size();
    }

    public Object find(ObjectName objectName) {
        Hashtable domain;
        Object match = null;
        if (objectName != null && !objectName.isPattern() && !objectName.isPropertyPattern() && (domain = this.findRepository(objectName)) != null) {
            match = domain.get(objectName);
        }
        return match;
    }

    public Object findPersistent(ObjectName objectName) {
        boolean isMonitorMBean;
        Hashtable domain;
        Object match = null;
        Object cachedMatch = null;
        if (objectName != null && !objectName.isPattern() && !objectName.isPropertyPattern() && (domain = this.findRepository(objectName)) != null) {
            cachedMatch = domain.get(objectName);
        }
        match = !(isMonitorMBean = ObjectNameHelper.isMonitorMBean(objectName)) ? this.findInPersistentStore(objectName, cachedMatch) : cachedMatch;
        return match;
    }

    public boolean add(ObjectName objectName, Object mbeanImpl) {
        boolean newDomainRequired;
        Hashtable domain = this.findRepository(objectName);
        String domainName = objectName.getDomain();
        boolean added = false;
        boolean bl = newDomainRequired = domain == null;
        if (newDomainRequired) {
            domain = this.addNewDomain(domainName);
            domain.put(objectName, mbeanImpl);
            added = true;
        } else {
            boolean noMatchFound;
            boolean bl2 = noMatchFound = domain.get(objectName) == null;
            if (noMatchFound) {
                domain.put(objectName, mbeanImpl);
                added = true;
            }
        }
        return added;
    }

    public boolean remove(ObjectName objectName) {
        Object mappedObject;
        Hashtable domain = this.findRepository(objectName);
        boolean removed = false;
        if (domain != null && (mappedObject = domain.remove(objectName)) != null) {
            removed = true;
        }
        return removed;
    }

    private Hashtable findRepository(ObjectName objectName) {
        String domainName = objectName.getDomain();
        return (Hashtable)this.mDomainTable.get(domainName);
    }

    private Hashtable addNewDomain(String domainName) {
        Hashtable newRepository = new Hashtable();
        this.mDomainTable.put(domainName, newRepository);
        return newRepository;
    }

    public int getTotalCount() {
        int count = 0;
        Iterator domainNames = this.mDomainTable.keySet().iterator();
        while (domainNames.hasNext()) {
            String domainName = (String)domainNames.next();
            Hashtable aTable = (Hashtable)this.mDomainTable.get(domainName);
            count += aTable.size();
        }
        return count;
    }

    public Set getAllMBeans() {
        HashSet mbeans = new HashSet();
        Iterator domainNames = this.mDomainTable.keySet().iterator();
        while (domainNames.hasNext()) {
            String domainName = (String)domainNames.next();
            Hashtable aTable = (Hashtable)this.mDomainTable.get(domainName);
            mbeans.addAll(aTable.keySet());
        }
        return mbeans;
    }

    public Set query(ObjectName objectName) {
        HashSet<ObjectName> mbeans = null;
        Set allMBeans = null;
        String domainNamePattern = null;
        Hashtable<String, String> propertyTable = null;
        if (objectName != null) {
            mbeans = new HashSet<ObjectName>();
            if (!objectName.isPattern()) {
                if (this.contains(objectName)) {
                    mbeans.add(objectName);
                }
            } else {
                allMBeans = this.getAllMBeans();
                domainNamePattern = objectName.getDomain();
                propertyTable = objectName.getKeyPropertyList();
                Iterator allMBeanIter = allMBeans.iterator();
                while (allMBeanIter.hasNext()) {
                    Hashtable<String, String> samplePropertyTable;
                    boolean sampleMatches;
                    ObjectName sample = (ObjectName)allMBeanIter.next();
                    String sampleDomainName = sample.getDomain();
                    boolean domainNameMatches = this.matchDomain(domainNamePattern, sampleDomainName);
                    if (!domainNameMatches || !(sampleMatches = this.matchPropertiesWithPattern(propertyTable, samplePropertyTable = sample.getKeyPropertyList()))) continue;
                    mbeans.add(sample);
                }
            }
        }
        return mbeans;
    }

    private boolean matchPropertiesWithPattern(Hashtable pattern, Hashtable sample) {
        boolean currentMatch = true;
        Iterator keyIter = pattern.keySet().iterator();
        while (currentMatch && keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String patternVal = (String)pattern.get(key);
            String sampleVal = (String)sample.get(key);
            currentMatch = patternVal.equals(sampleVal);
        }
        return currentMatch;
    }

    private boolean matchDomain(String domainNamePattern, String testDomainName) {
        CombinedPatternMatcher matcher = new CombinedPatternMatcher(domainNamePattern, testDomainName);
        return matcher.matches();
    }

    private Object findInPersistentStore(ObjectName objectName, Object cachedObject) {
        String type = ObjectNameHelper.getType(objectName);
        if (type.equals("controller") || type.equals("configurator")) {
            return cachedObject;
        }
        PersistenceChecker checker = new PersistenceChecker();
        Object storedObject = null;
        try {
            storedObject = checker.findElement(objectName);
        }
        catch (Exception e) {
            // empty catch block
        }
        Object match = null;
        if (storedObject != null) {
            if (cachedObject != null) {
                match = cachedObject;
            } else {
                MBeanManufacturer producer = new MBeanManufacturer(objectName, storedObject);
                match = producer.createMBeanInstance();
                this.add(objectName, match);
            }
        } else {
            match = null;
            if (cachedObject != null) {
                this.remove(objectName);
            }
        }
        return match;
    }
}

