/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.monitor.GenericMonitorMBean;
import com.sun.enterprise.admin.monitor.IMonitorable;
import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.types.MonitoredAttributeType;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class BaseMonitorMBean
implements DynamicMBean,
IMonitorable {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    static final HashMap objectNameMap = new HashMap();
    private String[] attrNames = null;
    private ObjectName objectName;
    private String nodeName;
    private String nodeType;
    protected Vector childList = new Vector();
    private static StringManager localStrings = StringManager.getManager(BaseMonitorMBean.class);
    protected static final String UNSUPPORTED_ERRCODE = localStrings.getString("admin.monitor.unsupported_mbean_monitor");
    protected static final String UNSUPPORTED_ERRMSG = localStrings.getString("admin.monitor.unsupported_action_on_monitoring_mbean");
    private static final String MON_OBJTYPE = "mclass";
    private static final String MON_OBJNAME = "name";
    private static final String NON_COMPLIANT_MBEAN = "monitor.non_compliant_mbean";
    private static final String MBS_INIT_ERROR = "monitor.mbs_init_error";

    protected void setObjectName(ObjectName objName) {
        this.objectName = objName;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    protected void setNodeName(String name) {
        this.nodeName = name;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    protected void setNodeType(String type) {
        this.nodeType = type;
    }

    public synchronized ObjectName addChild(String name, MonitoredObjectType type, BaseMonitorMBean mBean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        if (name == null || type == null || mBean == null) {
            String str1 = name == null ? "Child Name (name); " : "";
            String str2 = type == null ? "Child Type (type); " : "";
            String str3 = mBean == null ? "MBean (mBean); " : "";
            String msg = localStrings.getString("admin.monitor.null_arguments", str1, str2, str3);
            throw new IllegalArgumentException(msg);
        }
        if (this.objectName == null || this.nodeName == null || this.nodeType == null) {
            String msg = localStrings.getString("admin.monitor.monitoring_mbean_not_added_to_mbeantree");
            throw new IllegalStateException(msg);
        }
        boolean exists = false;
        int size = this.childList.size();
        for (int i = 0; i < size; ++i) {
            BaseMonitorMBean m = (BaseMonitorMBean)this.childList.elementAt(i);
            if (type.isSingleton()) {
                if (!m.nodeType.equals(type.getTypeName())) continue;
                exists = true;
                break;
            }
            if (!m.nodeType.equals(type.getTypeName()) || !m.nodeName.equals(name)) continue;
            exists = true;
            break;
        }
        if (exists) {
            String msg = localStrings.getString("admin.monitor.mbean_already_exists", type, name);
            throw new InstanceAlreadyExistsException(msg);
        }
        if (type.isSingleton()) {
            name = type.getTypeName();
        }
        this.childList.add(mBean);
        mBean.setNodeName(name);
        mBean.setNodeType(type.getTypeName());
        ObjectName childObjName = BaseMonitorMBean.getChildObjectName(this.objectName, type, name);
        mBean.setObjectName(childObjName);
        MBeanServer mbs = BaseMonitorMBean.getMBeanServer();
        objectNameMap.put(childObjName, mBean);
        if (type.isMonitoringEnabled()) {
            mBean.startMonitoring();
        }
        return childObjName;
    }

    private static ObjectName getChildObjectName(ObjectName parent, MonitoredObjectType childType, String childName) throws MBeanRegistrationException {
        Hashtable<String, String> props = parent.getKeyPropertyList();
        Hashtable newProps = (Hashtable)props.clone();
        String type = props.get(MON_OBJTYPE);
        String name = props.get(MON_OBJNAME);
        newProps.put(type, name);
        newProps.put(MON_OBJTYPE, childType.getTypeName());
        newProps.put(MON_OBJNAME, childName);
        ObjectName newName = null;
        try {
            newName = new ObjectName(parent.getDomain(), newProps);
        }
        catch (MalformedObjectNameException mone) {
            throw new MBeanRegistrationException(mone, mone.getMessage());
        }
        return newName;
    }

    public ArrayList getChildList() {
        ArrayList list = new ArrayList();
        list.addAll(this.childList);
        return list;
    }

    public ArrayList getChildList(MonitoredObjectType type) {
        if (type == null) {
            String msg = localStrings.getString("admin.monitor.null_argument_mbean_type");
            throw new IllegalArgumentException(msg);
        }
        ArrayList<BaseMonitorMBean> list = new ArrayList<BaseMonitorMBean>();
        Iterator iter = this.childList.iterator();
        while (iter.hasNext()) {
            BaseMonitorMBean mBean = (BaseMonitorMBean)iter.next();
            if (!mBean.nodeType.equals(type.getTypeName())) continue;
            list.add(mBean);
        }
        return list;
    }

    public ArrayList getChildList(String name) {
        ArrayList<BaseMonitorMBean> list = new ArrayList<BaseMonitorMBean>();
        Iterator iter = this.childList.iterator();
        while (iter.hasNext()) {
            BaseMonitorMBean mBean = (BaseMonitorMBean)iter.next();
            if (!mBean.nodeName.equals(name)) continue;
            list.add(mBean);
        }
        return list;
    }

    public BaseMonitorMBean getChild(MonitoredObjectType type, String name) throws InstanceNotFoundException {
        BaseMonitorMBean found = this.getChildOrNull(type, name);
        if (found == null) {
            String msg = localStrings.getString("admin.monitor.mbean_not_found", type, name);
            throw new InstanceNotFoundException(msg);
        }
        return found;
    }

    BaseMonitorMBean getChildOrNull(MonitoredObjectType type, String name) {
        if (type == null) {
            String msg = localStrings.getString("admin.monitor.monitored_object_type_null");
            throw new IllegalArgumentException(msg);
        }
        BaseMonitorMBean found = null;
        Iterator iter = this.childList.iterator();
        while (iter.hasNext()) {
            BaseMonitorMBean mBean = (BaseMonitorMBean)iter.next();
            if (type.isSingleton()) {
                if (!mBean.nodeType.equals(type.getTypeName())) continue;
                found = mBean;
                continue;
            }
            if (!mBean.nodeType.equals(type.getTypeName()) || !mBean.nodeName.equals(name)) continue;
            found = mBean;
        }
        return found;
    }

    BaseMonitorMBean getFirstChildByName(String name) throws InstanceNotFoundException {
        ArrayList list = this.getChildList(name);
        if (list.isEmpty()) {
            String msg = localStrings.getString("admin.monitor.child_mbean_not_available", name, this.objectName);
            throw new InstanceNotFoundException(msg);
        }
        return (BaseMonitorMBean)list.get(0);
    }

    public synchronized void removeChild(MonitoredObjectType type, String name) throws InstanceNotFoundException, MBeanRegistrationException {
        BaseMonitorMBean mBean = this.getChild(type, name);
        this.removeChild(mBean);
    }

    synchronized void removeChild(BaseMonitorMBean child) throws InstanceNotFoundException, MBeanRegistrationException {
        BaseMonitorMBean.removeAllChild(child);
        this.childList.remove(child);
        objectNameMap.remove(child.objectName);
        MBeanServer mbs = BaseMonitorMBean.getMBeanServer();
    }

    private static void removeAllChild(BaseMonitorMBean mbean) throws InstanceNotFoundException, MBeanRegistrationException {
        Iterator iter = mbean.childList.iterator();
        while (iter.hasNext()) {
            BaseMonitorMBean child = (BaseMonitorMBean)iter.next();
            BaseMonitorMBean.removeAllChild(child);
            objectNameMap.remove(child.objectName);
            MBeanServer mBeanServer = BaseMonitorMBean.getMBeanServer();
        }
        mbean.childList.removeAllElements();
    }

    private static MBeanServer getMBeanServer() {
        return MBeanServerFactory.getMBeanServer();
    }

    public abstract Object getAttribute(String var1) throws AttributeNotFoundException;

    public abstract AttributeList getAttributes(String[] var1);

    public abstract MBeanInfo getMBeanInfo();

    public Object invoke(String str, Object[] obj, String[] str2) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException(BaseMonitorMBean.getLocalString(UNSUPPORTED_ERRCODE, UNSUPPORTED_ERRMSG));
    }

    public final void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException(BaseMonitorMBean.getLocalString(UNSUPPORTED_ERRCODE, UNSUPPORTED_ERRMSG));
    }

    public final AttributeList setAttributes(AttributeList attributeList) {
        throw new UnsupportedOperationException(BaseMonitorMBean.getLocalString(UNSUPPORTED_ERRCODE, UNSUPPORTED_ERRMSG));
    }

    public abstract MonitoredAttributeType getAttributeType(String var1);

    public void startMonitoring() {
    }

    public void stopMonitoring() {
    }

    public abstract Map getMonitoringMetaData();

    public final Object getMonitoredAttributeValue(String monitorAttributeName) {
        Object result = null;
        try {
            result = this.getAttribute(monitorAttributeName);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public final Map getMonitoredAttributeValues(Set monitorAttributeNameSet) {
        return null;
    }

    protected static MBeanInfo createMBeanInfo(Map attrNameTypeMap) {
        return BaseMonitorMBean.createMBeanInfo(attrNameTypeMap, new MBeanOperationInfo[0]);
    }

    protected static MBeanInfo createMBeanInfo(Map attrNameTypeMap, MBeanOperationInfo[] operationInfoArray) {
        String className = GenericMonitorMBean.class.getName();
        String description = "Generic Monitoring MBean";
        attrNameTypeMap = BaseMonitorMBean.convertKeysToCamelCase(attrNameTypeMap);
        Set keys = attrNameTypeMap.keySet();
        Iterator names = keys.iterator();
        MBeanAttributeInfo[] attrList = new MBeanAttributeInfo[keys.size()];
        int i = 0;
        while (names.hasNext()) {
            String name = (String)names.next();
            String type = ((MonitoredAttributeType)attrNameTypeMap.get(name)).getJavaTypeName();
            String desc = "Monitored attribute " + name;
            attrList[i] = new MBeanAttributeInfo(name, type, desc, true, false, false);
            ++i;
        }
        MBeanConstructorInfo[] constructorList = new MBeanConstructorInfo[]{};
        MBeanNotificationInfo[] notificationList = new MBeanNotificationInfo[]{};
        return new MBeanInfo(className, description, attrList, constructorList, operationInfoArray, notificationList);
    }

    public String[] getAllAttributeNames() {
        return this.getAllAttributeNamesFromMBeanInfo();
    }

    private String[] getAllAttributeNamesFromMBeanInfo() {
        if (this.attrNames == null) {
            MBeanInfo info = this.getMBeanInfo();
            if (info == null) {
                String msg = localStrings.getString("admin.monitor.null_mbean_info", this.getClass());
                throw new IllegalStateException(msg);
            }
            MBeanAttributeInfo[] attrInfoList = info.getAttributes();
            if (attrInfoList == null) {
                String msg = localStrings.getString("admin.monitor.null_attribute_info_in_mbeaninfo", this.getClass());
                throw new IllegalStateException(msg);
            }
            int size = attrInfoList.length;
            this.attrNames = new String[size];
            for (int i = 0; i < size; ++i) {
                this.attrNames[i] = attrInfoList[i].getName();
            }
        }
        return this.attrNames;
    }

    protected static Map createAttrNameTypeMap(Object[][] attrNameTypeArray) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = attrNameTypeArray.length; i > 0; --i) {
            map.put(attrNameTypeArray[i - 1][0], attrNameTypeArray[i - 1][1]);
        }
        return map;
    }

    private static String getLocalString(String key, String dflt) {
        return dflt;
    }

    private static Map convertKeysToCamelCase(Map attrNameTypeMap) {
        Iterator keys = attrNameTypeMap.keySet().iterator();
        Iterator values = attrNameTypeMap.values().iterator();
        HashMap newMap = new HashMap();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String camelCaseKey = BaseMonitorMBean.toCamelCase(key);
            newMap.put(camelCaseKey, values.next());
        }
        return newMap;
    }

    private static String toCamelCase(String illegalIdentifier) {
        StringBuffer from = new StringBuffer(illegalIdentifier);
        StringBuffer to = new StringBuffer();
        int length = from.length();
        boolean illegalFound = false;
        for (int i = 0; i < length; ++i) {
            char currentChar = from.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(currentChar) || i > 0 && !Character.isJavaIdentifierPart(currentChar)) {
                illegalFound = true;
                continue;
            }
            if (illegalFound) {
                to.append(Character.toUpperCase(currentChar));
                illegalFound = false;
                continue;
            }
            to.append(currentChar);
        }
        return to.toString();
    }
}

