/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.meta;

import com.sun.enterprise.admin.BaseAdminMBean;
import com.sun.enterprise.admin.meta.MBeanMetaException;
import com.sun.enterprise.admin.meta.MBeanRegistryEntry;
import com.sun.enterprise.admin.meta.naming.MBeanNamingDescriptor;
import com.sun.enterprise.admin.meta.naming.MBeanNamingException;
import com.sun.enterprise.admin.meta.naming.MBeanNamingInfo;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.logging.LogDomains;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;

public class MBeanRegistry {
    private static final String MSG_FINDREGISTRYENTRY_FAILED = "mbean.config.findregistryentry_failed";
    protected static Logger _sLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private MBeanRegistryEntry[] entries = null;
    private static final ObjectName REGISTRATION_MBEAN_OBJECTNAME = MBeanRegistry.getDottedRegMBeanName();
    private static final String REGISTRATION_OPERATION_NAME = "add";
    private static final String UNREGISTRATION_OPERATION_NAME = "remove";
    public static final int SORT_BY_NAME = 0;
    public static final int SORT_BY_XPATH = 1;

    public String toString() {
        String str = "MBeanRegistry(" + this.entries.length + " entries):\n";
        for (int i = 0; i < this.entries.length; ++i) {
            str = str + this.entries[i].toString();
        }
        return str;
    }

    public String toFormatString() {
        String str = "MBeanRegistry(" + this.entries.length + " entries):\n";
        for (int i = 0; i < this.entries.length; ++i) {
            str = str + this.entries[i].toFormatString();
        }
        return str;
    }

    public void loadMBeanRegistry(InputStream stream) throws MBeanMetaException, MBeanNamingException, ClassNotFoundException {
        MyRegistry registry = new MyRegistry();
        try {
            registry.loadDescriptors("MbeansDescriptorsDOMSource", stream, null);
        }
        catch (Exception e) {
            throw new MBeanMetaException(e.getMessage());
        }
        String[] names = registry.findManagedBeans();
        this.entries = new MBeanRegistryEntry[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.entries[i] = new MBeanRegistryEntry(new MyManagedBean(registry.findManagedBean(names[i])));
        }
    }

    public MBeanRegistryEntry findMBeanRegistryEntry(ObjectName objectName) {
        try {
            Hashtable<String, String> ht = objectName.getKeyPropertyList();
            ht.put(":", objectName.getDomain());
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i] == null || !this.entries[i].isObjectNamePatternMatch(ht)) continue;
                return this.entries[i];
            }
        }
        catch (Exception e) {
            _sLogger.log(Level.FINE, MSG_FINDREGISTRYENTRY_FAILED, e);
        }
        return null;
    }

    public MBeanRegistryEntry findMBeanRegistryEntryByType(String type) {
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null || !this.entries[i].getName().equals(type)) continue;
            return this.entries[i];
        }
        return null;
    }

    public MBeanRegistryEntry findMBeanRegistryEntryByXPath(String xpath) {
        if (xpath != null) {
            while (xpath.length() > 1 && xpath.endsWith("/")) {
                xpath = xpath.substring(0, xpath.length() - 1);
            }
        }
        Object[] tokens = MBeanNamingDescriptor.getXPathTokens(xpath);
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.entries[i].getNamingDescriptor().isXpathTokensMatch(tokens)) continue;
            return this.entries[i];
        }
        return null;
    }

    public MBeanRegistryEntry findMBeanRegistryEntryByXPathPattern(String patternPrefix) {
        patternPrefix = MBeanNamingDescriptor.XPATH_TO_MASK(patternPrefix);
        int len = patternPrefix.length();
        for (int i = 0; i < this.entries.length; ++i) {
            String pattern = this.entries[i].namingDescriptor.getXPathPattern();
            if (pattern == null || !pattern.startsWith(patternPrefix) || pattern.length() != len && pattern.indexOf(47, len) >= 0) continue;
            return this.entries[i];
        }
        return null;
    }

    public ObjectName getMbeanObjectName(String type, String[] location) {
        return this.getMbeanObjectName(this.findMBeanRegistryEntryByType(type), type, location);
    }

    private ObjectName getMbeanObjectName(MBeanRegistryEntry entry, String type, String[] location) {
        if (entry != null) {
            try {
                MBeanNamingInfo namingInfo = new MBeanNamingInfo(entry.getNamingDescriptor(), type, location);
                if (namingInfo != null) {
                    return namingInfo.getObjectName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public BaseAdminMBean instantiateConfigMBean(ObjectName objectName, Object managedResource) throws Exception {
        return this.instantiateConfigMBean(objectName, managedResource, null);
    }

    public BaseAdminMBean instantiateConfigMBean(ObjectName objectName, Object managedResource, ConfigContext ctx) throws Exception {
        MBeanRegistryEntry entry = this.findMBeanRegistryEntry(objectName);
        if (entry != null) {
            MBeanNamingDescriptor descr = entry.getNamingDescriptor();
            return entry.instantiateMBean(objectName, managedResource, ctx);
        }
        return null;
    }

    public BaseAdminMBean instantiateMBean(String type, String[] location) throws Exception {
        return this.instantiateMBean(type, location, null, null);
    }

    public BaseAdminMBean instantiateMBean(String type, String[] location, Object managedResource) throws Exception {
        return this.instantiateMBean(type, location, null);
    }

    public BaseAdminMBean instantiateMBean(String type, String[] location, Object managedResource, ConfigContext ctx) throws Exception {
        return this.instantiateMBean(type, location, managedResource, ctx, false);
    }

    public MBeanNamingInfo getMBeanNamingInfo(ObjectName objectName) throws Exception {
        MBeanRegistryEntry entry = this.findMBeanRegistryEntry(objectName);
        return new MBeanNamingInfo(entry.getNamingDescriptor(), objectName);
    }

    public void notifyRegisterMBean(ObjectName objectName, ConfigContext ctx) {
        try {
            MBeanNamingInfo namingInfo = this.getMBeanNamingInfo(objectName);
            ArrayList arr = this.getValidDottedNames(namingInfo);
            if (arr != null) {
                for (int i = 0; i < arr.size(); ++i) {
                    this.addDottedName((String)arr.get(i), namingInfo.getObjectName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void notifyUnregisterMBean(ObjectName objectName, ConfigContext ctx) {
        try {
            MBeanNamingInfo namingInfo = this.getMBeanNamingInfo(objectName);
            ConfigBean bean = null;
            try {
                bean = ConfigBeansFactory.getConfigBeanByXPath(ctx, namingInfo.getXPath());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (bean == null) {
                this.removeDottedName(objectName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void generateAndRegisterAllDottedNames(ConfigContext ctx, String domainName) throws MBeanMetaException {
        ConfigBean bean = null;
        try {
            bean = ConfigBeansFactory.getConfigBeanByXPath(ctx, "/domain");
            this.registerDottedName(bean, domainName);
        }
        catch (Exception e) {
            throw new MBeanMetaException("DottedNamesRegistration: Could not get '/domain' ConfigMBean");
        }
    }

    public void instantiateAndRegisterAllConfigMBeans(ConfigContext ctx, String domainName) throws MBeanMetaException {
        ConfigBean bean = null;
        try {
            bean = ConfigBeansFactory.getConfigBeanByXPath(ctx, ServerXPathHelper.XPATH_DOMAIN);
        }
        catch (ConfigException e) {
            _sLogger.log(Level.FINEST, "Exception during Instantiating All Config MBeans in MBeanRegistry", e);
            throw new MBeanMetaException("ConfigException in getting Domain bean from config context", e);
        }
        this.instantiateAndRegisterConfigMBeans(bean, domainName);
        _sLogger.log(Level.FINEST, "Instantiated All Config MBeans in MBeanRegistry Successfully");
    }

    private String getFirstValidDottedName(MBeanNamingInfo namingInfo) {
        ArrayList arr = this.getValidDottedNames(namingInfo);
        if (arr != null && arr.size() > 0) {
            return (String)arr.get(0);
        }
        return null;
    }

    private ArrayList getValidDottedNames(MBeanNamingInfo namingInfo) {
        ArrayList<String> arr = new ArrayList<String>();
        try {
            String[] dottedNames = namingInfo.getDottedNames();
            for (int i = 0; i < dottedNames.length; ++i) {
                if (dottedNames[i].length() <= 0 || dottedNames[i].startsWith("@")) continue;
                arr.add(dottedNames[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arr;
    }

    private void registerDottedName(ConfigBean bean, String domainName) {
        block8: {
            if (bean == null) {
                return;
            }
            String xpath = bean.getAbsoluteXPath("");
            try {
                MBeanNamingInfo namingInfo = this.getNamingInfoForConfigBean(bean, domainName);
                ObjectName objectName = namingInfo.getObjectName();
                ArrayList arr = this.getValidDottedNames(namingInfo);
                if (arr != null) {
                    for (int i = 0; i < arr.size(); ++i) {
                        this.addDottedName((String)arr.get(i), objectName);
                    }
                }
            }
            catch (Exception e) {
                if (xpath == null || xpath.indexOf("/" + ServerTags.ELEMENT_PROPERTY + "[") != 0) break block8;
                _sLogger.log(Level.FINE, "---- Exception for xpath=" + xpath, e);
            }
        }
        try {
            ConfigBean[] beans = bean.getAllChildBeans();
            for (int i = 0; i < beans.length; ++i) {
                this.registerDottedName(beans[i], domainName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void instantiateAndRegisterConfigMBeans(ConfigBean bean, String domainName) {
        ConfigContext ctx;
        block10: {
            if (bean == null) {
                return;
            }
            String xpath = bean.getAbsoluteXPath("");
            ctx = bean.getConfigContext();
            try {
                MBeanServer mServer;
                ObjectName objectName = this.getObjectNameForConfigBean(bean, domainName);
                if (objectName != null && !(mServer = MBeanServerFactory.findMBeanServer(null).get(0)).isRegistered(objectName)) {
                    BaseAdminMBean mbean = this.instantiateConfigMBean(objectName, null, ctx);
                    this.registerMBean(mbean, objectName);
                }
            }
            catch (Exception e) {
                if (xpath == null || xpath.indexOf("/" + ServerTags.ELEMENT_PROPERTY + "[") != 0) break block10;
                _sLogger.log(Level.FINEST, "---- Exception for xpath=" + xpath, e);
            }
        }
        try {
            ConfigBean[] beans = bean.getAllChildBeans();
            for (int i = 0; i < beans.length; ++i) {
                if (beans[i] != null && beans[i].getConfigContext() == null) {
                    beans[i].setConfigContext(ctx);
                }
                try {
                    this.instantiateAndRegisterConfigMBeans(beans[i], domainName);
                    continue;
                }
                catch (Exception e1) {
                    _sLogger.log(Level.FINEST, "Exception in instantiateAndRegisterConfigMBeans:", e1);
                }
            }
        }
        catch (Exception e) {
            _sLogger.log(Level.FINEST, "Exception in instantiateAndRegisterConfigMBeans:", e);
        }
    }

    private void registerMBean(BaseAdminMBean mbean, ObjectName name) throws Exception {
        MBeanServer mServer = MBeanServerFactory.findMBeanServer(null).get(0);
        if (!mServer.isRegistered(name)) {
            mServer.registerMBean(mbean, name);
        }
    }

    private static ObjectName getDottedRegMBeanName() {
        try {
            return new ObjectName("com.sun.appserv:name=dotted-name-registry,type=dotted-name-support");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addDottedName(String dottedName, ObjectName objectName) throws Exception {
        _sLogger.log(Level.FINE, "******regDottedName******* " + dottedName + " ObjectName=" + objectName);
        MBeanServer mbeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
        mbeanServer.invoke(REGISTRATION_MBEAN_OBJECTNAME, REGISTRATION_OPERATION_NAME, new Object[]{dottedName, objectName}, new String[]{dottedName.getClass().getName(), objectName.getClass().getName()});
    }

    private void removeDottedName(ObjectName objectName) throws Exception {
        _sLogger.log(Level.FINE, "******unregDottedName******* for ObjectName=" + objectName);
        MBeanServer mbeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
        mbeanServer.invoke(REGISTRATION_MBEAN_OBJECTNAME, UNREGISTRATION_OPERATION_NAME, new Object[]{objectName}, new String[]{objectName.getClass().getName()});
    }

    public BaseAdminMBean instantiateMBean(String type, String[] location, Object managedResource, ConfigContext ctx, boolean bRegister) throws Exception {
        MBeanRegistryEntry entry = this.findMBeanRegistryEntryByType(type);
        BaseAdminMBean mbean = null;
        if (entry != null) {
            ObjectName objectName;
            mbean = entry.instantiateMBean(type, location, managedResource, location[0], ctx);
            if (bRegister && mbean != null && (objectName = this.getMbeanObjectName(entry, type, location)) != null) {
                this.registerMBean(mbean, objectName);
            }
        }
        return mbean;
    }

    public void sortRegistryEntries(int sortType) {
        TreeMap<String, MBeanRegistryEntry> map = new TreeMap<String, MBeanRegistryEntry>();
        String emptyKey = " ";
        for (int i = 0; i < this.entries.length; ++i) {
            String key = sortType == 1 ? this.entries[i].getNamingDescriptor().getXPathPattern() : this.entries[i].getName();
            if (key == null || key.length() == 0) {
                key = emptyKey;
                emptyKey = emptyKey + " ";
            }
            map.put(key, this.entries[i]);
        }
        this.entries = (MBeanRegistryEntry[])map.values().toArray((Object[])new MBeanRegistryEntry[0]);
    }

    public void adoptConfigBeanAdd(ConfigBean bean, String domainName) {
        _sLogger.log(Level.FINEST, "****** MBeanRegistry.adoptConfigBeanAddDelete->add element:" + bean);
        this.instantiateAndRegisterConfigMBeans(bean, domainName);
        this.registerDottedName(bean, domainName);
    }

    public void adoptConfigBeanDelete(ConfigBean bean, String domainName) {
        _sLogger.log(Level.FINEST, "****** MBeanRegistry.adoptConfigBeanAddDelete->delete element" + bean);
        ArrayList arr = new ArrayList();
        this.collectChildrenObjectNames(bean, domainName, arr);
        for (int i = 0; i < arr.size(); ++i) {
            ObjectName objectName = (ObjectName)arr.get(i);
            if (objectName == null) continue;
            try {
                this.removeDottedName(objectName);
            }
            catch (Throwable t) {
                _sLogger.fine("!!!!!!!!!!!!!! Can not unregister dotted name for MBean: " + objectName);
            }
            try {
                MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
                if (!server.isRegistered(objectName)) continue;
                server.unregisterMBean(objectName);
                continue;
            }
            catch (Throwable t) {
                _sLogger.fine("!!!!!!!!!!!!!! Can not unregister MBean: " + objectName);
            }
        }
    }

    private void collectChildrenObjectNames(ConfigBean bean, String domainName, ArrayList arr) {
        try {
            ConfigBean[] beans = bean.getAllChildBeans();
            for (int i = 0; i < beans.length; ++i) {
                this.collectChildrenObjectNames(beans[i], domainName, arr);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ObjectName name = this.getObjectNameForConfigBean(bean, domainName);
            if (name != null) {
                arr.add(name);
                _sLogger.log(Level.FINEST, "******collectChildrenObjectNames.add-> ");
            }
        }
        catch (MalformedObjectNameException e) {
            String xpath = bean.getAbsoluteXPath("");
            _sLogger.log(Level.FINE, "Object name malformed for bean: " + xpath, e);
        }
    }

    private MBeanNamingInfo getNamingInfoForConfigBean(ConfigBean bean, String domainName) {
        if (bean == null) {
            return null;
        }
        try {
            String xpath = bean.getAbsoluteXPath("");
            MBeanRegistryEntry entry = this.findMBeanRegistryEntryByXPath(xpath);
            MBeanNamingDescriptor descr = entry.getNamingDescriptor();
            String[] parms = descr.extractParmListFromXPath(xpath);
            if (parms != null && parms.length > 0 && parms[0] == null) {
                parms[0] = domainName;
            }
            return new MBeanNamingInfo(descr, descr.getType(), parms);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ObjectName getObjectNameForConfigBean(ConfigBean bean, String domainName) throws MalformedObjectNameException {
        MBeanNamingInfo namingInfo = this.getNamingInfoForConfigBean(bean, domainName);
        if (namingInfo != null) {
            return namingInfo.getObjectName();
        }
        return null;
    }

    private class MyManagedBean
    extends ManagedBean {
        public MyManagedBean(ManagedBean mb) {
            AttributeInfo[] attrs = mb.getAttributes();
            if (attrs.length > 0 && "modelerType".equals(attrs[0].getName())) {
                this.attributes = new AttributeInfo[attrs.length - 1];
                for (int i = 1; i < attrs.length; ++i) {
                    this.attributes[i - 1] = attrs[i];
                }
            } else {
                this.attributes = attrs;
            }
            this.className = mb.getClassName();
            this.constructors = mb.getConstructors();
            this.description = mb.getDescription();
            this.domain = mb.getDomain();
            this.group = mb.getGroup();
            this.name = mb.getName();
            this.fields = mb.getFields();
            this.notifications = mb.getNotifications();
            this.operations = mb.getOperations();
            this.type = mb.getType();
        }
    }

    private class MyRegistry
    extends Registry {
    }
}

