/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.mbeans.Resource;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ResourcesXMLParser {
    private File resourceFile = null;
    private Document document;
    private Vector vResources;
    private static StringManager localStrings = StringManager.getManager(ResourcesXMLParser.class);
    public static final String JNDI_NAME = "jndi-name";
    public static final String POOL_NAME = "pool-name";
    public static final String RES_TYPE = "res-type";
    public static final String FACTORY_CLASS = "factory-class";
    public static final String ENABLED = "enabled";
    public static final String JNDI_LOOKUP = "jndi-lookup-name";
    public static final String CONNECTION_POOL_NAME = "name";
    public static final String STEADY_POOL_SIZE = "steady-pool-size";
    public static final String MAX_POOL_SIZE = "max-pool-size";
    public static final String MAX_WAIT_TIME_IN_MILLIS = "max-wait-time-in-millis";
    public static final String POOL_SIZE_QUANTITY = "pool-resize-quantity";
    public static final String IDLE_TIME_OUT_IN_SECONDS = "idle-timeout-in-seconds";
    public static final String IS_CONNECTION_VALIDATION_REQUIRED = "is-connection-validation-required";
    public static final String CONNECTION_VALIDATION_METHOD = "connection-validation-method";
    public static final String FAIL_ALL_CONNECTIONS = "fail-all-connections";
    public static final String VALIDATION_TABLE_NAME = "validation-table-name";
    public static final String DATASOURCE_CLASS = "datasource-classname";
    public static final String TRANS_ISOLATION_LEVEL = "transaction-isolation-level";
    public static final String IS_ISOLATION_LEVEL_GUARANTEED = "is-isolation-level-guaranteed";
    public static final String MAIL_HOST = "host";
    public static final String MAIL_USER = "user";
    public static final String MAIL_FROM_ADDRESS = "from";
    public static final String MAIL_STORE_PROTO = "store-protocol";
    public static final String MAIL_STORE_PROTO_CLASS = "store-protocol-class";
    public static final String MAIL_TRANS_PROTO = "transport-protocol";
    public static final String MAIL_TRANS_PROTO_CLASS = "transport-protocol-class";
    public static final String MAIL_DEBUG = "debug";
    public static final String JDBC_RESOURCE_JNDI_NAME = "jdbc-resource-jndi-name";
    public static final String RES_ADAPTER = "res-adapter";
    public static final String RESOURCE_TYPE = "resource-type";
    public static final String CONNECTOR_CONN_DESCRIPTION = "description";
    public static final String CONNECTOR_SECURITY_MAP = "security-map";
    public static final String CONNECTOR_PROPERTY = "property";
    public static final String CONNECTOR_CONNECTION_POOL_NAME = "name";
    public static final String RESOURCE_ADAPTER_CONFIG_NAME = "resource-adapter-name";
    public static final String CONN_DEF_NAME = "connection-definition-name";
    public static final String CONN_STEADY_POOL_SIZE = "steady-pool-size";
    public static final String CONN_MAX_POOL_SIZE = "max-pool-size";
    public static final String CONN_POOL_RESIZE_QUANTITY = "pool-resize-quantity";
    public static final String CONN_IDLE_TIME_OUT = "idle-timeout-in-seconds";
    public static final String CONN_FAIL_ALL_CONNECTIONS = "fail-all-connections";
    public static final String SECURITY_MAP = "security-map";
    public static final String SECURITY_MAP_NAME = "name";
    public static final String PRINCIPAL = "principal";
    public static final String USERGROUP = "user-group";
    public static final String BACKEND_PRINCIPAL = "backend-principal";
    public static final String RES_ADAPTER_CONFIG = "resource-adapter-config";
    public static final String THREAD_POOL_IDS = "thread-pool-ids";
    public static final String RES_ADAPTER_NAME = "resource-adapter-name";
    public static final String USER_NAME = "user-name";
    public static final String PASSWORD = "password";

    public ResourcesXMLParser(String resourceFileName) throws Exception {
        this.resourceFile = new File(resourceFileName);
        this.initProperties();
        this.vResources = new Vector();
        this.generateResourceObjects();
    }

    public void initProperties() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            AddResourcesErrorHandler errorHandler = new AddResourcesErrorHandler();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(errorHandler);
            if (this.resourceFile == null) {
                String msg = localStrings.getString("admin.server.core.mbean.config.no_resource_file");
                throw new Exception(msg);
            }
            InputSource is = new InputSource(this.resourceFile.toString());
            this.document = builder.parse(is);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            throw new Exception(x.getLocalizedMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new Exception(pce.getLocalizedMessage());
        }
        catch (IOException ioe) {
            throw new Exception(ioe.getLocalizedMessage());
        }
    }

    private void generateResourceObjects() throws Exception {
        if (this.document != null) {
            for (Node nextKid = this.document.getDocumentElement().getFirstChild(); nextKid != null; nextKid = nextKid.getNextSibling()) {
                String nodeName = nextKid.getNodeName();
                if (nodeName.equalsIgnoreCase(Resource.CUSTOM_RESOURCE)) {
                    this.generateCustomResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase(Resource.EXTERNAL_JNDI_RESOURCE)) {
                    this.generateJNDIResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase(Resource.JDBC_RESOURCE)) {
                    this.generateJDBCResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase(Resource.JDBC_CONNECTION_POOL)) {
                    this.generateJDBCConnectionPoolResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase(Resource.MAIL_RESOURCE)) {
                    this.generateMailResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase(Resource.PERSISTENCE_MANAGER_FACTORY_RESOURCE)) {
                    this.generatePersistenceResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase(Resource.ADMIN_OBJECT_RESOURCE)) {
                    this.generateAdminObjectResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase(Resource.CONNECTOR_RESOURCE)) {
                    this.generateConnectorResource(nextKid);
                    continue;
                }
                if (nodeName.equalsIgnoreCase(Resource.CONNECTOR_CONNECTION_POOL)) {
                    this.generateConnectorConnectionPoolResource(nextKid);
                    continue;
                }
                if (!nodeName.equalsIgnoreCase(Resource.RESOURCE_ADAPTER_CONFIG)) continue;
                this.generateResourceAdapterConfig(nextKid);
            }
        }
    }

    private void generateCustomResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem(JNDI_NAME);
        String jndiName = jndiNameNode.getNodeValue();
        Node resTypeNode = attributes.getNamedItem(RES_TYPE);
        String resType = resTypeNode.getNodeValue();
        Node factoryClassNode = attributes.getNamedItem(FACTORY_CLASS);
        String factoryClass = factoryClassNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem(ENABLED);
        Resource customResource = new Resource(Resource.CUSTOM_RESOURCE);
        customResource.setAttribute(JNDI_NAME, jndiName);
        customResource.setAttribute(RES_TYPE, resType);
        customResource.setAttribute(FACTORY_CLASS, factoryClass);
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            customResource.setAttribute(ENABLED, sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(customResource, children);
        this.vResources.add(customResource);
        this.printResourceElements(customResource);
    }

    private void generateJNDIResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem(JNDI_NAME);
        String jndiName = jndiNameNode.getNodeValue();
        Node jndiLookupNode = attributes.getNamedItem(JNDI_LOOKUP);
        String jndiLookup = jndiLookupNode.getNodeValue();
        Node resTypeNode = attributes.getNamedItem(RES_TYPE);
        String resType = resTypeNode.getNodeValue();
        Node factoryClassNode = attributes.getNamedItem(FACTORY_CLASS);
        String factoryClass = factoryClassNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem(ENABLED);
        Resource jndiResource = new Resource(Resource.EXTERNAL_JNDI_RESOURCE);
        jndiResource.setAttribute(JNDI_NAME, jndiName);
        jndiResource.setAttribute(JNDI_LOOKUP, jndiLookup);
        jndiResource.setAttribute(RES_TYPE, resType);
        jndiResource.setAttribute(FACTORY_CLASS, factoryClass);
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            jndiResource.setAttribute(ENABLED, sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(jndiResource, children);
        this.vResources.add(jndiResource);
        this.printResourceElements(jndiResource);
    }

    private void generateJDBCResource(Node nextKid) throws Exception {
        NodeList children;
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem(JNDI_NAME);
        String jndiName = jndiNameNode.getNodeValue();
        Node poolNameNode = attributes.getNamedItem(POOL_NAME);
        String poolName = poolNameNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem(ENABLED);
        Resource jdbcResource = new Resource(Resource.JDBC_RESOURCE);
        jdbcResource.setAttribute(JNDI_NAME, jndiName);
        jdbcResource.setAttribute(POOL_NAME, poolName);
        if (enabledNode != null) {
            String enabledName = enabledNode.getNodeValue();
            jdbcResource.setAttribute(ENABLED, enabledName);
        }
        if ((children = nextKid.getChildNodes()) != null) {
            for (int ii = 0; ii < children.getLength(); ++ii) {
                if (!children.item(ii).getNodeName().equals(CONNECTOR_CONN_DESCRIPTION)) continue;
                jdbcResource.setDescription(children.item(ii).getFirstChild().getNodeValue());
            }
        }
        this.vResources.add(jdbcResource);
        this.printResourceElements(jdbcResource);
    }

    private void generateJDBCConnectionPoolResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node nameNode = attributes.getNamedItem("name");
        String name = nameNode.getNodeValue();
        Node nSteadyPoolSizeNode = attributes.getNamedItem("steady-pool-size");
        Node nMaxPoolSizeNode = attributes.getNamedItem("max-pool-size");
        Node nMaxWaitTimeInMillisNode = attributes.getNamedItem(MAX_WAIT_TIME_IN_MILLIS);
        Node nPoolSizeQuantityNode = attributes.getNamedItem("pool-resize-quantity");
        Node nIdleTimeoutInSecNode = attributes.getNamedItem("idle-timeout-in-seconds");
        Node nIsConnectionValidationRequiredNode = attributes.getNamedItem(IS_CONNECTION_VALIDATION_REQUIRED);
        Node nConnectionValidationMethodNode = attributes.getNamedItem(CONNECTION_VALIDATION_METHOD);
        Node nFailAllConnectionsNode = attributes.getNamedItem("fail-all-connections");
        Node nValidationTableNameNode = attributes.getNamedItem(VALIDATION_TABLE_NAME);
        Node nResType = attributes.getNamedItem(RES_TYPE);
        Node nTransIsolationLevel = attributes.getNamedItem(TRANS_ISOLATION_LEVEL);
        Node nIsIsolationLevelQuaranteed = attributes.getNamedItem(IS_ISOLATION_LEVEL_GUARANTEED);
        Node datasourceNode = attributes.getNamedItem(DATASOURCE_CLASS);
        String datasource = datasourceNode.getNodeValue();
        Resource jdbcResource = new Resource(Resource.JDBC_CONNECTION_POOL);
        jdbcResource.setAttribute("name", name);
        jdbcResource.setAttribute(DATASOURCE_CLASS, datasource);
        if (nSteadyPoolSizeNode != null) {
            String sSteadyPoolSize = nSteadyPoolSizeNode.getNodeValue();
            jdbcResource.setAttribute("steady-pool-size", sSteadyPoolSize);
        }
        if (nMaxPoolSizeNode != null) {
            String sMaxPoolSize = nMaxPoolSizeNode.getNodeValue();
            jdbcResource.setAttribute("max-pool-size", sMaxPoolSize);
        }
        if (nMaxWaitTimeInMillisNode != null) {
            String sMaxWaitTimeInMillis = nMaxWaitTimeInMillisNode.getNodeValue();
            jdbcResource.setAttribute(MAX_WAIT_TIME_IN_MILLIS, sMaxWaitTimeInMillis);
        }
        if (nPoolSizeQuantityNode != null) {
            String sPoolSizeQuantity = nPoolSizeQuantityNode.getNodeValue();
            jdbcResource.setAttribute("pool-resize-quantity", sPoolSizeQuantity);
        }
        if (nIdleTimeoutInSecNode != null) {
            String sIdleTimeoutInSec = nIdleTimeoutInSecNode.getNodeValue();
            jdbcResource.setAttribute("idle-timeout-in-seconds", sIdleTimeoutInSec);
        }
        if (nIsConnectionValidationRequiredNode != null) {
            String sIsConnectionValidationRequired = nIsConnectionValidationRequiredNode.getNodeValue();
            jdbcResource.setAttribute(IS_CONNECTION_VALIDATION_REQUIRED, sIsConnectionValidationRequired);
        }
        if (nConnectionValidationMethodNode != null) {
            String sConnectionValidationMethod = nConnectionValidationMethodNode.getNodeValue();
            jdbcResource.setAttribute(CONNECTION_VALIDATION_METHOD, sConnectionValidationMethod);
        }
        if (nFailAllConnectionsNode != null) {
            String sFailAllConnection = nFailAllConnectionsNode.getNodeValue();
            jdbcResource.setAttribute("fail-all-connections", sFailAllConnection);
        }
        if (nValidationTableNameNode != null) {
            String sValidationTableName = nValidationTableNameNode.getNodeValue();
            jdbcResource.setAttribute(VALIDATION_TABLE_NAME, sValidationTableName);
        }
        if (nResType != null) {
            String sResType = nResType.getNodeValue();
            jdbcResource.setAttribute(RES_TYPE, sResType);
        }
        if (nTransIsolationLevel != null) {
            String sTransIsolationLevel = nTransIsolationLevel.getNodeValue();
            jdbcResource.setAttribute(TRANS_ISOLATION_LEVEL, sTransIsolationLevel);
        }
        if (nIsIsolationLevelQuaranteed != null) {
            String sIsIsolationLevelQuaranteed = nIsIsolationLevelQuaranteed.getNodeValue();
            jdbcResource.setAttribute(IS_ISOLATION_LEVEL_GUARANTEED, sIsIsolationLevelQuaranteed);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(jdbcResource, children);
        this.vResources.add(jdbcResource);
        this.printResourceElements(jdbcResource);
    }

    private void generateMailResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem(JNDI_NAME);
        Node hostNode = attributes.getNamedItem(MAIL_HOST);
        Node userNode = attributes.getNamedItem(MAIL_USER);
        Node fromAddressNode = attributes.getNamedItem(MAIL_FROM_ADDRESS);
        Node storeProtoNode = attributes.getNamedItem(MAIL_STORE_PROTO);
        Node storeProtoClassNode = attributes.getNamedItem(MAIL_STORE_PROTO_CLASS);
        Node transProtoNode = attributes.getNamedItem(MAIL_TRANS_PROTO);
        Node transProtoClassNode = attributes.getNamedItem(MAIL_TRANS_PROTO_CLASS);
        Node debugNode = attributes.getNamedItem(MAIL_DEBUG);
        Node enabledNode = attributes.getNamedItem(ENABLED);
        String jndiName = jndiNameNode.getNodeValue();
        String host = hostNode.getNodeValue();
        String user = userNode.getNodeValue();
        String fromAddress = fromAddressNode.getNodeValue();
        Resource mailResource = new Resource(Resource.MAIL_RESOURCE);
        mailResource.setAttribute(JNDI_NAME, jndiName);
        mailResource.setAttribute(MAIL_HOST, host);
        mailResource.setAttribute(MAIL_USER, user);
        mailResource.setAttribute(MAIL_FROM_ADDRESS, fromAddress);
        if (storeProtoNode != null) {
            String sStoreProto = storeProtoNode.getNodeValue();
            mailResource.setAttribute(MAIL_STORE_PROTO, sStoreProto);
        }
        if (storeProtoClassNode != null) {
            String sStoreProtoClass = storeProtoClassNode.getNodeValue();
            mailResource.setAttribute(MAIL_STORE_PROTO_CLASS, sStoreProtoClass);
        }
        if (transProtoNode != null) {
            String sTransProto = transProtoNode.getNodeValue();
            mailResource.setAttribute(MAIL_TRANS_PROTO, sTransProto);
        }
        if (transProtoClassNode != null) {
            String sTransProtoClass = transProtoClassNode.getNodeValue();
            mailResource.setAttribute(MAIL_TRANS_PROTO_CLASS, sTransProtoClass);
        }
        if (debugNode != null) {
            String sDebug = debugNode.getNodeValue();
            mailResource.setAttribute(MAIL_DEBUG, sDebug);
        }
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            mailResource.setAttribute(ENABLED, sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(mailResource, children);
        this.vResources.add(mailResource);
        this.printResourceElements(mailResource);
    }

    private void generatePersistenceResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem(JNDI_NAME);
        String jndiName = jndiNameNode.getNodeValue();
        Node factoryClassNode = attributes.getNamedItem(FACTORY_CLASS);
        Node poolNameNode = attributes.getNamedItem(JDBC_RESOURCE_JNDI_NAME);
        Node enabledNode = attributes.getNamedItem(ENABLED);
        Resource persistenceResource = new Resource(Resource.PERSISTENCE_MANAGER_FACTORY_RESOURCE);
        persistenceResource.setAttribute(JNDI_NAME, jndiName);
        if (factoryClassNode != null) {
            String factoryClass = factoryClassNode.getNodeValue();
            persistenceResource.setAttribute(FACTORY_CLASS, factoryClass);
        }
        if (poolNameNode != null) {
            String poolName = poolNameNode.getNodeValue();
            persistenceResource.setAttribute(JDBC_RESOURCE_JNDI_NAME, poolName);
        }
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            persistenceResource.setAttribute(ENABLED, sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(persistenceResource, children);
        this.vResources.add(persistenceResource);
        this.printResourceElements(persistenceResource);
    }

    private void generateAdminObjectResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem(JNDI_NAME);
        String jndiName = jndiNameNode.getNodeValue();
        Node resTypeNode = attributes.getNamedItem(RES_TYPE);
        String resType = resTypeNode.getNodeValue();
        Node resAdapterNode = attributes.getNamedItem(RES_ADAPTER);
        String resAdapter = resAdapterNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem(ENABLED);
        Resource adminObjectResource = new Resource(Resource.ADMIN_OBJECT_RESOURCE);
        adminObjectResource.setAttribute(JNDI_NAME, jndiName);
        adminObjectResource.setAttribute(RES_TYPE, resType);
        adminObjectResource.setAttribute(RES_ADAPTER, resAdapter);
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            adminObjectResource.setAttribute(ENABLED, sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(adminObjectResource, children);
        this.vResources.add(adminObjectResource);
        this.printResourceElements(adminObjectResource);
    }

    private void generateConnectorResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem(JNDI_NAME);
        String jndiName = jndiNameNode.getNodeValue();
        Node poolNameNode = attributes.getNamedItem(POOL_NAME);
        String poolName = poolNameNode.getNodeValue();
        Node resTypeNode = attributes.getNamedItem(RESOURCE_TYPE);
        Node enabledNode = attributes.getNamedItem(ENABLED);
        Resource connectorResource = new Resource(Resource.CONNECTOR_RESOURCE);
        connectorResource.setAttribute(JNDI_NAME, jndiName);
        connectorResource.setAttribute(POOL_NAME, poolName);
        if (resTypeNode != null) {
            String resType = resTypeNode.getNodeValue();
            connectorResource.setAttribute(RESOURCE_TYPE, resType);
        }
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            connectorResource.setAttribute(ENABLED, sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(connectorResource, children);
        this.vResources.add(connectorResource);
        this.printResourceElements(connectorResource);
    }

    private void generatePropertyElement(Resource rs, NodeList children) throws Exception {
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeName().equals(CONNECTOR_PROPERTY)) {
                    NamedNodeMap attNodeMap = children.item(i).getAttributes();
                    Node nameNode = attNodeMap.getNamedItem("name");
                    Node valueNode = attNodeMap.getNamedItem("value");
                    if (nameNode != null && valueNode != null) {
                        boolean bDescFound = false;
                        String sName = nameNode.getNodeValue();
                        String sValue = valueNode.getNodeValue();
                        for (Node descNode = children.item(i).getFirstChild(); descNode != null && !bDescFound; descNode = descNode.getNextSibling()) {
                            if (!descNode.getNodeName().equalsIgnoreCase(CONNECTOR_CONN_DESCRIPTION)) continue;
                            try {
                                rs.setProperty(sName, sValue);
                                bDescFound = true;
                                continue;
                            }
                            catch (DOMException dome) {
                                throw new Exception(dome.getLocalizedMessage());
                            }
                        }
                        if (!bDescFound) {
                            rs.setProperty(sName, sValue);
                        }
                    }
                }
                if (!children.item(i).getNodeName().equals(CONNECTOR_CONN_DESCRIPTION)) continue;
                rs.setDescription(children.item(i).getFirstChild().getNodeValue());
            }
        }
    }

    private void generateConnectorConnectionPoolResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node nameNode = attributes.getNamedItem("name");
        Node raConfigNode = attributes.getNamedItem("resource-adapter-name");
        Node conDefNode = attributes.getNamedItem(CONN_DEF_NAME);
        Node steadyPoolSizeNode = attributes.getNamedItem("steady-pool-size");
        Node maxPoolSizeNode = attributes.getNamedItem("max-pool-size");
        Node poolResizeNode = attributes.getNamedItem("pool-resize-quantity");
        Node idleTimeOutNode = attributes.getNamedItem("idle-timeout-in-seconds");
        Node failAllConnNode = attributes.getNamedItem("fail-all-connections");
        String poolName = null;
        Resource connectorConnPoolResource = new Resource(Resource.CONNECTOR_CONNECTION_POOL);
        if (nameNode != null) {
            poolName = nameNode.getNodeValue();
            connectorConnPoolResource.setAttribute("name", poolName);
        }
        if (raConfigNode != null) {
            String raConfig = raConfigNode.getNodeValue();
            connectorConnPoolResource.setAttribute("resource-adapter-name", raConfig);
        }
        if (conDefNode != null) {
            String conDef = conDefNode.getNodeValue();
            connectorConnPoolResource.setAttribute(CONN_DEF_NAME, conDef);
        }
        if (steadyPoolSizeNode != null) {
            String steadyPoolSize = steadyPoolSizeNode.getNodeValue();
            connectorConnPoolResource.setAttribute("steady-pool-size", steadyPoolSize);
        }
        if (maxPoolSizeNode != null) {
            String maxPoolSize = maxPoolSizeNode.getNodeValue();
            connectorConnPoolResource.setAttribute("max-pool-size", maxPoolSize);
        }
        if (poolResizeNode != null) {
            String poolResize = poolResizeNode.getNodeValue();
            connectorConnPoolResource.setAttribute("pool-resize-quantity", poolResize);
        }
        if (idleTimeOutNode != null) {
            String idleTimeOut = idleTimeOutNode.getNodeValue();
            connectorConnPoolResource.setAttribute("idle-timeout-in-seconds", idleTimeOut);
        }
        if (failAllConnNode != null) {
            String failAllConn = failAllConnNode.getNodeValue();
            connectorConnPoolResource.setAttribute("fail-all-connections", failAllConn);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(connectorConnPoolResource, children);
        this.vResources.add(connectorConnPoolResource);
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (!children.item(i).getNodeName().equals("security-map")) continue;
                this.generateSecurityMap(poolName, children.item(i));
            }
        }
        this.printResourceElements(connectorConnPoolResource);
    }

    private void generateSecurityMap(String poolName, Node mapNode) throws Exception {
        NamedNodeMap attributes = mapNode.getAttributes();
        if (attributes == null) {
            return;
        }
        Node nameNode = attributes.getNamedItem("name");
        Resource map = new Resource(Resource.CONNECTOR_SECURITY_MAP);
        if (nameNode != null) {
            String name = nameNode.getNodeValue();
            map.setAttribute("name", name);
        }
        if (poolName != null) {
            map.setAttribute(POOL_NAME, poolName);
        }
        StringBuffer principal = new StringBuffer();
        StringBuffer usergroup = new StringBuffer();
        NodeList children = mapNode.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node passwordNode;
                NamedNodeMap attributes1;
                Node gChild = children.item(i);
                String strNodeName = gChild.getNodeName();
                if (strNodeName.equals(PRINCIPAL)) {
                    String p = gChild.getFirstChild().getNodeValue();
                    principal.append(p + ",");
                }
                if (strNodeName.equals(USERGROUP)) {
                    String u = gChild.getFirstChild().getNodeValue();
                    usergroup.append(u + ",");
                }
                if (!strNodeName.equals(BACKEND_PRINCIPAL) || (attributes1 = children.item(i).getAttributes()) == null) continue;
                Node userNode = attributes1.getNamedItem(USER_NAME);
                if (userNode != null) {
                    String userName = userNode.getNodeValue();
                    map.setAttribute(USER_NAME, userName);
                }
                if ((passwordNode = attributes1.getNamedItem(PASSWORD)) == null) continue;
                String pwd = passwordNode.getNodeValue();
                map.setAttribute(PASSWORD, pwd);
            }
        }
        if (principal != null) {
            map.setAttribute(PRINCIPAL, this.convertToStringArray(principal.toString()));
        }
        if (usergroup != null) {
            map.setAttribute("user_group", this.convertToStringArray(usergroup.toString()));
        }
        this.vResources.add(map);
    }

    private void generateResourceAdapterConfig(Node nextKid) throws Exception {
        Node resAdapNameNode;
        Node poolIdNode;
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Resource resAdapterConfigResource = new Resource(Resource.RESOURCE_ADAPTER_CONFIG);
        Node resAdapConfigNode = attributes.getNamedItem(RES_ADAPTER_CONFIG);
        if (resAdapConfigNode != null) {
            String resAdapConfig = resAdapConfigNode.getNodeValue();
            resAdapterConfigResource.setAttribute(RES_ADAPTER_CONFIG, resAdapConfig);
        }
        if ((poolIdNode = attributes.getNamedItem(THREAD_POOL_IDS)) != null) {
            String threadPoolId = poolIdNode.getNodeValue();
            resAdapterConfigResource.setAttribute(THREAD_POOL_IDS, threadPoolId);
        }
        if ((resAdapNameNode = attributes.getNamedItem("resource-adapter-name")) != null) {
            String resAdapName = resAdapNameNode.getNodeValue();
            resAdapterConfigResource.setAttribute("resource-adapter-name", resAdapName);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(resAdapterConfigResource, children);
        this.vResources.add(resAdapterConfigResource);
        this.printResourceElements(resAdapterConfigResource);
    }

    public Iterator getResources() {
        return this.vResources.iterator();
    }

    private void printResourceElements(Resource resource) {
        AttributeList attrList = resource.getAttributes();
        for (int i = 0; i < attrList.size(); ++i) {
            Attribute attr = (Attribute)attrList.get(i);
            Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
            logger.log(Level.FINE, "general.print_attr_name", attr.getName());
        }
    }

    private String[] convertToStringArray(Object sOptions) {
        StringTokenizer optionTokenizer = new StringTokenizer((String)sOptions, ",");
        int size = optionTokenizer.countTokens();
        String[] sOptionsList = new String[size];
        for (int ii = 0; ii < size; ++ii) {
            sOptionsList[ii] = optionTokenizer.nextToken();
        }
        return sOptionsList;
    }

    class AddResourcesErrorHandler
    implements ErrorHandler {
        AddResourcesErrorHandler() {
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

