/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.mbeans.InvalidJvmOptionException;
import com.sun.enterprise.admin.util.QuotedStringTokenizer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

class JvmOptionsElement {
    private static final StringManager strMgr = StringManager.getManager(JvmOptionsElement.class);
    private static final JvmOptionsElement DEFAULT = new JvmOptionsElement(){

        boolean hasOption(String option) {
            return false;
        }

        boolean deleteJvmOption(String option) {
            return false;
        }

        String getJvmOptions() {
            return "";
        }

        boolean hasNext() {
            return false;
        }

        void setNext() {
            throw new UnsupportedOperationException();
        }
    };
    private final Set jvmOptions = new LinkedHashSet();
    private JvmOptionsElement next;
    static final char SEP = ' ';

    static boolean isLast(JvmOptionsElement e) {
        return e == DEFAULT;
    }

    private JvmOptionsElement() {
    }

    JvmOptionsElement(String options) throws InvalidJvmOptionException {
        if (null == options) {
            throw new IllegalArgumentException();
        }
        QuotedStringTokenizer strTok = new QuotedStringTokenizer(options, " \t");
        while (strTok.hasMoreTokens()) {
            String option = strTok.nextToken();
            this.checkValidOption(option);
            this.jvmOptions.add(option);
        }
        this.next = DEFAULT;
    }

    void setNext(JvmOptionsElement element) {
        if (null == element) {
            throw new IllegalArgumentException();
        }
        this.next = element;
    }

    boolean hasNext() {
        return DEFAULT != this.next;
    }

    JvmOptionsElement next() {
        return this.next;
    }

    boolean hasOption(String option) {
        boolean exists = this.jvmOptions.contains(option);
        if (!exists) {
            exists = this.next.hasOption(option);
        }
        return exists;
    }

    boolean deleteJvmOption(String option) {
        boolean b1 = this.jvmOptions.remove(option);
        boolean b2 = this.next().deleteJvmOption(option);
        return b1 || b2;
    }

    String getJvmOptions() {
        if (this.jvmOptions.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = this.jvmOptions.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public String toString() {
        return this.getJvmOptions();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean isEqual = false;
        if (o instanceof JvmOptionsElement) {
            JvmOptionsElement that = (JvmOptionsElement)o;
            return this.jvmOptions.containsAll(that.jvmOptions);
        }
        return isEqual;
    }

    private void checkValidOption(String option) throws InvalidJvmOptionException {
        if (null == option || option.equals("")) {
            throw new InvalidJvmOptionException(strMgr.getString("jvmOptions.invalid_option", option));
        }
        if (!option.startsWith("-")) {
            throw new InvalidJvmOptionException(strMgr.getString("jvmOptions.no_dash", option));
        }
        this.checkQuotes(option);
    }

    void checkQuotes(String option) throws InvalidJvmOptionException {
        int length = option.length();
        int numQuotes = 0;
        for (int index = 0; index < length && (index = option.indexOf(34, index)) != -1; ++index) {
            ++numQuotes;
        }
        if (numQuotes % 2 != 0) {
            throw new InvalidJvmOptionException(strMgr.getString("jvmOptions.incorrect_quotes", option));
        }
    }
}

