/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.mbeans.InvalidJvmOptionException;
import com.sun.enterprise.admin.mbeans.JvmOptionsElement;
import com.sun.enterprise.admin.util.QuotedStringTokenizer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;

final class JvmOptions {
    private final JvmOptionsElement head;

    JvmOptions(String[] options) throws InvalidJvmOptionException {
        if (null == options) {
            throw new IllegalArgumentException();
        }
        this.head = options.length == 0 ? new JvmOptionsElement("") : new JvmOptionsElement(options[0]);
        JvmOptionsElement current = this.head;
        for (int i = 1; i < options.length; ++i) {
            JvmOptionsElement next = new JvmOptionsElement(options[i]);
            current.setNext(next);
            current = next;
        }
    }

    String[] addJvmOptions(String[] options) throws InvalidJvmOptionException {
        if (null == options) {
            throw new IllegalArgumentException();
        }
        HashSet<String> alreadyExist = new HashSet<String>();
        JvmOptionsElement last = this.last();
        for (int i = 0; i < options.length; ++i) {
            if (!this.head.hasOption(options[i])) {
                JvmOptionsElement x = new JvmOptionsElement(options[i]);
                last.setNext(x);
                last = x;
                continue;
            }
            alreadyExist.add(options[i]);
        }
        return JvmOptions.toStringArray(alreadyExist);
    }

    JvmOptionsElement last() {
        JvmOptionsElement current = this.head;
        while (current.hasNext()) {
            current = current.next();
        }
        return current;
    }

    String[] deleteJvmOptions(String[] options) {
        if (null == options) {
            throw new IllegalArgumentException();
        }
        options = JvmOptions.tokenize(options);
        HashSet<String> donotExist = new HashSet<String>();
        for (int i = 0; i < options.length; ++i) {
            if (this.head.deleteJvmOption(options[i])) continue;
            donotExist.add(options[i]);
        }
        return JvmOptions.toStringArray(donotExist);
    }

    String[] getJvmOptions() {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        JvmOptionsElement current = this.head;
        while (!JvmOptionsElement.isLast(current)) {
            String options = current.getJvmOptions();
            if (options != null && options.length() > 0) {
                s.add(options);
            }
            current = current.next();
        }
        return JvmOptions.toStringArray(s);
    }

    static String[] toStringArray(Collection c) {
        String[] s = new String[c.size()];
        Iterator it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            s[i] = (String)it.next();
            ++i;
        }
        return s;
    }

    private static String[] tokenize(String[] options) {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        for (int i = 0; i < options.length; ++i) {
            QuotedStringTokenizer strTok = new QuotedStringTokenizer(options[i], " \t");
            while (strTok.hasMoreTokens()) {
                s.add(strTok.nextToken());
            }
        }
        return JvmOptions.toStringArray(s);
    }
}

