/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.exception.ServerInstanceException;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.InstanceFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;

public class J2EEModule {
    private static final StringManager localStrings = StringManager.getManager(J2EEModule.class);
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    public static final String LIFECYCLE_MODULE_TYPE = "lifecycle-module";
    private String standaloneModuleName = null;
    private String subModuleName = null;
    private ModuleType moduleType = null;
    private String ddLocation = null;

    public J2EEModule() {
    }

    public J2EEModule(String standaloneModuleName) throws ServerInstanceException {
        if (standaloneModuleName == null || standaloneModuleName.length() < 1) {
            sLogger.log(Level.WARNING, this.getLogMsg("invalid standAloneModuleName"));
            throw new ServerInstanceException(localStrings.getString("admin.mbeans.J2EEModule.invalidStandaloneModuleName"));
        }
        this.standaloneModuleName = standaloneModuleName;
    }

    public J2EEModule(String standaloneModuleName, String subModuleName) throws ServerInstanceException {
        this(standaloneModuleName);
        if (subModuleName == null || subModuleName.length() < 1) {
            sLogger.log(Level.WARNING, this.getLogMsg("invalid sub module for the given stand-alone module"));
            throw new ServerInstanceException(localStrings.getString("admin.mbeans.J2EEModule.invalidSubModuleName"));
        }
        this.subModuleName = subModuleName;
    }

    public ModuleType getModuleType() throws ServerInstanceException {
        if (this.moduleType != null) {
            return this.moduleType;
        }
        this.moduleType = this.subModuleName == null ? this.getModuleType(this.standaloneModuleName) : this.getModuleType(this.standaloneModuleName, this.subModuleName);
        return this.moduleType;
    }

    public String getDeploymentDescriptorsLocation() throws ServerInstanceException {
        if (this.ddLocation != null) {
            this.ddLocation = RelativePathResolver.resolvePath(this.ddLocation);
            return this.ddLocation;
        }
        this.ddLocation = this.subModuleName == null ? this.getDDLocation(this.standaloneModuleName) : this.getDDLocation(this.standaloneModuleName, this.subModuleName);
        if (this.ddLocation != null) {
            this.ddLocation = RelativePathResolver.resolvePath(this.ddLocation);
        }
        return this.ddLocation;
    }

    ModuleType getModuleType(String standaloneModuleName) throws ServerInstanceException {
        sLogger.log(Level.FINE, this.getLogMsg("getModuleType for standaloneModuleName" + standaloneModuleName));
        ModuleType moduleType = null;
        try {
            AppclientModule[] acModules;
            ConnectorModule[] connectorConfigBeans;
            WebModule[] wModules;
            EjbModule[] eModules;
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(AdminService.getAdminService().getAdminContext().getAdminConfigContext(), ServerXPathHelper.XPATH_APPLICATIONS);
            J2eeApplication[] j2eeApps = appsConfigBean.getJ2eeApplication();
            if (j2eeApps != null) {
                for (int i = 0; i < j2eeApps.length; ++i) {
                    if (!j2eeApps[i].getName().equals(standaloneModuleName)) continue;
                    this.ddLocation = j2eeApps[i].getLocation();
                    return ModuleType.EAR;
                }
            }
            if ((eModules = appsConfigBean.getEjbModule()) != null) {
                for (int i = 0; i < eModules.length; ++i) {
                    if (!eModules[i].getName().equals(standaloneModuleName)) continue;
                    this.ddLocation = eModules[i].getLocation();
                    return ModuleType.EJB;
                }
            }
            if ((wModules = appsConfigBean.getWebModule()) != null) {
                for (int i = 0; i < wModules.length; ++i) {
                    if (!wModules[i].getName().equals(standaloneModuleName)) continue;
                    this.ddLocation = wModules[i].getLocation();
                    return ModuleType.WAR;
                }
            }
            if ((connectorConfigBeans = appsConfigBean.getConnectorModule()) != null) {
                for (int i = 0; i < connectorConfigBeans.length; ++i) {
                    if (!connectorConfigBeans[i].getName().equals(standaloneModuleName)) continue;
                    this.ddLocation = connectorConfigBeans[i].getLocation();
                    return ModuleType.RAR;
                }
            }
            if ((acModules = appsConfigBean.getAppclientModule()) != null) {
                for (int i = 0; i < acModules.length; ++i) {
                    if (!acModules[i].getName().equals(standaloneModuleName)) continue;
                    this.ddLocation = acModules[i].getLocation();
                    return ModuleType.CAR;
                }
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return moduleType;
    }

    ModuleType getModuleType(String standaloneModuleName, String subModuleName) throws ServerInstanceException {
        sLogger.log(Level.FINE, this.getLogMsg("getModuleType standaloneModuleName = " + standaloneModuleName + " " + "subModuleName = " + subModuleName));
        ModuleType moduleType = null;
        try {
            AppsManager am = InstanceFactory.createAppsManager(ApplicationServer.getServerContext().getInstanceName());
            Application appD = am.getDescriptor(standaloneModuleName, null, am.getLocation(standaloneModuleName), false);
            BundleDescriptor bd = null;
            Set bds = appD.getBundleDescriptors();
            Iterator it = bds.iterator();
            while (it.hasNext()) {
                bd = (BundleDescriptor)it.next();
                if (!bd.getModuleDescriptor().getArchiveUri().equals(subModuleName) && !bd.getModuleID().equals(subModuleName) && !bd.getName().equals(subModuleName)) continue;
                moduleType = bd.getModuleType();
                this.ddLocation = am.getLocation(standaloneModuleName) + File.separator + FileUtils.makeFriendlyFileName(bd.getModuleDescriptor().getArchiveUri());
                break;
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return moduleType;
    }

    String getLifecycleModuleType() throws ServerInstanceException {
        sLogger.log(Level.FINE, this.getLogMsg("getLifecycleModuleType for standaloneModuleName" + this.standaloneModuleName));
        String moduleType = null;
        try {
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(AdminService.getAdminService().getAdminContext().getAdminConfigContext(), ServerXPathHelper.XPATH_APPLICATIONS);
            LifecycleModule[] lcModules = appsConfigBean.getLifecycleModule();
            if (lcModules != null) {
                for (int i = 0; i < lcModules.length; ++i) {
                    if (!lcModules[i].getName().equals(this.standaloneModuleName)) continue;
                    return LIFECYCLE_MODULE_TYPE;
                }
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return moduleType;
    }

    String getDDLocation(String standaloneModuleName) throws ServerInstanceException {
        sLogger.log(Level.FINE, this.getLogMsg("getDDLocation for standaloneModuleName " + standaloneModuleName));
        return this.ddLocation;
    }

    String getDDLocation(String standaloneModuleName, String subModuleName) throws ServerInstanceException {
        sLogger.log(Level.FINE, this.getLogMsg("getDDLocation for standaloneModuleName " + standaloneModuleName + " " + "subModuleName = " + subModuleName));
        return this.ddLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getStringForDDxml(String fileName) throws ServerInstanceException {
        String string;
        FileReader fr = null;
        try {
            try {
                fr = new FileReader(fileName);
                sLogger.log(Level.FINE, this.getLogMsg("getStringForDDxml " + fileName));
                StringWriter sr = new StringWriter();
                char[] buf = new char[1024];
                int len = 0;
                while (len != -1) {
                    try {
                        len = fr.read(buf, 0, buf.length);
                    }
                    catch (EOFException eof) {
                        break;
                    }
                    if (len == -1) continue;
                    sr.write(buf, 0, len);
                }
                fr.close();
                sr.close();
                string = sr.toString();
                Object var8_10 = null;
                if (fr == null) return string;
            }
            catch (FileNotFoundException fnfe) {
                sLogger.log(Level.WARNING, this.getLogMsg("getStringForDDxml FileNotFoundException " + fileName));
                throw new ServerInstanceException(fnfe.getLocalizedMessage());
            }
            catch (IOException ioe) {
                sLogger.log(Level.WARNING, this.getLogMsg("getStringForDDxml IOException " + fileName));
                throw new ServerInstanceException(ioe.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (fr == null) throw throwable;
            try {
                fr.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe) {
            // empty catch block
            return string;
        }
        fr.close();
        return string;
    }

    private String getLogMsg(String str) {
        return this.getClass().getName() + ":" + str;
    }
}

