/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.dottedname.DottedNameFactory;
import com.sun.enterprise.admin.dottedname.DottedNameGetSet;
import com.sun.enterprise.admin.dottedname.DottedNameGetSetMBean;
import com.sun.enterprise.admin.dottedname.DottedNameRegistry;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfoCache;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfoImpl;
import com.sun.enterprise.admin.mbeans.DottedNameGetSetForConfig;
import com.sun.enterprise.admin.mbeans.DottedNameGetSetForMonitoring;
import com.sun.enterprise.admin.mbeans.DottedNameGetSetMBeanBase;
import java.lang.reflect.Array;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class DottedNameGetSetMBeanImpl
extends StandardMBean
implements DottedNameGetSetMBean {
    final DottedNameGetSetForConfig mConfigImpl;
    final DottedNameGetSetForMonitoring mMonitoringImpl;
    final DottedNameServerInfoCache mServerInfo;
    long mTimeOfLastCall;
    private static final long CLEAR_CACHE_INTERVAL_MILLIS = 600000L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DottedNameGetSetMBeanImpl(MBeanServerConnection conn, DottedNameRegistry registry, DottedNameRegistry monitoringRegistry) throws NotCompliantMBeanException, MalformedObjectNameException {
        super(DottedNameGetSet.class);
        this.mServerInfo = new DottedNameServerInfoCache(this.createServerInfo(conn));
        this.mConfigImpl = new DottedNameGetSetForConfig(conn, registry, this.mServerInfo);
        this.mMonitoringImpl = new DottedNameGetSetForMonitoring(conn, monitoringRegistry, this.mServerInfo);
    }

    protected void pre() {
        this.mServerInfo.refresh();
        long now = System.currentTimeMillis();
        if (now - this.mTimeOfLastCall > 600000L) {
            DottedNameFactory.getInstance().clear();
        }
        this.mTimeOfLastCall = now;
    }

    protected DottedNameServerInfo createServerInfo(MBeanServerConnection conn) {
        return new DottedNameServerInfoImpl(conn);
    }

    protected boolean checkGetResults(Object[] results) {
        boolean good = true;
        for (int i = 0; i < results.length; ++i) {
            Object o = results[i];
            if (o instanceof Attribute || o instanceof Attribute[] || o instanceof Exception) continue;
            good = false;
            break;
        }
        return good;
    }

    protected boolean checkSetResults(Object[] results) {
        boolean good = true;
        for (int i = 0; i < results.length; ++i) {
            Object o = results[i];
            if (o instanceof Attribute || o instanceof Exception) continue;
            good = false;
            break;
        }
        return good;
    }

    private boolean hasIdenticalElementClasses(Object[] a) {
        boolean isUniform = true;
        if (a.length > 0) {
            Class<?> matchType = a[0].getClass();
            for (int i = 1; i < a.length; ++i) {
                if (a[i].getClass() == matchType) continue;
                isUniform = false;
                break;
            }
        }
        return isUniform;
    }

    protected Object[] convertArrayType(Object[] input) {
        Object[] result = input;
        if (this.hasIdenticalElementClasses(input) && input.length != 0) {
            result = (Object[])Array.newInstance(input[0].getClass(), input.length);
            for (int i = 0; i < input.length; ++i) {
                result[i] = input[i];
            }
        }
        return result;
    }

    protected Object[] dottedNameAnyGet(DottedNameGetSetMBeanBase impl, String[] names) {
        this.pre();
        Object[] results = impl.dottedNameGet(names);
        if (!$assertionsDisabled && !this.checkGetResults(results)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && results.length != names.length) {
            throw new AssertionError();
        }
        return this.convertArrayType(results);
    }

    protected Object dottedNameAnyGet(DottedNameGetSetMBeanBase impl, String name) {
        Object[] results = this.dottedNameAnyGet(impl, new String[]{name});
        return results[0];
    }

    public Object[] dottedNameGet(String[] names) {
        return this.dottedNameAnyGet((DottedNameGetSetMBeanBase)this.mConfigImpl, names);
    }

    public Object dottedNameGet(String name) {
        Object result = this.dottedNameAnyGet((DottedNameGetSetMBeanBase)this.mConfigImpl, name);
        return result;
    }

    public Object[] dottedNameSet(String[] nameValuePairs) {
        this.pre();
        Object[] results = this.mConfigImpl.dottedNameSet(nameValuePairs);
        if (!$assertionsDisabled && !this.checkSetResults(results)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && results.length != nameValuePairs.length) {
            throw new AssertionError();
        }
        return this.convertArrayType(results);
    }

    public Object dottedNameSet(String nameValuePair) {
        Object[] results = this.dottedNameSet(new String[]{nameValuePair});
        return results[0];
    }

    public String[] dottedNameList(String[] namePrefixes) {
        this.pre();
        return this.mConfigImpl.dottedNameList(namePrefixes);
    }

    public Object[] dottedNameMonitoringGet(String[] names) {
        return this.dottedNameAnyGet((DottedNameGetSetMBeanBase)this.mMonitoringImpl, names);
    }

    public Object dottedNameMonitoringGet(String name) {
        return this.dottedNameAnyGet((DottedNameGetSetMBeanBase)this.mMonitoringImpl, name);
    }

    public String[] dottedNameMonitoringList(String[] namePrefixes) {
        this.pre();
        return this.mMonitoringImpl.dottedNameList(namePrefixes);
    }

    static {
        $assertionsDisabled = !DottedNameGetSetMBeanImpl.class.desiredAssertionStatus();
    }
}

