/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.dottedname.DottedName;
import com.sun.enterprise.admin.dottedname.DottedNameFactory;
import com.sun.enterprise.admin.dottedname.DottedNameForValue;
import com.sun.enterprise.admin.dottedname.DottedNameLogger;
import com.sun.enterprise.admin.dottedname.DottedNameQuery;
import com.sun.enterprise.admin.dottedname.DottedNameRegistry;
import com.sun.enterprise.admin.dottedname.DottedNameResolver;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.admin.dottedname.DottedNameStrings;
import com.sun.enterprise.admin.dottedname.DottedNameWildcardMatcherImpl;
import com.sun.enterprise.admin.dottedname.valueaccessor.AnyValueAccessor;
import com.sun.enterprise.admin.dottedname.valueaccessor.AttributeValueAccessor;
import com.sun.enterprise.admin.dottedname.valueaccessor.PrefixedValueSupport;
import com.sun.enterprise.admin.dottedname.valueaccessor.PropertyValueAccessor;
import com.sun.enterprise.admin.dottedname.valueaccessor.PropertyValueAccessorBase;
import com.sun.enterprise.admin.dottedname.valueaccessor.SystemPropertyValueAccessor;
import com.sun.enterprise.admin.dottedname.valueaccessor.ValueAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public abstract class DottedNameGetSetMBeanBase {
    final MBeanServerConnection mConn;
    final DottedNameRegistry mRegistry;
    protected final ValueAccessor mValueAccessor;
    final DottedNameServerInfo mServerInfo;
    public static final char ASSIGNMENT_DELIM = '=';
    private static final char BACKSLASH = '\\';
    static final /* synthetic */ boolean $assertionsDisabled;

    public DottedNameGetSetMBeanBase(MBeanServerConnection conn, DottedNameRegistry registry, DottedNameServerInfo serverInfo) {
        this.mConn = conn;
        this.mRegistry = registry;
        this.mValueAccessor = new AnyValueAccessor(this.mConn);
        this.mServerInfo = serverInfo;
    }

    abstract DottedNameQuery createQuery();

    abstract DottedNameResolver getResolver();

    protected MBeanServerConnection getMBS() {
        return this.mConn;
    }

    protected DottedNameRegistry getRegistry() {
        return this.mRegistry;
    }

    protected static ObjectName getTarget(DottedNameForValue dottedName, DottedNameResolver resolver) throws Exception {
        DottedName prefixDN = dottedName.getPrefix();
        ObjectName theObject = resolver.resolveDottedName(prefixDN.toString());
        if (theObject == null) {
            String msg = DottedNameStrings.getString("ObjectInstanceNotFound", dottedName.toString());
            throw new InstanceNotFoundException(msg);
        }
        return theObject;
    }

    protected static void logException(Exception e) {
        DottedNameLogger.logException(e);
    }

    Attribute formAttribute(DottedName prefix, String valueName, Object value) {
        return new Attribute(prefix + "." + valueName, value);
    }

    protected void doGet(String dottedNameString, AttributeList attrsOut) throws Exception {
        String valueName;
        DottedName dn = this.getDottedName(dottedNameString);
        DottedNameForValue dnv = new DottedNameForValue(dn);
        ObjectName target = DottedNameGetSetMBeanBase.getTarget(dnv, this.getResolver());
        Attribute attr = this.mValueAccessor.getValue(target, valueName = dnv.getValueName());
        if (attr != null) {
            attrsOut.add(this.formAttribute(dnv.getPrefix(), valueName, attr.getValue()));
        }
    }

    public void doGet(Set dottedNames, AttributeList attrsOut) throws Exception {
        Iterator iter = dottedNames.iterator();
        while (iter.hasNext()) {
            try {
                this.doGet((String)iter.next(), attrsOut);
            }
            catch (Exception e) {
                if (dottedNames.size() == 1) {
                    throw e;
                }
                if (e instanceof AttributeNotFoundException) continue;
                DottedNameGetSetMBeanBase.logException(e);
            }
        }
    }

    protected static String convertWildcardStringToJavaFormat(String wildcardString) {
        int length = wildcardString.length();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char theChar = wildcardString.charAt(i);
            if (theChar == '.') {
                buf.append("[.]");
                continue;
            }
            if (theChar == '*') {
                buf.append(".*");
                continue;
            }
            if (theChar == '\\') {
                buf.append("\\\\");
                continue;
            }
            buf.append(theChar);
        }
        return buf.toString();
    }

    private boolean startsWithDomain(String dottedNameExpr) {
        return dottedNameExpr.startsWith("domain");
    }

    protected boolean startsWithConfigName(String dottedNameExpr) {
        boolean startsWithConfig = false;
        try {
            Iterator iter = this.mServerInfo.getConfigNames().iterator();
            while (iter.hasNext()) {
                String configName = (String)iter.next();
                if (!dottedNameExpr.startsWith(configName)) continue;
                startsWithConfig = true;
                break;
            }
        }
        catch (DottedNameServerInfo.UnavailableException e) {
            DottedNameGetSetMBeanBase.logException(e);
        }
        return startsWithConfig;
    }

    protected Set getSearchSet(String dottedNameExpr) {
        DottedName dn = this.getDottedName(dottedNameExpr);
        String scope = dn.getScope();
        Set s = null;
        boolean isDomain = scope.startsWith("domain");
        boolean isConfig = this.startsWithConfigName(dottedNameExpr);
        s = isDomain || isConfig ? this.getRegistry().allDottedNameStrings() : this.createQuery().allDottedNameStrings();
        return s;
    }

    protected Set resolveWildcardPrefix(String dottedNamePrefix) throws DottedNameServerInfo.UnavailableException {
        Set resolvedSet = Collections.EMPTY_SET;
        if (DottedName.isWildcardName(dottedNamePrefix)) {
            if (dottedNamePrefix.equals("*")) {
                resolvedSet = this.createQuery().allDottedNameStrings();
            } else {
                Set searchSet = this.getSearchSet(dottedNamePrefix);
                String regex = DottedNameGetSetMBeanBase.convertWildcardStringToJavaFormat(dottedNamePrefix);
                DottedNameWildcardMatcherImpl matcher = new DottedNameWildcardMatcherImpl(searchSet);
                resolvedSet = matcher.matchDottedNames(regex);
            }
        } else {
            resolvedSet = Collections.singleton(dottedNamePrefix);
        }
        return resolvedSet;
    }

    protected Set prefixToValueDottedNamesWild(DottedNameResolver resolver, String prefix, String suffix) {
        HashSet all = new HashSet();
        try {
            ObjectName objectName = resolver.resolveDottedName(prefix);
            if (objectName != null) {
                Set allValueNames = null;
                PropertyValueAccessorBase prop_accessor = null;
                if (suffix.equals("*")) {
                    allValueNames = DottedNameGetSetMBeanBase.getAllPropertyNames(new PropertyValueAccessor(this.getMBS()), objectName);
                    allValueNames.addAll(DottedNameGetSetMBeanBase.getAllPropertyNames(new SystemPropertyValueAccessor(this.getMBS()), objectName));
                    allValueNames.addAll(DottedNameGetSetMBeanBase.getAllValueNames(this.getMBS(), objectName));
                } else {
                    prop_accessor = new PrefixedValueSupport(this.getMBS()).getPrefixedValueAccessor(suffix);
                    allValueNames = prop_accessor != null ? DottedNameGetSetMBeanBase.getAllPropertyNames(prop_accessor, objectName) : DottedNameGetSetMBeanBase.getAllValueNames(this.getMBS(), objectName);
                }
                Set valuesDottedNames = DottedNameGetSetMBeanBase.generateDottedNamesForValues(allValueNames, prefix, suffix);
                all.addAll(valuesDottedNames);
            }
        }
        catch (Exception e) {
            DottedNameGetSetMBeanBase.logException(e);
        }
        return all;
    }

    Set prefixesToValueDottedNames(DottedNameResolver resolver, Set prefixes, String suffix) {
        HashSet<String> all = new HashSet<String>();
        Iterator iter = prefixes.iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            if (DottedName.isWildcardName(suffix)) {
                all.addAll(this.prefixToValueDottedNamesWild(resolver, prefix, suffix));
                continue;
            }
            String dottedName = prefix + "." + suffix;
            all.add(dottedName);
        }
        return all;
    }

    String setToString(Set s) {
        Iterator iter = s.iterator();
        StringBuffer buf = new StringBuffer();
        while (iter.hasNext()) {
            buf.append((String)iter.next() + "\n");
        }
        return buf.toString();
    }

    String normalizeWildcardName(String name) {
        String normalizedName = name;
        if (name.equals("*")) {
            normalizedName = "*.*";
        }
        return normalizedName;
    }

    protected Set resolveInputNames(String[] names) throws DottedNameServerInfo.UnavailableException {
        HashSet<String> all = new HashSet<String>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (DottedName.isWildcardName(name)) {
                name = this.normalizeWildcardName(name);
                DottedName dn = this.getDottedName(name);
                DottedNameForValue dnv = new DottedNameForValue(dn);
                String prefix = dnv.getPrefix().toString();
                String valueName = dnv.getValueName();
                Set resolvedPrefixes = this.resolveWildcardPrefix(prefix);
                Set newDottedNames = this.prefixesToValueDottedNames(this.getResolver(), resolvedPrefixes, valueName);
                all.addAll(newDottedNames);
                continue;
            }
            all.add(name);
        }
        return all;
    }

    protected DottedName getDottedName(String s) {
        return DottedNameFactory.getInstance().get(s);
    }

    protected Attribute[] sortAttributeList(AttributeList attrsIn) {
        Attribute[] attrs = new Attribute[attrsIn.size()];
        attrsIn.toArray(attrs);
        Arrays.sort(attrs, new AttributeComparator());
        return attrs;
    }

    Object[] dottedNameGet(String[] names) {
        Object[] results = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.dottedNameGet(names[i]);
        }
        return results;
    }

    Object dottedNameGet(String name) {
        Object result = null;
        try {
            Set all = this.resolveInputNames(new String[]{name});
            AttributeList attrs = new AttributeList();
            this.doGet(all, attrs);
            if (!DottedName.isWildcardName(name)) {
                if (!$assertionsDisabled && attrs.size() != 1) {
                    throw new AssertionError();
                }
                result = (Attribute)attrs.get(0);
            } else {
                result = this.sortAttributeList(attrs);
            }
        }
        catch (Exception e) {
            DottedNameGetSetMBeanBase.logException((Exception)e);
            result = e;
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return result;
    }

    protected static Set getAllPropertyNames(PropertyValueAccessorBase accessor, ObjectName objectName) throws Exception {
        HashSet<String> allNames = new HashSet<String>();
        String[] propNames = accessor.getAllPropertyNames(objectName, true);
        for (int i = 0; i < propNames.length; ++i) {
            allNames.add(propNames[i]);
        }
        return allNames;
    }

    protected static Set getAllValueNames(MBeanServerConnection conn, ObjectName objectName) throws Exception {
        HashSet allNames = new HashSet();
        allNames.addAll(DottedNameGetSetMBeanBase.getAllPropertyNames(new PropertyValueAccessor(conn), objectName));
        allNames.addAll(DottedNameGetSetMBeanBase.getAllPropertyNames(new SystemPropertyValueAccessor(conn), objectName));
        allNames.addAll(AttributeValueAccessor.getAllAttributeNames(conn, objectName));
        return allNames;
    }

    protected static Set generateDottedNamesForValues(Set valueNames, String prefix, String suffix) {
        Iterator iter = valueNames.iterator();
        HashSet<String> allDottedNameStrings = new HashSet<String>();
        Pattern pattern = Pattern.compile(DottedNameGetSetMBeanBase.convertWildcardStringToJavaFormat(suffix));
        while (iter.hasNext()) {
            String valueName = (String)iter.next();
            if (!pattern.matcher(valueName).matches()) continue;
            allDottedNameStrings.add(prefix + "." + valueName);
        }
        return allDottedNameStrings;
    }

    protected Set getAllDescendants(String namePrefix) {
        Set searchSet = this.getSearchSet(namePrefix);
        String searchPrefix = namePrefix + ".";
        HashSet<String> resultSet = new HashSet<String>();
        Iterator iter = searchSet.iterator();
        while (iter.hasNext()) {
            String candidateString = (String)iter.next();
            if (!candidateString.startsWith(searchPrefix)) continue;
            resultSet.add(candidateString);
        }
        return resultSet;
    }

    protected Set getAllImmediateChildren(String namePrefix) {
        Set allChildren = this.getAllDescendants(namePrefix);
        int numParentParts = this.getDottedName(namePrefix).getParts().size();
        Iterator iter = allChildren.iterator();
        HashSet<String> resultSet = new HashSet<String>();
        while (iter.hasNext()) {
            String descendant = (String)iter.next();
            if (this.getDottedName(descendant).getParts().size() != numParentParts + 1) continue;
            resultSet.add(descendant);
        }
        return resultSet;
    }

    protected Set getAllTopLevelNames() {
        HashSet<String> all = new HashSet<String>();
        Set searchSet = this.createQuery().allDottedNameStrings();
        Iterator iter = searchSet.iterator();
        while (iter.hasNext()) {
            String candidateString = (String)iter.next();
            DottedName dn = this.getDottedName(candidateString);
            if (dn.getParts().size() != 0) continue;
            all.add(candidateString);
        }
        return all;
    }

    protected Set doList(String[] namePrefixes) throws DottedNameServerInfo.UnavailableException {
        HashSet all = new HashSet();
        for (int i = 0; i < namePrefixes.length; ++i) {
            String dottedNamePrefix = namePrefixes[i];
            Set resolved = null;
            resolved = DottedName.isWildcardName(dottedNamePrefix) ? this.resolveWildcardPrefix(dottedNamePrefix) : this.getAllImmediateChildren(dottedNamePrefix);
            all.addAll(resolved);
        }
        return all;
    }

    public String[] dottedNameList(String[] namePrefixes) {
        Set all = Collections.EMPTY_SET;
        try {
            all = namePrefixes.length == 0 ? this.getAllTopLevelNames() : this.doList(namePrefixes);
        }
        catch (Exception e) {
            DottedNameGetSetMBeanBase.logException(e);
        }
        Object[] allArray = new String[all.size()];
        all.toArray(allArray);
        Arrays.sort(allArray);
        return allArray;
    }

    protected DottedNameServerInfo getServerInfo() {
        return this.mServerInfo;
    }

    static {
        $assertionsDisabled = !DottedNameGetSetMBeanBase.class.desiredAssertionStatus();
    }

    private final class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            Attribute attr1 = (Attribute)o1;
            Attribute attr2 = (Attribute)o2;
            return attr1.getName().compareTo(attr2.getName());
        }

        public boolean equals(Object other) {
            return other instanceof AttributeComparator;
        }
    }
}

