/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.dottedname.DottedName;
import com.sun.enterprise.admin.dottedname.DottedNameAliasedQuery;
import com.sun.enterprise.admin.dottedname.DottedNameForValue;
import com.sun.enterprise.admin.dottedname.DottedNameQuery;
import com.sun.enterprise.admin.dottedname.DottedNameRegistry;
import com.sun.enterprise.admin.dottedname.DottedNameResolver;
import com.sun.enterprise.admin.dottedname.DottedNameResolverForAliases;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.admin.dottedname.DottedNameStrings;
import com.sun.enterprise.admin.mbeans.DottedNameGetSetMBeanBase;
import java.io.Serializable;
import java.util.Arrays;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class DottedNameGetSetForConfig
extends DottedNameGetSetMBeanBase {
    final DottedNameResolverForAliases mResolver;
    final DottedNameQuery mQuery;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DottedNameGetSetForConfig(MBeanServerConnection conn, DottedNameRegistry registry, DottedNameServerInfo serverInfo) {
        super(conn, registry, serverInfo);
        this.mResolver = new DottedNameResolverForAliases(registry, serverInfo);
        this.mQuery = new DottedNameAliasedQuery(registry, serverInfo);
    }

    protected DottedNameResolver getResolver() {
        return this.mResolver;
    }

    public Object[] dottedNameSet(String[] nameValuePairs) {
        int numItems = nameValuePairs.length;
        Object[] sortedPairs = new String[numItems];
        for (int i = 0; i < numItems; ++i) {
            sortedPairs[i] = nameValuePairs[i];
        }
        Arrays.sort(sortedPairs);
        Object[] results = new Object[sortedPairs.length];
        for (int i = 0; i < numItems; ++i) {
            results[i] = this.dottedNameSet((String)sortedPairs[i]);
        }
        return results;
    }

    protected Object dottedNameSet(String nameValuePair) {
        Serializable result = null;
        try {
            result = this.doSet(nameValuePair);
        }
        catch (Exception e) {
            DottedNameGetSetForConfig.logException(e);
            result = e;
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return result;
    }

    public Attribute doSet(String pair) throws Exception {
        int delimIndex = pair.indexOf(61);
        boolean delete = delimIndex < 0;
        String dottedNameString = delete ? pair : pair.substring(0, delimIndex);
        String valueString = delete ? null : pair.substring(delimIndex + 1, pair.length());
        Attribute attr = this.doSet(dottedNameString, valueString);
        return attr;
    }

    public Attribute doSet(String dottedNameString, String value) throws Exception {
        Attribute inAttr;
        DottedName dn = this.getDottedName(dottedNameString);
        if (dn.isWildcardName()) {
            String msg = DottedNameStrings.getString("WildcardDisallowedForSet", dottedNameString);
            throw new IllegalArgumentException(msg);
        }
        ObjectName target = null;
        DottedNameForValue dnv = new DottedNameForValue(dn);
        target = this.isDottedNameForServerName(dnv.getPrefix(), dnv.getValueName()) ? this.getRegistry().dottedNameToObjectName(dnv.getPrefix().toString()) : DottedNameGetSetForConfig.getTarget(dnv, this.getResolver());
        Attribute resultAttr = this.mValueAccessor.setValue(target, inAttr = new Attribute(dnv.getValueName(), value));
        if (resultAttr != null && resultAttr.getValue() != null) {
            String fullName = dnv.getPrefix() + "." + inAttr.getName();
            resultAttr = new Attribute(fullName, resultAttr.getValue());
        }
        return resultAttr;
    }

    protected DottedNameQuery createQuery() {
        return this.mQuery;
    }

    boolean isServerName(String name) throws DottedNameServerInfo.UnavailableException {
        boolean isServerName = false;
        isServerName = this.mServerInfo.getServerNames().contains(name);
        return isServerName;
    }

    protected boolean isDottedNameForServerName(DottedName prefix, String valueName) throws DottedNameServerInfo.UnavailableException {
        return valueName.equals("name") && this.isServerName(prefix.getScope()) && prefix.getParts().size() == 0;
    }

    protected Attribute formAttribute(DottedName prefix, String valueName, Object value) {
        Attribute attr = super.formAttribute(prefix, valueName, value);
        try {
            if (this.isDottedNameForServerName(prefix, valueName)) {
                ObjectName objectName = this.getRegistry().dottedNameToObjectName(prefix.getScope());
                Attribute newAttr = this.mValueAccessor.getValue(objectName, valueName);
                if (!$assertionsDisabled && newAttr == null) {
                    throw new AssertionError();
                }
                attr = super.formAttribute(prefix, valueName, newAttr.getValue());
            }
        }
        catch (Exception e) {
            DottedNameGetSetForConfig.logException(e);
        }
        return attr;
    }

    static {
        $assertionsDisabled = !DottedNameGetSetForConfig.class.desiredAssertionStatus();
    }
}

