/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.ConfigMBeanHelper;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.mbeanapi.IConfigsMBean;
import com.sun.enterprise.admin.mbeans.ConfigMBeanUtil;
import com.sun.enterprise.admin.mbeans.HttpListenerVirtualServerAssociationMgr;
import com.sun.enterprise.admin.mbeans.InvalidJvmOptionException;
import com.sun.enterprise.admin.mbeans.JvmOptions;
import com.sun.enterprise.admin.mbeans.MBeanExceptionFormatter;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryEntry;
import com.sun.enterprise.admin.meta.naming.MBeanNamingInfo;
import com.sun.enterprise.admin.target.ConfigTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.jmx.AttributeListUtils;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.RequestPolicy;
import com.sun.enterprise.config.serverbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ConfigsMBean
extends BaseConfigMBean
implements IConfigsMBean {
    public static final String DEFAULT_HTTP_LISTENER_ACCEPTOR_THREADS = "50";
    private static final TargetType[] VALID_CREATE_DELETE_TYPES = new TargetType[]{TargetType.CLUSTER, TargetType.CONFIG, TargetType.UNCLUSTERED_SERVER, TargetType.DAS};
    private static final TargetType[] VALID_LIST_TYPES = new TargetType[]{TargetType.CLUSTER, TargetType.CONFIG, TargetType.SERVER, TargetType.DAS};
    private static final StringManager localStrings = StringManager.getManager(ConfigsMBean.class);
    static final String FILE_REALM_CLASSNAME = "com.sun.enterprise.security.auth.realm.file.FileRealm";
    static final String KEYFILE_PATH_PROPERTY_NAME = "file";
    static final String PROVIDER_TYPE_SERVER = "server";
    static final String PROVIDER_TYPE_CLIENT = "client";
    static /* synthetic */ Class class$javax$management$Attribute;

    public ObjectName createHttpListener(AttributeList attrList, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        if (!ConfigMBeanUtil.attributeDefinedInList(attrList, ServerTags.ACCEPTOR_THREADS)) {
            attrList.add(new Attribute(ServerTags.ACCEPTOR_THREADS, this.getDefaultHTTPListenerAcceptorThreads()));
        }
        ObjectName httpService = this.getHttpServiceMBean(target);
        ObjectName mbean = (ObjectName)this.invoke1(httpService, "createHttpListener", attrList, AttributeList.class.getName());
        this.setProperties(mbean, props);
        try {
            HttpListenerVirtualServerAssociationMgr mgr = new HttpListenerVirtualServerAssociationMgr(this.getConfigContext(), target.getConfigRef());
            mgr.addHttpListenerRef(mbean.getKeyProperty("id"));
        }
        catch (ConfigException ce) {
            throw MBeanExceptionFormatter.toMBeanException(ce, null);
        }
        return mbean;
    }

    public boolean deleteHttpListener(String listenerId, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        try {
            HttpListenerVirtualServerAssociationMgr mgr = new HttpListenerVirtualServerAssociationMgr(this.getConfigContext(), target.getConfigRef());
            mgr.deleteHttpListenerRef(listenerId);
        }
        catch (ConfigException ce) {
            throw MBeanExceptionFormatter.toMBeanException(ce, null);
        }
        this.check1ToN(target);
        ObjectName httpService = this.getHttpServiceMBean(target);
        this.invoke1(httpService, "removeHttpListenerById", listenerId, String.class.getName());
        return true;
    }

    public ObjectName[] listHttpListeners(String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        ObjectName httpService = this.getHttpServiceMBean(target);
        ObjectName[] ret = (ObjectName[])this.invoke0(httpService, "getHttpListener");
        return ret;
    }

    public ObjectName createIiopListener(AttributeList attrList, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName iiopService = this.getIiopServiceMBean(target);
        ObjectName mbean = (ObjectName)this.invoke1(iiopService, "createIiopListener", attrList, AttributeList.class.getName());
        this.setProperties(mbean, props);
        return mbean;
    }

    public boolean deleteIiopListener(String listenerId, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName iiopService = this.getIiopServiceMBean(target);
        this.invoke1(iiopService, "removeIiopListenerById", listenerId, String.class.getName());
        return true;
    }

    public ObjectName[] listIiopListeners(String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        ObjectName iiopService = this.getIiopServiceMBean(target);
        ObjectName[] ret = (ObjectName[])this.invoke0(iiopService, "getIiopListener");
        return ret;
    }

    public ObjectName createSsl(AttributeList al, String id, String type, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName targetON = this.getSslTargetObjectName(target, id, type);
        if ("iiop-service".equals(type)) {
            targetON = this.createSslClientConfig(targetON);
        }
        this.checkElementDoesnotExist(targetON, "getSsl", localStrings.getString("configsMBean.ssl_exists"));
        ObjectName ret = (ObjectName)this.invoke1(targetON, "createSsl", al, AttributeList.class.getName());
        return ret;
    }

    public boolean deleteSsl(String id, String type, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName targetON = this.getSslTargetObjectName(target, id, type);
        String opName = "iiop-service".equals(type) ? "removeSslClientConfig" : "removeSsl";
        this.invoke0(targetON, opName);
        return true;
    }

    public ObjectName createVirtualServer(AttributeList al, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName httpService = this.getHttpServiceMBean(target);
        ObjectName mbean = (ObjectName)this.invoke1(httpService, "createVirtualServer", al, AttributeList.class.getName());
        Properties nProps = this.copyProperties(props);
        this.addMandatoryVirtualServerProperties(al, nProps);
        this.setProperties(mbean, nProps);
        return mbean;
    }

    public boolean deleteVirtualServer(String id, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName httpService = this.getHttpServiceMBean(target);
        this.invoke1(httpService, "removeVirtualServerById", id, String.class.getName());
        return true;
    }

    public ObjectName[] listVirtualServers(String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        ObjectName httpService = this.getHttpServiceMBean(target);
        ObjectName[] ret = (ObjectName[])this.invoke0(httpService, "getVirtualServer");
        return ret;
    }

    public ObjectName createAuthRealm(AttributeList attrs, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName securityService = this.getSecurityServiceMBean(target);
        ObjectName on = (ObjectName)this.invoke1(securityService, "createAuthRealm", attrs, AttributeList.class.getName());
        this.setProperties(on, props);
        this.checkAndCreateAuthRealmKeyFile(on);
        return on;
    }

    private void checkAndCreateAuthRealmKeyFile(ObjectName on) throws MBeanException {
        if (!FILE_REALM_CLASSNAME.equals(this.getAttribute0(on, ServerTags.CLASSNAME))) {
            return;
        }
        String path = (String)this.getPropertyValue0(on, KEYFILE_PATH_PROPERTY_NAME);
        try {
            File file;
            if (path != null && (file = new File(path)) != null && !file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            String msg = localStrings.getString("configsMBean.can_not_create_keyfile", new Object[]{path});
            _sLogger.log(Level.WARNING, msg);
            throw new MBeanException(e, msg);
        }
    }

    public boolean deleteAuthRealm(String name, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName securityService = this.getSecurityServiceMBean(target);
        this.invoke1(securityService, "removeAuthRealmByName", name, String.class.getName());
        return true;
    }

    public ObjectName[] listAuthRealms(String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        ObjectName securityService = this.getSecurityServiceMBean(target);
        ObjectName[] ret = (ObjectName[])this.invoke0(securityService, "getAuthRealm");
        return ret;
    }

    public void addUser(String user, String password, String[] grps, String realmName, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        realmName = realmName != null ? realmName : this.getDefaultAuthRealm(target);
        ObjectName authRealm = this.getAuthRealmMBean(target, realmName);
        this.invokeN(authRealm, "addUser", new Object[]{user, password, grps}, new String[]{String.class.getName(), String.class.getName(), new String[0].getClass().getName()});
    }

    public void updateUser(String user, String password, String[] grps, String realmName, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        realmName = realmName != null ? realmName : this.getDefaultAuthRealm(target);
        ObjectName authRealm = this.getAuthRealmMBean(target, realmName);
        if (grps == null) {
            grps = this.getGroupNames(user, realmName, targetName);
        }
        this.invokeN(authRealm, "updateUser", new Object[]{user, password, grps}, new String[]{String.class.getName(), String.class.getName(), new String[0].getClass().getName()});
    }

    public void removeUser(String user, String realmName, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        realmName = realmName != null ? realmName : this.getDefaultAuthRealm(target);
        ObjectName authRealm = this.getAuthRealmMBean(target, realmName);
        this.invoke1(authRealm, "removeUser", user, String.class.getName());
    }

    public String[] getUserNames(String realmName, String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        realmName = realmName != null ? realmName : this.getDefaultAuthRealm(target);
        ObjectName authRealm = this.getAuthRealmMBean(target, realmName);
        return (String[])this.invoke0(authRealm, "getUserNames");
    }

    public String[] getGroupNames(String user, String realmName, String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        realmName = realmName != null ? realmName : this.getDefaultAuthRealm(target);
        ObjectName authRealm = this.getAuthRealmMBean(target, realmName);
        return (String[])this.invoke1(authRealm, "getUserGroupNames", user, String.class.getName());
    }

    public ObjectName createProfiler(AttributeList al, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName javaConfig = this.getJavaConfigMBean(target);
        this.checkElementDoesnotExist(javaConfig, "getProfiler", localStrings.getString("configsMBean.profiler_exists"));
        ObjectName on = (ObjectName)this.invoke1(javaConfig, "createProfiler", al, AttributeList.class.getName());
        this.setProperties(on, props);
        return on;
    }

    public boolean deleteProfiler(String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName javaConfig = this.getJavaConfigMBean(target);
        this.invoke0(javaConfig, "removeProfiler");
        return true;
    }

    public String[] getJvmOptions(boolean isProfiler, String targetName) throws MBeanException {
        return this.getJvmOptions(isProfiler, this.getListTarget(targetName));
    }

    public String[] createJvmOptions(String[] options, boolean isProfiler, String targetName) throws MBeanException, InvalidJvmOptionException {
        if (null == options) {
            throw new IllegalArgumentException(localStrings.getString("configsMBean.null_jvm_options"));
        }
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        String[] oldOptions = this.getJvmOptions(isProfiler, target);
        JvmOptions jvmOptions = new JvmOptions(oldOptions);
        String[] invalid = jvmOptions.addJvmOptions(options);
        ObjectName targetON = this.getJvmOptionsTargetObjectName(target, isProfiler);
        this.setAttribute0(targetON, "jvm_options", jvmOptions.getJvmOptions());
        this.postInvoke("createJvmOptions", null);
        return invalid;
    }

    public String[] deleteJvmOptions(String[] options, boolean isProfiler, String targetName) throws MBeanException, InvalidJvmOptionException {
        if (null == options) {
            throw new IllegalArgumentException(localStrings.getString("configsMBean.null_jvm_options"));
        }
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        String[] oldOptions = this.getJvmOptions(isProfiler, target);
        JvmOptions jvmOptions = new JvmOptions(oldOptions);
        String[] invalid = jvmOptions.deleteJvmOptions(options);
        ObjectName targetON = this.getJvmOptionsTargetObjectName(target, isProfiler);
        this.setAttribute0(targetON, "jvm_options", jvmOptions.getJvmOptions());
        this.postInvoke("deleteJvmOptions", null);
        return invalid;
    }

    public ObjectName createAuditModule(AttributeList attrs, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName securityService = this.getSecurityServiceMBean(target);
        ObjectName on = (ObjectName)this.invoke1(securityService, "createAuditModule", attrs, AttributeList.class.getName());
        this.setProperties(on, props);
        return on;
    }

    public ObjectName[] listAuditModules(String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        ObjectName securityService = this.getSecurityServiceMBean(target);
        return (ObjectName[])this.invoke0(securityService, "getAuditModule");
    }

    public boolean deleteAuditModule(String name, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName securityService = this.getSecurityServiceMBean(target);
        this.invoke1(securityService, "removeAuditModuleByName", name, String.class.getName());
        return true;
    }

    public ObjectName createJmsHost(AttributeList attrs, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName jmsService = this.getJmsServiceMBean(target, true);
        ObjectName jmsHost = (ObjectName)this.invoke1(jmsService, "createJmsHost", attrs, AttributeList.class.getName());
        this.setProperties(jmsHost, props);
        return jmsHost;
    }

    public boolean deleteJmsHost(String name, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName jmsService = this.getJmsServiceMBean(target, false);
        this.assertIt(jmsService != null, localStrings.getString("configsMBean.no_jms_service"));
        if (name.equals(this.getAttribute0(jmsService, "default_jms_host"))) {
            this.setAttribute0(jmsService, "default_jms_host", null);
            _sLogger.log(Level.FINE, "default-jms-host attribute of jms-service for target " + targetName + " has been set to null");
        }
        this.invoke1(jmsService, "removeJmsHostByName", name, String.class.getName());
        return true;
    }

    public ObjectName[] listJmsHosts(String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        ObjectName jmsService = this.getJmsServiceMBean(target, false);
        this.assertIt(jmsService != null, localStrings.getString("configsMBean.no_jms_service"));
        return (ObjectName[])this.invoke0(jmsService, "getJmsHost");
    }

    private ElementProperty[] convertPropertiesToElementProperties(Properties props) {
        ArrayList<ElementProperty> list = new ArrayList<ElementProperty>();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ElementProperty property = new ElementProperty();
            property.setName(key);
            property.setValue((String)props.get(key));
            list.add(property);
        }
        return list.toArray(new ElementProperty[list.size()]);
    }

    public ObjectName createMessageSecurityProvider(String messageLayer, String providerId, String providerType, String providerClassName, String requestAuthSource, String requestAuthRecipient, String responseAuthSource, String responseAuthRecipient, boolean isDefaultProvider, Properties props, String targetName) throws Exception {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ConfigTarget configTarget = target.getConfigTarget();
        boolean bMessageConfigJustCreated = false;
        Config config = ConfigAPIHelper.getConfigByName(this.getConfigContext(), configTarget.getName());
        SecurityService securityService = config.getSecurityService();
        MessageSecurityConfig messageSecurity = securityService.getMessageSecurityConfigByAuthLayer(messageLayer);
        if (messageSecurity == null) {
            messageSecurity = new MessageSecurityConfig();
            messageSecurity.setAuthLayer(messageLayer);
            bMessageConfigJustCreated = true;
        }
        ProviderConfig provider = new ProviderConfig();
        provider.setClassName(providerClassName);
        provider.setProviderId(providerId);
        provider.setProviderType(providerType);
        if (null != props) {
            provider.setElementProperty(this.convertPropertiesToElementProperties(props));
        }
        if (requestAuthSource != null || requestAuthRecipient != null) {
            RequestPolicy requestPolicy = new RequestPolicy();
            if (requestAuthSource != null) {
                requestPolicy.setAuthSource(requestAuthSource);
            }
            if (requestAuthRecipient != null) {
                requestPolicy.setAuthRecipient(requestAuthRecipient);
            }
            provider.setRequestPolicy(requestPolicy);
        }
        if (responseAuthSource != null || responseAuthRecipient != null) {
            ResponsePolicy responsePolicy = new ResponsePolicy();
            if (responseAuthSource != null) {
                responsePolicy.setAuthSource(responseAuthSource);
            }
            if (responseAuthRecipient != null) {
                responsePolicy.setAuthRecipient(responseAuthRecipient);
            }
            provider.setResponsePolicy(responsePolicy);
        }
        messageSecurity.addProviderConfig(provider);
        if (isDefaultProvider) {
            if (PROVIDER_TYPE_SERVER.equals(providerType)) {
                messageSecurity.setDefaultProvider(providerId);
            } else if (PROVIDER_TYPE_CLIENT.equals(providerType)) {
                messageSecurity.setDefaultClientProvider(providerId);
            } else {
                messageSecurity.setDefaultProvider(providerId);
                messageSecurity.setDefaultClientProvider(providerId);
            }
        }
        if (bMessageConfigJustCreated) {
            securityService.addMessageSecurityConfig(messageSecurity);
        }
        return this.getMBeanRegistry().getMbeanObjectName("provider-config", new String[]{this.getDomainName(), configTarget.getName(), messageLayer, providerId});
    }

    public boolean deleteMessageSecurityProvider(String messageLayer, String providerId, String targetName) throws Exception {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        Config config = ConfigAPIHelper.getConfigByName(this.getConfigContext(), target.getConfigTarget().getName());
        SecurityService securityService = config.getSecurityService();
        MessageSecurityConfig messageSecurity = securityService.getMessageSecurityConfigByAuthLayer(messageLayer);
        if (messageSecurity == null) {
            String msg = localStrings.getString("admin.mbeans.configs.message_security_config_not_found", new Object[]{messageLayer, targetName});
            throw new MBeanConfigException(msg);
        }
        ProviderConfig[] providers = messageSecurity.getProviderConfig();
        if (providers.length == 1 && providerId.equals(providers[0].getProviderId())) {
            securityService.removeMessageSecurityConfig(messageSecurity);
            return true;
        }
        ProviderConfig provider = messageSecurity.getProviderConfigByProviderId(providerId);
        if (provider == null) {
            String msg = localStrings.getString("admin.mbeans.configs.security_provider_not_found", new Object[]{providerId, messageLayer, targetName});
            throw new MBeanConfigException(msg);
        }
        messageSecurity.removeProviderConfig(provider);
        return true;
    }

    public ObjectName[] listMessageSecurityProviders(String messageLayer, String targetName) throws Exception {
        Target target = this.getListTarget(targetName);
        Config config = ConfigAPIHelper.getConfigByName(this.getConfigContext(), target.getConfigTarget().getName());
        SecurityService securityService = config.getSecurityService();
        if (securityService == null) {
            return null;
        }
        if (messageLayer != null) {
            MessageSecurityConfig messageSecurity = securityService.getMessageSecurityConfigByAuthLayer(messageLayer);
            if (messageSecurity == null) {
                String msg = localStrings.getString("admin.mbeans.configs.message_security_config_not_found", new Object[]{messageLayer, targetName});
                throw new MBeanConfigException(msg);
            }
            return this.getMessageSecurityProviders(messageSecurity);
        }
        MessageSecurityConfig[] messageSecurities = securityService.getMessageSecurityConfig();
        ArrayList<ObjectName> arr = new ArrayList<ObjectName>();
        if (messageSecurities != null) {
            for (int i = 0; i < messageSecurities.length; ++i) {
                ObjectName[] names = this.getMessageSecurityProviders(messageSecurities[i]);
                if (names == null) continue;
                for (int j = 0; j < names.length; ++j) {
                    arr.add(names[j]);
                }
            }
        }
        return arr.toArray(new ObjectName[arr.size()]);
    }

    private ObjectName[] getMessageSecurityProviders(MessageSecurityConfig messageSecurity) throws Exception {
        ConfigBean[] providers = messageSecurity.getProviderConfig();
        return ConfigMBeanHelper.getConfigBeansObjectNames(this.getMBeanRegistry(), this.getDomainName(), providers);
    }

    public ObjectName createJaccProvider(AttributeList attrs, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName securityService = this.getSecurityServiceMBean(target);
        ObjectName jaccProvider = (ObjectName)this.invoke1(securityService, "createJaccProvider", attrs, AttributeList.class.getName());
        this.setProperties(jaccProvider, props);
        return jaccProvider;
    }

    public boolean deleteJaccProvider(String name, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName securityService = this.getSecurityServiceMBean(target);
        this.invoke1(securityService, "removeJaccProviderByName", name, String.class.getName());
        return true;
    }

    public ObjectName[] listJaccProviders(String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        ObjectName securityService = this.getSecurityServiceMBean(target);
        return (ObjectName[])this.invoke0(securityService, "getJaccProvider");
    }

    public ObjectName createThreadPool(AttributeList attrs, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName threadPools = this.getThreadPoolsMBean(target);
        ObjectName threadPool = (ObjectName)this.invoke1(threadPools, "createThreadPool", attrs, AttributeList.class.getName());
        this.setProperties(threadPool, props);
        return threadPool;
    }

    public boolean deleteThreadPool(String threadPoolId, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName threadPools = this.getThreadPoolsMBean(target);
        this.invoke1(threadPools, "removeThreadPoolByThreadPoolId", threadPoolId, String.class.getName());
        return true;
    }

    public ObjectName[] listThreadPools(String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        ObjectName threadPools = this.getThreadPoolsMBean(target);
        return (ObjectName[])this.invoke0(threadPools, "getThreadPool");
    }

    public ObjectName createEjbTimerService(AttributeList al, Properties props, String targetName) throws MBeanException {
        ObjectName ejbContainer = this.getEjbContainer(targetName);
        ObjectName on = (ObjectName)this.invoke1(ejbContainer, "createEjbTimerService", al, AttributeList.class.getName());
        this.setProperties(on, props);
        return on;
    }

    public boolean deleteEjbTimerService(String targetName) throws MBeanException {
        ObjectName ejbContainer = this.getEjbContainer(targetName);
        this.invoke0(ejbContainer, "removeEjbTimerService");
        return true;
    }

    public ObjectName createSessionProperties(AttributeList al, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName sessionConfig = this.getSessionConfigMBean(target, true);
        ObjectName on = (ObjectName)this.invoke1(sessionConfig, "createSessionProperties", al, AttributeList.class.getName());
        this.setProperties(on, props);
        return on;
    }

    public boolean deleteSessionProperties(String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName sessionConfig = this.getSessionConfigMBean(target, false);
        this.invoke0(sessionConfig, "removeSessionProperties");
        return true;
    }

    public ObjectName createManagerProperties(AttributeList al, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName sessionManager = this.getSessionManagerMBean(target, true);
        ObjectName on = (ObjectName)this.invoke1(sessionManager, "createManagerProperties", al, AttributeList.class.getName());
        this.setProperties(on, props);
        return on;
    }

    public boolean deleteManagerProperties(String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName sessionManager = this.getSessionManagerMBean(target, false);
        this.invoke0(sessionManager, "removeManagerProperties");
        return true;
    }

    public ObjectName createStoreProperties(AttributeList al, Properties props, String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName sessionManager = this.getSessionManagerMBean(target, true);
        ObjectName on = (ObjectName)this.invoke1(sessionManager, "createStoreProperties", al, AttributeList.class.getName());
        this.setProperties(on, props);
        return on;
    }

    public boolean deleteStoreProperties(String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName sessionManager = this.getSessionManagerMBean(target, false);
        this.invoke0(sessionManager, "removeStoreProperties");
        return true;
    }

    public boolean deleteSessionConfig(String targetName) throws MBeanException {
        Target target = this.getTarget(targetName);
        this.check1ToN(target);
        ObjectName webContainer = this.getChild("web-container", null, target);
        this.invoke0(webContainer, "removeSessionConfig");
        return true;
    }

    public ObjectName getHttpService(String targetName) throws MBeanException {
        return this.getChild("http-service", null, targetName);
    }

    public ObjectName getIiopService(String targetName) throws MBeanException {
        return this.getChild("iiop-service", null, targetName);
    }

    public ObjectName getEjbContainer(String targetName) throws MBeanException {
        return this.getChild("ejb-container", null, targetName);
    }

    public ObjectName getWebContainer(String targetName) throws MBeanException {
        return this.getChild("web-container", null, targetName);
    }

    public ObjectName getMdbContainer(String targetName) throws MBeanException {
        return this.getChild("mdb-container", null, targetName);
    }

    public ObjectName getJmsService(String targetName) throws MBeanException {
        return this.getChild("jms-service", null, targetName);
    }

    public ObjectName getLogService(String targetName) throws MBeanException {
        return this.getChild("log-service", null, targetName);
    }

    public ObjectName getSecurityService(String targetName) throws MBeanException {
        return this.getChild("security-service", null, targetName);
    }

    public ObjectName getTransactionService(String targetName) throws MBeanException {
        return this.getChild("transaction-service", null, targetName);
    }

    public ObjectName getMonitoringService(String targetName) throws MBeanException {
        return this.getChild("monitoring-service", null, targetName);
    }

    public ObjectName getJavaConfig(String targetName) throws MBeanException {
        return this.getChild("java-config", null, targetName);
    }

    public ObjectName getHttpListener(String id, String targetName) throws MBeanException {
        return this.getChild("http-listener", new String[]{id}, targetName);
    }

    public ObjectName getVirtualServer(String id, String targetName) throws MBeanException {
        return this.getChild("virtual-server", new String[]{id}, targetName);
    }

    public ObjectName getIiopListener(String id, String targetName) throws MBeanException {
        return this.getChild("iiop-listener", new String[]{id}, targetName);
    }

    public ObjectName getOrb(String targetName) throws MBeanException {
        return this.getChild("orb", null, targetName);
    }

    public ObjectName getJmsHost(String name, String targetName) throws MBeanException {
        return this.getChild("jms-host", new String[]{name}, targetName);
    }

    public ObjectName getAuthRealm(String name, String targetName) throws MBeanException {
        return this.getChild("auth-realm", new String[]{name}, targetName);
    }

    public ObjectName getAuditModule(String name, String targetName) throws MBeanException {
        return this.getChild("audit-module", new String[]{name}, targetName);
    }

    public ObjectName getJaccProvider(String name, String targetName) throws MBeanException {
        return this.getChild("jacc-provider", new String[]{name}, targetName);
    }

    public ObjectName getModuleLogLevels(String targetName) throws MBeanException {
        return this.getChild("module-log-levels", null, targetName);
    }

    public ObjectName getModuleMonitoringLevels(String targetName) throws MBeanException {
        return this.getChild("module-monitoring-levels", null, targetName);
    }

    public ObjectName getThreadPool(String threadPoolId, String targetName) throws MBeanException {
        return this.getChild("thread-pool", new String[]{threadPoolId}, targetName);
    }

    public ObjectName getEjbTimerService(String targetName) throws MBeanException {
        return this.getChild("ejb-timer-service", null, targetName);
    }

    public ObjectName getProfiler(String targetName) throws MBeanException {
        return this.getChild("profiler", null, targetName);
    }

    public ObjectName getSsl(String type, String id, String targetName) throws MBeanException {
        Target target = this.getListTarget(targetName);
        ObjectName sslTarget = this.getSslTargetObjectName(target, id, type);
        if ("iiop-service".equals(type)) {
            sslTarget = (ObjectName)this.invoke0(sslTarget, "getSslClientConfig");
        }
        return (ObjectName)this.invoke0(sslTarget, "getSsl");
    }

    public ObjectName getSessionProperties(String targetName) throws MBeanException {
        return this.getChild("session-properties", null, targetName);
    }

    public ObjectName getManagerProperties(String targetName) throws MBeanException {
        return this.getChild("manager-properties", null, targetName);
    }

    public ObjectName getStoreProperties(String targetName) throws MBeanException {
        return this.getChild("store-properties", null, targetName);
    }

    public ObjectName getChild(String type, String[] location, String targetName) throws MBeanException {
        return this.getChild(type, location, this.getListTarget(targetName));
    }

    protected ObjectName getChild(String type, String[] location, Target target) throws MBeanException {
        MBeanRegistryEntry entry = this.getMBeanRegistryEntry(type);
        MBeanNamingInfo namingInfo = this.getMBeanNamingInfo(entry, type, this.getObjectNameTokens(target, location));
        this.doPersistenceCheck(namingInfo, this.getConfigContext());
        ObjectName on = this.getObjectName(namingInfo);
        this.postInvoke("getChild", on);
        return on;
    }

    protected MBeanRegistry getMBeanRegistry() throws MBeanException {
        this.assertIt(this.m_registry != null, localStrings.getString("configsMBean.null_registry"));
        return this.m_registry;
    }

    Target getListTarget(String targetName) throws MBeanException {
        try {
            return TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, targetName, this.getConfigContext());
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
    }

    Target getTarget(String targetName) throws MBeanException {
        try {
            Target target = TargetBuilder.INSTANCE.createTarget(VALID_CREATE_DELETE_TYPES, targetName, this.getConfigContext());
            if (target.getType() == TargetType.SERVER || target.getType() == TargetType.DAS) {
                String configName = ServerHelper.getConfigForServer(this.getConfigContext(), target.getName()).getName();
                if (!ConfigAPIHelper.isConfigurationReferencedByServerOnly(this.getConfigContext(), configName, target.getName())) {
                    throw new ConfigException(localStrings.getString("configurationHasMultipleRefs", target.getName(), configName, ConfigAPIHelper.getConfigurationReferenceesAsString(this.getConfigContext(), configName)));
                }
            } else if (target.getType() == TargetType.CLUSTER) {
                String configName = ClusterHelper.getConfigForCluster(this.getConfigContext(), target.getName()).getName();
                if (!ConfigAPIHelper.isConfigurationReferencedByClusterOnly(this.getConfigContext(), configName, target.getName())) {
                    throw new ConfigException(localStrings.getString("configurationHasMultipleRefs", target.getName(), configName, ConfigAPIHelper.getConfigurationReferenceesAsString(this.getConfigContext(), configName)));
                }
            }
            return target;
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
    }

    void check1ToN(Target target) throws MBeanException {
    }

    protected ObjectName getConfigMBean(Target target) throws MBeanException {
        ObjectName configMBean = null;
        try {
            ConfigTarget ct = target.getConfigTarget();
            configMBean = new ObjectName(ct.getTargetObjectName(new String[]{this.getDomainName()}));
            this.postInvoke("getConfigMBean", configMBean);
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
        return configMBean;
    }

    protected ObjectName getHttpServiceMBean(Target target) throws MBeanException {
        ObjectName configMBean = this.getConfigMBean(target);
        ObjectName ret = (ObjectName)this.invoke0(configMBean, "getHttpService");
        return ret;
    }

    protected ObjectName getIiopServiceMBean(Target target) throws MBeanException {
        ObjectName configMBean = this.getConfigMBean(target);
        ObjectName ret = (ObjectName)this.invoke0(configMBean, "getIiopService");
        return ret;
    }

    protected ObjectName getSecurityServiceMBean(Target target) throws MBeanException {
        ObjectName configMBean = this.getConfigMBean(target);
        ObjectName ret = (ObjectName)this.invoke0(configMBean, "getSecurityService");
        return ret;
    }

    protected ObjectName getJavaConfigMBean(Target target) throws MBeanException {
        ObjectName configMBean = this.getConfigMBean(target);
        ObjectName ret = (ObjectName)this.invoke0(configMBean, "getJavaConfig");
        this.assertIt(ret != null, localStrings.getString("configsMBean.no_java_config"));
        return ret;
    }

    protected ObjectName getHttpListenerMBean(Target target, String id) throws MBeanException {
        return (ObjectName)this.invoke1(this.getHttpServiceMBean(target), "getHttpListenerById", id, String.class.getName());
    }

    protected ObjectName getIiopListenerMBean(Target target, String id) throws MBeanException {
        return (ObjectName)this.invoke1(this.getIiopServiceMBean(target), "getIiopListenerById", id, String.class.getName());
    }

    protected ObjectName getSslTargetObjectName(Target target, String id, String type) throws MBeanException {
        ObjectName on = null;
        if ("http-listener".equals(type)) {
            on = this.getHttpListenerMBean(target, id);
        } else if ("iiop-listener".equals(type)) {
            on = this.getIiopListenerMBean(target, id);
        } else if ("iiop-service".equals(type)) {
            on = this.getIiopServiceMBean(target);
        } else {
            throw MBeanExceptionFormatter.toMBeanException(null, localStrings.getString("configsMBean.invalid_ssl_target_type", type));
        }
        this.assertIt(on != null, localStrings.getString("configsMBean.target_for_ssl_not_found"));
        return on;
    }

    protected ObjectName getAuthRealmMBean(Target target, String name) throws MBeanException {
        ObjectName securityService = this.getSecurityServiceMBean(target);
        ObjectName authRealm = (ObjectName)this.invoke1(securityService, "getAuthRealmByName", name, String.class.getName());
        this.assertIt(authRealm != null, localStrings.getString("configsMBean.auth_realm_not_found", name));
        return authRealm;
    }

    protected ObjectName getJmsServiceMBean(Target target, boolean create) throws MBeanException {
        ObjectName configMBean = this.getConfigMBean(target);
        ObjectName on = null;
        try {
            on = (ObjectName)this.invoke0(configMBean, "getJmsService");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == on && create) {
            on = (ObjectName)this.invoke1(configMBean, "createJmsService", null, AttributeList.class.getName());
        }
        return on;
    }

    protected ObjectName getThreadPoolsMBean(Target target) throws MBeanException {
        ObjectName configMBean = this.getConfigMBean(target);
        ObjectName ret = (ObjectName)this.invoke0(configMBean, "getThreadPools");
        return ret;
    }

    protected ObjectName getSessionConfigMBean(Target target, boolean create) throws MBeanException {
        ObjectName sessionConfig = null;
        try {
            sessionConfig = this.getChild("session-config", null, target);
        }
        catch (MBeanException mbe) {
            if (create) {
                ObjectName webContainer = this.getChild("web-container", null, target);
                sessionConfig = (ObjectName)this.invoke1(webContainer, "createSessionConfig", null, AttributeList.class.getName());
            }
            throw mbe;
        }
        return sessionConfig;
    }

    protected ObjectName getSessionManagerMBean(Target target, boolean create) throws MBeanException {
        ObjectName sessionConfig = this.getSessionConfigMBean(target, create);
        ObjectName sessionManager = null;
        try {
            sessionManager = this.getChild("session-manager", null, target);
        }
        catch (MBeanException mbe) {
            if (create) {
                sessionManager = (ObjectName)this.invoke1(sessionConfig, "createSessionManager", null, AttributeList.class.getName());
            }
            throw mbe;
        }
        return sessionManager;
    }

    protected MBeanServer getMBeanServer() throws MBeanException {
        return MBeanServerFactory.getMBeanServer();
    }

    protected void preInvoke(String opName, Object[] params, String[] signature) throws MBeanException {
    }

    protected void postInvoke(String opName, Object ret) throws MBeanException {
    }

    protected String getDefaultAuthRealm(Target target) throws MBeanException {
        ObjectName on = this.getSecurityServiceMBean(target);
        return (String)this.getAttribute0(on, "default_realm");
    }

    protected String[] getObjectNameTokens(Target target, String[] location) throws MBeanException {
        if (null == location) {
            location = new String[]{};
        }
        String[] onTokens = new String[location.length + 2];
        onTokens[0] = this.getDomainName();
        onTokens[1] = this.getConfigRef(target);
        for (int i = 0; i < location.length; ++i) {
            onTokens[i + 2] = location[i];
        }
        return onTokens;
    }

    protected String getConfigRef(Target target) throws MBeanException {
        String configRef = null;
        try {
            configRef = target.getConfigRef();
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
        return configRef;
    }

    protected String[] getJvmOptions(boolean isProfiler, Target target) throws MBeanException {
        ObjectName targetON = this.getJvmOptionsTargetObjectName(target, isProfiler);
        String[] jvmOptions = (String[])this.getAttribute0(targetON, "jvm_options");
        if (null == jvmOptions) {
            jvmOptions = new String[]{};
        }
        return jvmOptions;
    }

    private ObjectName createSslClientConfig(ObjectName iiopService) throws MBeanException {
        ObjectName ret = (ObjectName)this.invoke1(iiopService, "createSslClientConfig", null, AttributeList.class.getName());
        return ret;
    }

    private Object invoke0(ObjectName on, String opName) throws MBeanException {
        return this.invokeN(on, opName, null, null);
    }

    private Object invoke1(ObjectName on, String opName, Object o, String cls) throws MBeanException {
        return this.invokeN(on, opName, new Object[]{o}, new String[]{cls});
    }

    private Object invokeN(ObjectName on, String opName, Object[] params, String[] signature) throws MBeanException {
        Object ret = null;
        try {
            ret = this.getMBeanServer().invoke(on, opName, params, signature);
            this.postInvoke(opName, ret);
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
        return ret;
    }

    private Object getPropertyValue0(ObjectName on, String propName) throws MBeanException {
        Object value = null;
        try {
            value = this.invoke1(on, "getPropertyValue", propName, "java.lang.String");
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
        return value;
    }

    private Object getAttribute0(ObjectName on, String attrName) throws MBeanException {
        Object value = null;
        try {
            value = this.getMBeanServer().getAttribute(on, attrName);
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
        return value;
    }

    private void setAttribute0(ObjectName on, String attrName, Object value) throws MBeanException {
        try {
            Attribute attr = new Attribute(attrName, value);
            this.getMBeanServer().setAttribute(on, attr);
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
    }

    private ObjectName getJvmOptionsTargetObjectName(Target target, boolean isProfiler) throws MBeanException {
        ObjectName on = this.getJavaConfigMBean(target);
        if (isProfiler) {
            on = (ObjectName)this.invoke0(on, "getProfiler");
        }
        this.assertIt(on != null, localStrings.getString("configsMBean.target_for_jvm_options_not_found"));
        return on;
    }

    private void setProperties(ObjectName on, Properties props) throws MBeanException {
        if (null != props) {
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Attribute property = new Attribute(key, props.get(key));
                this.invoke1(on, "setProperty", property, (class$javax$management$Attribute == null ? ConfigsMBean.class$("javax.management.Attribute") : class$javax$management$Attribute).getName());
            }
        }
    }

    private void assertIt(boolean b, Object msg) throws MBeanException {
        if (!b) {
            throw MBeanExceptionFormatter.toMBeanException(null, msg.toString());
        }
    }

    private MBeanRegistryEntry getMBeanRegistryEntry(String type) throws MBeanException {
        MBeanRegistryEntry entry = null;
        try {
            entry = this.getMBeanRegistry().findMBeanRegistryEntryByType(type);
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
        this.assertIt(entry != null, localStrings.getString("configsMBean.no_registry_entry", type));
        return entry;
    }

    private MBeanNamingInfo getMBeanNamingInfo(MBeanRegistryEntry entry, String type, String[] loc) throws MBeanException {
        MBeanNamingInfo namingInfo = null;
        try {
            namingInfo = new MBeanNamingInfo(entry.getNamingDescriptor(), type, loc);
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
        return namingInfo;
    }

    private void doPersistenceCheck(MBeanNamingInfo info, ConfigContext ctx) throws MBeanException {
        ConfigBean cb = null;
        try {
            String xpath = info.getXPath();
            cb = ConfigBeansFactory.getConfigBeanByXPath(ctx, xpath);
            if (null == cb) {
                throw new InstanceNotFoundException(localStrings.getString("configsMBean.mbean_not_found", info.getObjectName()));
            }
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
    }

    private ObjectName getObjectName(MBeanNamingInfo info) throws MBeanException {
        ObjectName on = null;
        try {
            on = info.getObjectName();
        }
        catch (Exception e) {
            throw MBeanExceptionFormatter.toMBeanException(e, null);
        }
        return on;
    }

    private void checkElementDoesnotExist(ObjectName targetON, String getter, Object msg) throws MBeanException {
        ObjectName on = null;
        try {
            on = (ObjectName)this.invoke0(targetON, getter);
        }
        catch (MBeanException mbe) {
            // empty catch block
        }
        if (on != null) {
            throw MBeanExceptionFormatter.toMBeanException(null, msg.toString());
        }
    }

    private void addMandatoryVirtualServerProperties(AttributeList al, Properties p) {
        this.setProperty(p, false, "accesslog", SystemPropertyConstants.getAccessLogDefaultValue());
        String ca = AttributeListUtils.toJmx12Attribute(ServerTags.DEFAULT_WEB_MODULE);
        if (!AttributeListUtils.containsNamedAttribute(al, ca)) {
            this.setProperty(p, false, "docroot", SystemPropertyConstants.getDocRootDefaultValue());
        } else {
            Attribute defaultWb = (Attribute)AttributeListUtils.asNameMap(al).get(ca);
            String val = (String)defaultWb.getValue();
            if (val == null || "".equals(val)) {
                this.setProperty(p, false, "docroot", SystemPropertyConstants.getDocRootDefaultValue());
            }
        }
    }

    private void setProperty(Properties table, boolean force, String name, String value) {
        if (force) {
            table.setProperty(name, value);
        } else if (!table.containsKey(name)) {
            table.setProperty(name, value);
        }
    }

    private Properties copyProperties(Properties p) {
        Properties nn = new Properties();
        if (p != null) {
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = p.getProperty(key);
                nn.setProperty(key, value);
            }
        }
        return nn;
    }

    protected String getDefaultHTTPListenerAcceptorThreads() {
        return DEFAULT_HTTP_LISTENER_ACCEPTOR_THREADS;
    }
}

