/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventManager;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.ApplicationDeployEventListener;
import com.sun.enterprise.admin.event.AuditModuleEvent;
import com.sun.enterprise.admin.event.AuditModuleEventListener;
import com.sun.enterprise.admin.event.AuthRealmEvent;
import com.sun.enterprise.admin.event.AuthRealmEventListener;
import com.sun.enterprise.admin.event.BaseAdminEventHandler;
import com.sun.enterprise.admin.event.BaseDeployEvent;
import com.sun.enterprise.admin.event.BaseDeployEventListener;
import com.sun.enterprise.admin.event.ConfigChangeCategory;
import com.sun.enterprise.admin.event.ConfigChangeEvent;
import com.sun.enterprise.admin.event.ConfigChangeEventListener;
import com.sun.enterprise.admin.event.DependencyResolver;
import com.sun.enterprise.admin.event.EjbTimerEvent;
import com.sun.enterprise.admin.event.EjbTimerEventListener;
import com.sun.enterprise.admin.event.ElementChangeEvent;
import com.sun.enterprise.admin.event.ElementChangeEventListener;
import com.sun.enterprise.admin.event.EventBuilder;
import com.sun.enterprise.admin.event.EventDispatcher;
import com.sun.enterprise.admin.event.LogLevelChangeEvent;
import com.sun.enterprise.admin.event.LogLevelChangeEventListener;
import com.sun.enterprise.admin.event.MBeanLocator;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.ModuleDeployEventListener;
import com.sun.enterprise.admin.event.MonitoringEvent;
import com.sun.enterprise.admin.event.MonitoringEventListener;
import com.sun.enterprise.admin.event.MonitoringLevelChangeEvent;
import com.sun.enterprise.admin.event.MonitoringLevelChangeEventListener;
import com.sun.enterprise.admin.event.RRPersistenceHelper;
import com.sun.enterprise.admin.event.ResourceDeployEvent;
import com.sun.enterprise.admin.event.ResourceDeployEventListener;
import com.sun.enterprise.admin.event.SecurityServiceEvent;
import com.sun.enterprise.admin.event.SecurityServiceEventListener;
import com.sun.enterprise.admin.event.ShutdownEvent;
import com.sun.enterprise.admin.event.ShutdownEventListener;
import com.sun.enterprise.admin.event.UserMgmtEvent;
import com.sun.enterprise.admin.event.UserMgmtEventListener;
import com.sun.enterprise.admin.event.pluggable.NotificationFactory;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.channel.ReconfigHelper;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.ConfigSet;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ServerContextImpl;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;

public class AdminEventMulticaster {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static AdminEventMulticaster adminEventMulticaster = null;
    private HashMap listeners = new HashMap();
    private HashMap configCategoryList;
    private static StringManager localStrings = StringManager.getManager(AdminEventMulticaster.class);
    static final String MULTICAST_NOT_SUPPORTED = "event.multicast_not_supported";
    static final String HANDLER_INIT_ERROR = "event.handler_init_error";
    static final String HANDLER_ERROR = "event.handler_error";
    static final String SEND_NOTIFICATION_METHOD = "sendNotification";
    static final String SEND_NOTIFICATION_METHOD_SIG = "javax.management.Notification";

    private AdminEventMulticaster() {
        this.listeners.put(AdminEvent.eventType, new ArrayList());
        this.listeners.put(ConfigChangeEvent.eventType, new ArrayList());
        this.listeners.put(MonitoringEvent.eventType, new ArrayList());
        this.listeners.put(ShutdownEvent.eventType, new ArrayList());
        this.listeners.put(BaseDeployEvent.eventType, new ArrayList());
        this.listeners.put(ApplicationDeployEvent.eventType, new ArrayList());
        this.listeners.put(ModuleDeployEvent.eventType, new ArrayList());
        this.listeners.put(ResourceDeployEvent.eventType, new ArrayList());
        this.listeners.put(LogLevelChangeEvent.eventType, new ArrayList());
        this.listeners.put(MonitoringLevelChangeEvent.eventType, new ArrayList());
        this.listeners.put(SEND_NOTIFICATION_METHOD_SIG, new ArrayList());
        this.listeners.put(AuthRealmEvent.eventType, new ArrayList());
        this.listeners.put(AuditModuleEvent.eventType, new ArrayList());
        this.listeners.put(SecurityServiceEvent.eventType, new ArrayList());
        this.listeners.put(ElementChangeEvent.eventType, new ArrayList());
        this.listeners.put(UserMgmtEvent.eventType, new ArrayList());
        this.listeners.put(EjbTimerEvent.eventType, new ArrayList());
        this.configCategoryList = new HashMap();
    }

    public static AdminEventMulticaster getInstance() {
        if (adminEventMulticaster == null) {
            adminEventMulticaster = AdminEventMulticaster.create();
        }
        return adminEventMulticaster;
    }

    private static synchronized AdminEventMulticaster create() {
        return new AdminEventMulticaster();
    }

    public static AdminEventResult multicastEvent(AdminEvent event) {
        AdminEventResult result = null;
        AdminEventMulticaster aem = AdminEventMulticaster.getInstance();
        if (AdminService.getAdminService() == null || AdminEventMulticaster.isLocal(event) || AdminEventMulticaster.isLocalOld(event)) {
            event = AdminEventMulticaster.deferredEventResolution(event);
            AdminEventMulticaster.sendPreNotifyReconfigSignal(event);
            aem.processEvent(event);
            AdminEventMulticaster.sendPostNotifyReconfigSignal(event);
            if (AdminService.getAdminService() != null) {
                AdminEventMulticaster.getInstance().sendNotification(event);
            }
            result = AdminEventResult.getAdminEventResult(event);
            RRPersistenceHelper helper = new RRPersistenceHelper();
            helper.setRestartRequiredForServer(event, result);
            AdminEventResult.clearAdminEventResultFromCache(event);
        } else {
            PluggableFeatureFactory featureFactory = ApplicationServer.getServerContext().getPluggableFeatureFactory();
            NotificationFactory nFactory = featureFactory.getNotificationFactory();
            EventDispatcher eDispatcher = nFactory.createEventDispatcher();
            result = eDispatcher.dispatch(event);
        }
        return result;
    }

    private static boolean isLocalOld(AdminEvent event) {
        String source = event.getInstanceName();
        String instName = AdminService.getAdminService().getInstanceName();
        String tDest = event.getTargetDestination();
        return instName != null && instName.equals(source) && (tDest == null || tDest.length() == 0);
    }

    private static boolean isLocal(AdminEvent event) {
        String source = event.getTargetDestination();
        String instName = ApplicationServer.getServerContext().getInstanceName();
        String effective = event.getEffectiveDestination();
        if (instName != null && instName.equals(source)) {
            return true;
        }
        return instName != null && instName.equals(effective);
    }

    private static void sendPreNotifyReconfigSignal(AdminEvent event) {
        ConfigChangeEvent cce;
        if (event instanceof ConfigChangeEvent && (cce = (ConfigChangeEvent)event).isWebCoreReconfigNeeded()) {
            ReconfigHelper.sendReconfigMessage(event.getInstanceName());
        }
    }

    private static void sendPostNotifyReconfigSignal(AdminEvent event) {
        if (event instanceof ApplicationDeployEvent || event instanceof ModuleDeployEvent && ((ModuleDeployEvent)event).getModuleType().equals("web")) {
            ReconfigHelper.sendReconfigMessage(event.getInstanceName());
        }
    }

    public static void notifyFailure(AdminEvent event, String failureCode) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        result.setResultCode(failureCode);
    }

    public static void addEventResultAttribute(AdminEvent event, String name, Object value) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        result.addAttribute(event.getEffectiveDestination(), name, value);
    }

    public static Object getEventResultAttribute(AdminEvent event, String name) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        return result.getAttribute(event.getEffectiveDestination(), name);
    }

    public static void removeEventResultAttribute(AdminEvent event, String name) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        result.removeAttribute(event.getEffectiveDestination(), name);
    }

    public static void addNotificationListener(NotificationListener listener) {
    }

    public static void removeNotificationListener(NotificationListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addListener(String type, AdminEventListener listener) {
        AdminEventMulticaster aem = AdminEventMulticaster.getInstance();
        ArrayList<AdminEventListener> list = (ArrayList<AdminEventListener>)aem.listeners.get(type);
        Cloneable cloneable = aem.listeners;
        synchronized (cloneable) {
            if (list == null) {
                list = new ArrayList<AdminEventListener>();
                aem.listeners.put(type, list);
            }
        }
        cloneable = list;
        synchronized (cloneable) {
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addListener(String type, ConfigChangeCategory category, ConfigChangeEventListener listener) {
        AdminEventMulticaster.addListener(type, listener);
        AdminEventMulticaster aem = AdminEventMulticaster.getInstance();
        HashMap hashMap = aem.configCategoryList;
        synchronized (hashMap) {
            aem.configCategoryList.put(listener, category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeListener(AdminEventListener listener) {
        AdminEventMulticaster aem = AdminEventMulticaster.getInstance();
        String[] types = AdminEventMulticaster.getEventTypesFromListener(listener);
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            ArrayList list = (ArrayList)aem.listeners.get(type);
            if (!list.contains(listener)) continue;
            Cloneable cloneable = list;
            synchronized (cloneable) {
                list.remove(listener);
            }
            if (!type.equals(ConfigChangeEvent.eventType) || !aem.configCategoryList.containsKey(listener)) continue;
            cloneable = aem.configCategoryList;
            synchronized (cloneable) {
                aem.configCategoryList.remove(listener);
                continue;
            }
        }
    }

    private static String[] getEventTypesFromListener(AdminEventListener listener) {
        Class<?>[] interfaces = listener.getClass().getInterfaces();
        HashSet<String> typesSet = new HashSet<String>();
        for (int i = 0; i < interfaces.length; ++i) {
            String className = interfaces[i].getName();
            if (className.startsWith(ApplicationDeployEvent.eventType)) {
                typesSet.add(ApplicationDeployEvent.eventType);
                continue;
            }
            if (className.startsWith(ModuleDeployEvent.eventType)) {
                typesSet.add(ModuleDeployEvent.eventType);
                continue;
            }
            if (className.startsWith(ResourceDeployEvent.eventType)) {
                typesSet.add(ResourceDeployEvent.eventType);
                continue;
            }
            if (className.startsWith(BaseDeployEvent.eventType)) {
                typesSet.add(BaseDeployEvent.eventType);
                continue;
            }
            if (className.startsWith(ConfigChangeEvent.eventType)) {
                typesSet.add(ConfigChangeEvent.eventType);
                continue;
            }
            if (className.startsWith(MonitoringEvent.eventType)) {
                typesSet.add(MonitoringEvent.eventType);
                continue;
            }
            if (className.startsWith(ShutdownEvent.eventType)) {
                typesSet.add(ShutdownEvent.eventType);
                continue;
            }
            if (!className.startsWith(AdminEvent.eventType)) continue;
            typesSet.add(AdminEvent.eventType);
        }
        String[] template = new String[typesSet.size()];
        String[] types = typesSet.toArray(template);
        return types;
    }

    void processEvent(AdminEvent event) {
        String eventType = event.getType();
        boolean inited = this.initEventHandler(event);
        if (!inited) {
            return;
        }
        int lstnrCnt = 0;
        if (eventType.equals(ApplicationDeployEvent.eventType)) {
            lstnrCnt += this.handleApplicationDeployEvent(event);
            lstnrCnt += this.handleBaseDeployEvent(event);
        } else if (eventType.equals(ModuleDeployEvent.eventType)) {
            lstnrCnt += this.handleModuleDeployEvent(event);
            lstnrCnt += this.handleBaseDeployEvent(event);
        } else if (eventType.equals(ResourceDeployEvent.eventType)) {
            lstnrCnt += this.handleResourceDeployEvent(event);
            lstnrCnt += this.handleBaseDeployEvent(event);
        } else if (eventType.equals(BaseDeployEvent.eventType)) {
            lstnrCnt += this.handleBaseDeployEvent(event);
        } else if (eventType.equals(ConfigChangeEvent.eventType)) {
            lstnrCnt += this.handleConfigChangeEvent(event);
        } else if (eventType.equals(MonitoringEvent.eventType)) {
            lstnrCnt += this.handleMonitoringEvent(event);
        } else if (eventType.equals(MonitoringLevelChangeEvent.eventType)) {
            lstnrCnt += this.handleMonitoringLevelChangeEvent(event);
        } else if (eventType.equals(LogLevelChangeEvent.eventType)) {
            lstnrCnt += this.handleLogLevelChangeEvent(event);
        } else if (eventType.equals(ShutdownEvent.eventType)) {
            lstnrCnt += this.handleShutdownEvent(event);
        } else if (eventType.equals(AuthRealmEvent.eventType)) {
            lstnrCnt += this.handleAuthRealmEvent(event);
        } else if (eventType.equals(AuditModuleEvent.eventType)) {
            lstnrCnt += this.handleAuditModuleEvent(event);
        } else if (eventType.equals(SecurityServiceEvent.eventType)) {
            lstnrCnt += this.handleSecurityServiceEvent(event);
        } else if (eventType.equals(ElementChangeEvent.eventType)) {
            lstnrCnt += this.handleElementChangeEvent(event);
        } else if (eventType.equals(UserMgmtEvent.eventType)) {
            lstnrCnt += this.handleUserMgmtEvent(event);
        } else if (eventType.equals(EjbTimerEvent.eventType)) {
            lstnrCnt += this.handleEjbTimerEvent(event);
        } else {
            BaseAdminEventHandler handler = new BaseAdminEventHandler(event);
            lstnrCnt += handler.processEvent();
        }
        if (lstnrCnt == 0) {
            this.handleNoListeners(event);
        }
        this.destroyEventHandler(event);
    }

    private boolean initEventHandler(AdminEvent event) {
        if (AdminService.getAdminService() == null) {
            return true;
        }
        boolean success = true;
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        ConfigContext global = AdminService.getAdminService().getContext().getConfigContext();
        ConfigContext local = null;
        if (event.configChangeList != null) {
            try {
                local = (ConfigContext)global.clone();
                this.applyDependentChangesToContext(local, event.dependentChangeList);
                this.applyChangesToContext(local, event.configChangeList);
            }
            catch (ConfigException ce) {
                result.setResultCode("config_snapshot_error");
                result.addException(event.getEffectiveDestination(), ce);
                logger.log(Level.FINE, HANDLER_INIT_ERROR, ce.getMessage());
                AdminEventMulticaster.debug(AdminEventMulticaster.getStackTraceFromThrowable(ce));
                success = false;
            }
            catch (Throwable t) {
                this.handleError(event, t, result, HANDLER_INIT_ERROR);
                success = false;
            }
        } else {
            local = global;
        }
        event.setOldContext(global);
        event.setContext(local);
        return success;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AdminEvent deferredEventResolution(AdminEvent event) {
        if (AdminService.getAdminService() == null) {
            return event;
        }
        ConfigContext ctx = AdminService.getAdminService().getContext().getConfigContext();
        if (event instanceof ResourceDeployEvent) {
            ResourceDeployEvent res = (ResourceDeployEvent)event;
            String type = res.getResourceType();
            if (type == null) {
                try {
                    type = EventBuilder.getResourceTypeByName(ctx, res.getResourceName(), res.getTargetDestination());
                    res.setResourceType(type);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                String server;
                String pool;
                ConfigBean cRes;
                String action = res.getAction();
                if (!"reference-removed".equals(action) && !"undeploy".equals(action)) return event;
                String effective = res.getEffectiveDestination();
                String resName = res.getResourceName();
                DependencyResolver dr = new DependencyResolver(ctx, effective);
                List list = dr.getConfigDeleteForResource(resName, type);
                res.addDependentConfigChange(list);
                if (type != null) {
                    if (type.equals("jdbc")) {
                        String server2;
                        String pool2;
                        ConfigBean jRes = dr.findResource(resName, type);
                        if (!(jRes instanceof JdbcResource) || AdminEventMulticaster.isJdbcPoolReferenced(ctx, pool2 = ((JdbcResource)jRes).getPoolName(), server2 = AdminService.getAdminService().getInstanceName(), resName)) return event;
                        res.addDependentConfigChange(dr.getConfigDeleteForResource(pool2, "jcp"));
                        return event;
                    }
                }
                if (type == null) return event;
                if (!type.equals("cr") || !((cRes = dr.findResource(resName, type)) instanceof ConnectorResource) || AdminEventMulticaster.isConnectorPoolReferenced(ctx, pool = ((ConnectorResource)cRes).getPoolName(), server = AdminService.getAdminService().getInstanceName(), resName)) return event;
                res.addDependentConfigChange(dr.getConfigDeleteForResource(pool, "ccp"));
                return event;
            }
            catch (Exception e) {}
            return event;
        }
        if (!(event instanceof BaseDeployEvent)) return event;
        BaseDeployEvent app = (BaseDeployEvent)event;
        String type = app.getJ2EEComponentType();
        if (type == null) {
            try {
                event = EventBuilder.resolveModAppDeployEventType(app, ctx);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            String action = app.getAction();
            if (!"reference-removed".equals(action) && !"undeploy".equals(action)) return event;
            String effective = app.getEffectiveDestination();
            String appName = app.getJ2EEComponentName();
            DependencyResolver dr = new DependencyResolver(ctx, effective);
            List list = dr.getConfigDeleteForApplication(appName);
            app.addDependentConfigChange(list);
            ResourceAdapterConfig raConfig = dr.findResourceAdapterConfigByName(appName);
            if (raConfig == null) return event;
            app.addDependentConfigChange(dr.getConfigDeleteForResource(raConfig));
            return event;
        }
        catch (Exception e) {
            // empty catch block
        }
        return event;
    }

    private static boolean isJdbcPoolReferenced(ConfigContext ctx, String poolName, String serverName, String eResName) throws ConfigException {
        if (ctx == null || poolName == null || serverName == null || eResName == null) {
            return false;
        }
        Resources rBean = ServerBeansFactory.getDomainBean(ctx).getResources();
        JdbcResource[] jdbcBeans = rBean.getJdbcResource();
        if (jdbcBeans == null) {
            return false;
        }
        for (int i = 0; i < jdbcBeans.length; ++i) {
            if (!ServerHelper.serverReferencesResource(ctx, serverName, jdbcBeans[i].getJndiName())) continue;
            String pool = jdbcBeans[i].getPoolName();
            String rName = jdbcBeans[i].getJndiName();
            if (pool == null || !pool.equals(poolName) || eResName.equals(rName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnectorPoolReferenced(ConfigContext ctx, String poolName, String serverName, String eResName) throws ConfigException {
        if (ctx == null || poolName == null || serverName == null || eResName == null) {
            return false;
        }
        Resources rBean = ServerBeansFactory.getDomainBean(ctx).getResources();
        ConnectorResource[] conBeans = rBean.getConnectorResource();
        if (conBeans == null) {
            return false;
        }
        for (int i = 0; i < conBeans.length; ++i) {
            if (!ServerHelper.serverReferencesResource(ctx, serverName, conBeans[i].getJndiName())) continue;
            String pool = conBeans[i].getPoolName();
            String rName = conBeans[i].getJndiName();
            if (pool == null || !pool.equals(poolName) || eResName.equals(rName)) continue;
            return true;
        }
        return false;
    }

    private void applyDependentChangesToContext(ConfigContext ctx, List list) {
        try {
            if (list != null) {
                this.applyChangesToContext(ctx, (ArrayList)list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void applyChangesToContext(ConfigContext configContext, ArrayList changeList) throws ConfigException {
        Iterator iter = changeList.iterator();
        ArrayList<ConfigChange> updates = new ArrayList<ConfigChange>();
        while (iter.hasNext()) {
            ConfigChange change = (ConfigChange)iter.next();
            if (change instanceof ConfigUpdate) {
                updates.add(change);
                continue;
            }
            if (change instanceof ConfigAdd || change instanceof ConfigSet) {
                try {
                    if (ConfigBeansFactory.getConfigBeanByXPath(configContext, change.getXPath()) != null) continue;
                    configContext.updateFromConfigChange(change);
                }
                catch (Exception e) {}
                continue;
            }
            configContext.updateFromConfigChange(change);
        }
        iter = updates.iterator();
        while (iter.hasNext()) {
            ConfigUpdate update = (ConfigUpdate)iter.next();
            configContext.updateFromConfigChange(update);
        }
    }

    private void destroyEventHandler(AdminEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        if ("success".equals(result.getResultCode())) {
            ServerContext ctx = AdminService.getAdminService().getContext();
            if (ctx instanceof ServerContextImpl) {
                ConfigContext oldCtx = ctx.getConfigContext();
                ConfigContext newCtx = event.getConfigContext();
                ((ServerContextImpl)ctx).setConfigContext(newCtx);
                try {
                    ConfigFactory.replaceConfigContext(oldCtx, newCtx);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "event.replace_ctx_failed", e);
                }
                if (!AdminService.getAdminService().isDas()) {
                    try {
                        AdminService.getAdminService().getContext().getConfigContext().flush();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "event.flush_failed");
                    }
                }
            } else {
                logger.log(Level.SEVERE, "event.unknown_serverctx_type", ctx.getClass().getName());
            }
        }
    }

    ArrayList getListeners(String type) {
        return (ArrayList)this.listeners.get(type);
    }

    private int handleApplicationDeployEvent(AdminEvent event) {
        ApplicationDeployEvent ade = (ApplicationDeployEvent)event;
        ArrayList list = this.getListeners(ApplicationDeployEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ApplicationDeployEventListener listener = (ApplicationDeployEventListener)iter.next();
                this.invokeApplicationDeployEventListener(listener, ade);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeApplicationDeployEventListener(ApplicationDeployEventListener listener, ApplicationDeployEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            String action = event.getAction();
            if ("deploy".equals(action)) {
                listener.applicationDeployed(event);
            } else if ("undeploy".equals(action)) {
                listener.applicationUndeployed(event);
            } else if ("redeploy".equals(action)) {
                listener.applicationRedeployed(event);
            } else if ("enable".equals(action)) {
                listener.applicationEnabled(event);
            } else if ("disable".equals(action)) {
                listener.applicationDisabled(event);
            } else if ("reference-added".equals(action)) {
                listener.applicationReferenceAdded(event);
            } else if ("reference-removed".equals(action)) {
                listener.applicationReferenceRemoved(event);
            }
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleModuleDeployEvent(AdminEvent event) {
        ModuleDeployEvent mde = (ModuleDeployEvent)event;
        ArrayList list = this.getListeners(ModuleDeployEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ModuleDeployEventListener listener = (ModuleDeployEventListener)iter.next();
                this.invokeModuleDeployEventListener(listener, mde);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeModuleDeployEventListener(ModuleDeployEventListener listener, ModuleDeployEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            String action = event.getAction();
            if ("deploy".equals(action)) {
                listener.moduleDeployed(event);
            } else if ("undeploy".equals(action)) {
                listener.moduleUndeployed(event);
            } else if ("redeploy".equals(action)) {
                listener.moduleRedeployed(event);
            } else if ("enable".equals(action)) {
                listener.moduleEnabled(event);
            } else if ("disable".equals(action)) {
                listener.moduleDisabled(event);
            } else if ("reference-added".equals(action)) {
                listener.moduleReferenceAdded(event);
            } else if ("reference-removed".equals(action)) {
                listener.moduleReferenceRemoved(event);
            }
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleResourceDeployEvent(AdminEvent event) {
        ResourceDeployEvent rde = (ResourceDeployEvent)event;
        ArrayList list = this.getListeners(ResourceDeployEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ResourceDeployEventListener listener = (ResourceDeployEventListener)iter.next();
                this.invokeResourceDeployEventListener(listener, rde);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeResourceDeployEventListener(ResourceDeployEventListener listener, ResourceDeployEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            String action = event.getAction();
            if ("deploy".equals(action)) {
                listener.resourceDeployed(event);
            } else if ("undeploy".equals(action)) {
                listener.resourceUndeployed(event);
            } else if ("redeploy".equals(action)) {
                listener.resourceRedeployed(event);
            } else if ("enable".equals(action)) {
                listener.resourceEnabled(event);
            } else if ("disable".equals(action)) {
                listener.resourceDisabled(event);
            } else if ("reference-added".equals(action)) {
                listener.resourceReferenceAdded(event);
            } else if ("reference-removed".equals(action)) {
                listener.resourceReferenceRemoved(event);
            }
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleBaseDeployEvent(AdminEvent event) {
        BaseDeployEvent bde = (BaseDeployEvent)event;
        ArrayList list = this.getListeners(BaseDeployEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                BaseDeployEventListener listener = (BaseDeployEventListener)iter.next();
                this.invokeBaseDeployEventListener(listener, bde);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeBaseDeployEventListener(BaseDeployEventListener listener, BaseDeployEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            String componentType = event.getJ2EEComponentType();
            String action = event.getAction();
            if ("application".equals(componentType)) {
                if ("deploy".equals(action)) {
                    listener.applicationDeployed(event);
                } else if ("undeploy".equals(action)) {
                    listener.applicationUndeployed(event);
                } else if ("redeploy".equals(action)) {
                    listener.applicationRedeployed(event);
                } else if ("enable".equals(action)) {
                    listener.applicationEnabled(event);
                } else if ("disable".equals(action)) {
                    listener.applicationDisabled(event);
                } else if ("reference-added".equals(action)) {
                    listener.applicationReferenceAdded(event);
                } else if ("reference-removed".equals(action)) {
                    listener.applicationReferenceRemoved(event);
                }
            } else if ("module".equals(componentType)) {
                if ("deploy".equals(action)) {
                    listener.moduleDeployed(event);
                } else if ("undeploy".equals(action)) {
                    listener.moduleUndeployed(event);
                } else if ("redeploy".equals(action)) {
                    listener.moduleRedeployed(event);
                } else if ("enable".equals(action)) {
                    listener.moduleEnabled(event);
                } else if ("disable".equals(action)) {
                    listener.moduleDisabled(event);
                } else if ("reference-added".equals(action)) {
                    listener.moduleReferenceAdded(event);
                } else if ("reference-removed".equals(action)) {
                    listener.moduleReferenceRemoved(event);
                }
            } else if ("resource".equals(componentType)) {
                if ("deploy".equals(action)) {
                    listener.resourceDeployed(event);
                } else if ("undeploy".equals(action)) {
                    listener.resourceUndeployed(event);
                } else if ("redeploy".equals(action)) {
                    listener.resourceRedeployed(event);
                } else if ("enable".equals(action)) {
                    listener.resourceEnabled(event);
                } else if ("disable".equals(action)) {
                    listener.resourceDisabled(event);
                } else if ("reference-added".equals(action)) {
                    listener.resourceReferenceAdded(event);
                } else if ("reference-removed".equals(action)) {
                    listener.resourceReferenceRemoved(event);
                }
            }
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleConfigChangeEvent(AdminEvent event) {
        int listenersInvoked = 0;
        ConfigChangeEvent cce = (ConfigChangeEvent)event;
        ArrayList list = this.getListeners(ConfigChangeEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ConfigChangeEventListener listener = (ConfigChangeEventListener)iter.next();
                ConfigChangeCategory category = (ConfigChangeCategory)this.configCategoryList.get(listener);
                boolean match = true;
                if (category != null) {
                    match = cce.matchXPathToPattern(category.getConfigXPathPattern());
                }
                if (!match) continue;
                this.invokeConfigChangeEventListener(listener, cce);
                ++listenersInvoked;
            }
        }
        if (!cce.isAllXPathMatched()) {
            AdminEventResult result = AdminEventResult.getAdminEventResult(cce);
        }
        return listenersInvoked;
    }

    private void invokeConfigChangeEventListener(ConfigChangeEventListener listener, ConfigChangeEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            listener.configChanged(event);
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleMonitoringEvent(AdminEvent event) {
        MonitoringEvent me = (MonitoringEvent)event;
        ArrayList list = this.getListeners(MonitoringEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                MonitoringEventListener listener = (MonitoringEventListener)iter.next();
                this.invokeMonitoringEventListener(listener, me);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeMonitoringEventListener(MonitoringEventListener listener, MonitoringEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            String action = event.getActionCode();
            if ("start_monitoring".equals(action)) {
                listener.startMonitoring(event);
            } else if ("stop_monitoring".equals(action)) {
                listener.stopMonitoring(event);
            } else if ("get_monitoring".equals(action)) {
                listener.getMonitoringData(event);
            } else if ("list_monitorable".equals(action)) {
                listener.listMonitorable(event);
            } else if ("set_monitoring".equals(action)) {
                listener.setMonitoringData(event);
            }
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleElementChangeEvent(AdminEvent event) {
        ElementChangeEvent me = (ElementChangeEvent)event;
        ArrayList list = this.getListeners(ElementChangeEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ElementChangeEventListener listener = (ElementChangeEventListener)iter.next();
                this.invokeElementChangeEventListener(listener, me);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeElementChangeEventListener(ElementChangeEventListener listener, ElementChangeEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            listener.processEvent(event);
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleUserMgmtEvent(AdminEvent event) {
        UserMgmtEvent me = (UserMgmtEvent)event;
        ArrayList list = this.getListeners(UserMgmtEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                UserMgmtEventListener listener = (UserMgmtEventListener)iter.next();
                this.invokeUserMgmtEventListener(listener, me);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeUserMgmtEventListener(UserMgmtEventListener listener, UserMgmtEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            int action = event.getActionType();
            if (action == 1) {
                listener.userAdded(event);
            } else if (action == 2) {
                listener.userUpdated(event);
            } else if (action == 3) {
                listener.userRemoved(event);
            }
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleEjbTimerEvent(AdminEvent event) {
        EjbTimerEvent me = (EjbTimerEvent)event;
        ArrayList list = this.getListeners(EjbTimerEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                EjbTimerEventListener listener = (EjbTimerEventListener)iter.next();
                this.invokeEjbTimerEventListener(listener, me);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeEjbTimerEventListener(EjbTimerEventListener listener, EjbTimerEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            int action = event.getActionType();
            if (action == 1) {
                int iCount = listener.migrateTimer(event, event.getFromServerName());
                result.addAttribute(event.getEffectiveDestination(), "ejb_timer_call_result", new Integer(iCount));
            } else if (action == 2) {
                String[] strs = listener.listTimers(event, event.getServerNames());
                result.addAttribute(event.getEffectiveDestination(), "ejb_timer_call_result", strs);
            }
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleAuthRealmEvent(AdminEvent event) {
        AuthRealmEvent me = (AuthRealmEvent)event;
        ArrayList list = this.getListeners(AuthRealmEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                AuthRealmEventListener listener = (AuthRealmEventListener)iter.next();
                this.invokeAuthRealmEventListener(listener, me);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeAuthRealmEventListener(AuthRealmEventListener listener, AuthRealmEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            int action = event.getActionType();
            if (action == 1) {
                listener.authRealmCreated(event);
            } else if (action == 3) {
                listener.authRealmUpdated(event);
            } else if (action == 2) {
                listener.authRealmDeleted(event);
            }
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleAuditModuleEvent(AdminEvent event) {
        AuditModuleEvent me = (AuditModuleEvent)event;
        ArrayList list = this.getListeners(AuditModuleEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                AuditModuleEventListener listener = (AuditModuleEventListener)iter.next();
                this.invokeAuditModuleEventListener(listener, me);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeAuditModuleEventListener(AuditModuleEventListener listener, AuditModuleEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            int action = event.getActionType();
            if (action == 1) {
                listener.auditModuleCreated(event);
            } else if (action == 3) {
                listener.auditModuleUpdated(event);
            } else if (action == 2) {
                listener.auditModuleDeleted(event);
            }
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleSecurityServiceEvent(AdminEvent event) {
        SecurityServiceEvent me = (SecurityServiceEvent)event;
        ArrayList list = this.getListeners(SecurityServiceEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                SecurityServiceEventListener listener = (SecurityServiceEventListener)iter.next();
                this.invokeSecurityServiceEventListener(listener, me);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeSecurityServiceEventListener(SecurityServiceEventListener listener, SecurityServiceEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            int action = event.getActionType();
            if (action == 1) {
                listener.securityServiceCreated(event);
            } else if (action == 3) {
                listener.securityServiceUpdated(event);
            } else if (action == 2) {
                listener.securityServiceDeleted(event);
            }
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleLogLevelChangeEvent(AdminEvent event) {
        LogLevelChangeEvent llce = (LogLevelChangeEvent)event;
        ArrayList list = this.getListeners(LogLevelChangeEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                LogLevelChangeEventListener listener = (LogLevelChangeEventListener)iter.next();
                this.invokeLogLevelChangeEventListener(listener, llce);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeLogLevelChangeEventListener(LogLevelChangeEventListener listener, LogLevelChangeEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            listener.logLevelChanged(event);
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleMonitoringLevelChangeEvent(AdminEvent event) {
        MonitoringLevelChangeEvent mlce = (MonitoringLevelChangeEvent)event;
        ArrayList list = this.getListeners(MonitoringLevelChangeEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                MonitoringLevelChangeEventListener listener = (MonitoringLevelChangeEventListener)iter.next();
                this.invokeMonitoringLevelChangeEventListener(listener, mlce);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeMonitoringLevelChangeEventListener(MonitoringLevelChangeEventListener listener, MonitoringLevelChangeEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            listener.monitoringLevelChanged(event);
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private int handleShutdownEvent(AdminEvent event) {
        ShutdownEvent se = (ShutdownEvent)event;
        ArrayList list = this.getListeners(ShutdownEvent.eventType);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ShutdownEventListener listener = (ShutdownEventListener)iter.next();
                this.invokeShutdownEventListener(listener, se);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeShutdownEventListener(ShutdownEventListener listener, ShutdownEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        try {
            listener.startShutdown(event);
        }
        catch (Throwable t) {
            this.handleListenerError(event, t, result);
        }
    }

    private static String getEventTypeFromListener(AdminEventListener listener) {
        Class<?>[] interfaces = listener.getClass().getInterfaces();
        String type = null;
        for (int i = 0; i < interfaces.length; ++i) {
            String className = interfaces[i].getName();
            if (className.startsWith(ApplicationDeployEvent.eventType)) {
                type = ApplicationDeployEvent.eventType;
            } else if (className.startsWith(ModuleDeployEvent.eventType)) {
                type = ModuleDeployEvent.eventType;
            } else if (className.startsWith(ResourceDeployEvent.eventType)) {
                type = ResourceDeployEvent.eventType;
            } else if (className.startsWith(BaseDeployEvent.eventType)) {
                type = BaseDeployEvent.eventType;
            } else if (className.startsWith(ConfigChangeEvent.eventType)) {
                type = ConfigChangeEvent.eventType;
            } else if (className.startsWith(MonitoringEvent.eventType)) {
                type = MonitoringEvent.eventType;
            } else if (className.startsWith(ShutdownEvent.eventType)) {
                type = ShutdownEvent.eventType;
            } else if (className.startsWith(AdminEvent.eventType)) {
                type = AdminEvent.eventType;
            }
            if (type != null) break;
        }
        return type;
    }

    private void refreshConfigContext() {
        try {
            AdminService.getAdminService().getContext().getConfigContext().refresh(true);
        }
        catch (ConfigException ce) {
            AdminEventMulticaster.warn("Unable to refresh ConfigContext upon receiving ConfigChangeEvent.");
            AdminEventMulticaster.debug(ce);
        }
    }

    private void handleNoListeners(AdminEvent event) {
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        result.setResultCode("restart");
    }

    void handleListenerError(AdminEvent event, Throwable t, AdminEventResult result) {
        t.printStackTrace();
        this.handleError(event, t, result, HANDLER_ERROR);
    }

    private void handleError(AdminEvent event, Throwable t, AdminEventResult result, String msg) {
        logger.log(Level.WARNING, msg, t.getMessage());
        String stackTrace = AdminEventMulticaster.getStackTraceFromThrowable(t);
        AdminEventMulticaster.debug(stackTrace);
        if ("success".equals(result.getResultCode())) {
            if (t instanceof AdminEventListenerException) {
                result.setResultCode("listener_error");
            } else if (t instanceof RuntimeException) {
                result.setResultCode("runtime_exception");
            } else if (t instanceof Error) {
                result.setResultCode("runtime_error");
            } else {
                result.setResultCode("runtime_error");
            }
        }
        result.addException(event.getEffectiveDestination(), t);
    }

    private static String getStackTraceFromThrowable(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    static void warn(String s) {
        logger.warning(s);
    }

    static void debug(String s) {
        logger.fine(s);
    }

    static void debug(Throwable t) {
        logger.log(Level.FINE, t.getMessage(), t);
    }

    public void sendNotification(AdminEvent event) {
        AdminEventManager am = AdminEventManager.getAdminEventManager();
        MBeanLocator mbl = am.getMBeanLocator();
        Set objs = (Set)mbl.locate(event.getEventId());
        AdminEventResult result = AdminEventResult.getAdminEventResult(event);
        if (objs == null || objs.size() == 0) {
            return;
        }
        Iterator it = objs.iterator();
        while (it.hasNext()) {
            try {
                ObjectInstance oi = (ObjectInstance)it.next();
                MBeanServerFactory.getMBeanServer().invoke(oi.getObjectName(), SEND_NOTIFICATION_METHOD, new Object[]{event}, new String[]{SEND_NOTIFICATION_METHOD_SIG});
            }
            catch (Throwable t) {
                this.handleListenerError(event, t, result);
            }
        }
    }
}

