/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.BaseDeployEvent;
import com.sun.enterprise.admin.event.ConfigChangeEvent;
import com.sun.enterprise.admin.event.LogLevelChangeEvent;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.MonitoringLevelChangeEvent;
import com.sun.enterprise.admin.event.ResourceDeployEvent;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigSet;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.impl.ConfigUpdateImpl;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdminEventCache {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final transient HashMap instanceCacheMap = new HashMap();
    private String instanceName;
    private ArrayList cache;
    private boolean restartNeeded = false;
    private long tsRestartNeededSince;
    private ConfigContext adminConfigContext;
    private static final String RES_PFX = ServerXPathHelper.XPATH_RESOURCES;
    private static final String APP_PFX = ServerXPathHelper.XPATH_J2EE_APPLICATION;
    private static final String WEB_PFX = ServerXPathHelper.XPATH_WEB_MODULE;
    private static final String EJB_PFX = ServerXPathHelper.XPATH_EJB_MODULE;
    private static final String RAR_PFX = ServerXPathHelper.XPATH_CONNECTOR_MODULE;
    private static final String ACC_PFX = ServerXPathHelper.XPATH_APPCLIENT_MODULE;
    private static final String HTTP_SERVICE = ServerXPathHelper.XPATH_HTTP_SERVICE;
    private static final String WEB_CONTAINER = ServerXPathHelper.XPATH_WEB_CONTAINER;
    private static final String PROPERTY_REGEX = ServerXPathHelper.XPATH_DOMAIN + "/" + "{1,}" + ".*" + "/" + "{1,}" + ServerTags.ELEMENT_PROPERTY + ".*";
    private static final String LOG_LEVEL_XPATH = ServerXPathHelper.XPATH_CONFIG + "/" + ServerTags.LOG_SERVICE + "/" + ServerTags.MODULE_LOG_LEVELS;
    private static final String MONITORING_LEVEL_XPATH = ServerXPathHelper.XPATH_CONFIG + "/" + ServerTags.MONITORING_SERVICE + "/" + ServerTags.MODULE_MONITORING_LEVELS;
    private static final String PROCESS_CHANGE = "event.process_change";
    private static final String CHANGE_NULL = "event.change_null";
    private static final String EXTRACT_CHANGE = "event.extract_change";
    private static final String CONFIG_CHANGE_XPATH = "event.config_change_xpath";
    private static final String PURGE_NOOP = "event.purge_noop";
    private static final String NULL_UPDATED_ATTRS = "event.null_updated_attrs";
    private static final String INVALID_XPATH_TOKENIZATION = "event.invalid_xpath_tokenization";
    private static StringManager localStrings = StringManager.getManager(AdminEventCache.class);

    AdminEventCache(String instanceName) {
        this.instanceName = instanceName;
        this.cache = new ArrayList();
        RMIClient channel = AdminChannel.getRMIClient(instanceName);
        if (channel.isRestartNeeded()) {
            this.setRestartNeededTrue(false);
        }
    }

    public static synchronized AdminEventCache getInstance(String instanceName) {
        AdminEventCache aec = (AdminEventCache)instanceCacheMap.get(instanceName);
        if (aec == null) {
            aec = new AdminEventCache(instanceName);
            instanceCacheMap.put(instanceName, aec);
        }
        return aec;
    }

    public void setAdminConfigContext(ConfigContext ctx) {
        this.adminConfigContext = ctx;
    }

    ArrayList getCachedEvents() {
        return this.cache;
    }

    public synchronized ArrayList getAndResetCachedEvents() {
        ArrayList saved = this.cache;
        this.cache = new ArrayList();
        return saved;
    }

    public void addEvent(AdminEvent event) {
        this.cache.add(event);
    }

    public void addEvents(ArrayList eventList) {
        this.cache.addAll(eventList);
    }

    public void removeEvent(AdminEvent event) {
        this.cache.remove(event);
    }

    public synchronized void processConfigChangeList(ArrayList changeList, boolean initOrObjFilesChanged, boolean mimeFileChanged) {
        ConfigChangeEvent dfltEvent = null;
        boolean dfltEventCached = false;
        Iterator iter = this.cache.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof ConfigChangeEvent)) continue;
            dfltEvent = (ConfigChangeEvent)obj;
            dfltEventCached = true;
            break;
        }
        if (initOrObjFilesChanged || mimeFileChanged) {
            if (dfltEvent == null) {
                dfltEvent = new ConfigChangeEvent(this.instanceName, null);
            }
            dfltEvent.setWebCoreReconfigNeeded(true);
        }
        if (initOrObjFilesChanged) {
            if (dfltEvent == null) {
                dfltEvent = new ConfigChangeEvent(this.instanceName, null);
            }
            dfltEvent.setInitOrObjConfChanged(true);
        }
        if (changeList != null && !changeList.isEmpty()) {
            iter = changeList.iterator();
            while (iter.hasNext()) {
                ConfigChange change = (ConfigChange)iter.next();
                if (change == null) continue;
                this.doChangeBucketing(change, dfltEvent, changeList);
            }
        }
        if (dfltEvent != null && !dfltEventCached) {
            this.cache.add(dfltEvent);
        }
        this.purgeNopEvents();
    }

    private void doChangeBucketing(ConfigChange change, ConfigChangeEvent dflt, ArrayList changeList) {
        logger.log(Level.FINE, PROCESS_CHANGE, change);
        if (change == null || change.getXPath() == null) {
            logger.log(Level.FINE, CHANGE_NULL, change);
            return;
        }
        boolean processed = false;
        if (dflt != null && !processed) {
            dflt.addConfigChange(change);
            if (!dflt.isWebCoreReconfigNeeded()) {
                this.setWebCoreReconfig(change, dflt);
            }
        }
    }

    private boolean processLogLevelChangeEvent(ConfigChange change) {
        return this.processLevelChangeEvent(change, new LogLevelChangeProcessor(this));
    }

    private boolean processMonitoringLevelChangeEvent(ConfigChange change) {
        return this.processLevelChangeEvent(change, new MonitoringLevelChangeProcessor(this));
    }

    private boolean processLevelChangeEvent(ConfigChange change, LevelChangeProcessor processor) {
        ConfigUpdate update = this.convertToConfigUpdate(change);
        if (update == null) {
            return false;
        }
        String xpath = AdminEventCache.cleanXPath(update.getXPath());
        if (!processor.isRelevant(xpath)) {
            return false;
        }
        Set attrs = update.getAttributeSet();
        if (attrs == null) {
            logger.log(Level.FINEST, "admin.event.null_updated_attrs", update.getXPath());
            return false;
        }
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            String compName = (String)iter.next();
            String oldValue = update.getOldValue(compName);
            String newValue = update.getNewValue(compName);
            AdminEvent event = processor.createEvent(compName, oldValue, newValue);
            this.cache.add(event);
            ConfigUpdateImpl upd = new ConfigUpdateImpl(xpath, compName, oldValue, newValue);
            event.addConfigChange(upd);
        }
        return true;
    }

    private boolean processResourceChangeEvent(ConfigChange change) {
        String xpath = AdminEventCache.cleanXPath(change.getXPath());
        boolean processed = false;
        if (this.isResourceXPath(xpath)) {
            String actionCode = null;
            if (change instanceof ConfigUpdate) {
                ConfigUpdate update = (ConfigUpdate)change;
                String enableStr = update.getNewValue(ServerTags.ENABLED);
                actionCode = enableStr != null ? (AdminEventCache.getServerXmlBooleanValue(enableStr) ? "enable" : "disable") : "redeploy";
            } else if (change instanceof ConfigAdd) {
                boolean isMap;
                boolean bl = isMap = xpath.indexOf(ServerTags.SECURITY_MAP) != -1;
                actionCode = this.isPropertyXPath(xpath) || isMap ? "redeploy" : "deploy";
            } else if (change instanceof ConfigDelete) {
                boolean isMap;
                boolean bl = isMap = xpath.indexOf(ServerTags.SECURITY_MAP) != -1;
                actionCode = this.isPropertyXPath(xpath) || isMap ? "redeploy" : "undeploy";
            } else if (change instanceof ConfigSet) {
                actionCode = "redeploy";
            } else {
                String msg = localStrings.getString("admin.event.unknown_configchange_for_resources");
                throw new IllegalStateException(msg);
            }
            String resType = this.getResourceType(xpath);
            String resName = this.getResourceName(xpath);
            ResourceDeployEvent resEvent = this.findResourceDeployEvent(resType, resName);
            if (resEvent == null) {
                resEvent = new ResourceDeployEvent(this.instanceName, resName, resType, actionCode);
                this.cache.add(resEvent);
            } else if (this.isActionValidForCache(actionCode)) {
                resEvent.setNewAction(actionCode);
            }
            resEvent.addConfigChange(change);
            processed = true;
        }
        return processed;
    }

    private boolean isResourceXPath(String xpath) {
        String xpathLcase = xpath.toLowerCase();
        return xpathLcase.startsWith(RES_PFX);
    }

    private boolean isPropertyXPath(String xpath) {
        return AdminEventCache.matchRegex(PROPERTY_REGEX, xpath);
    }

    private boolean isLogLevelXPath(String xpath) {
        return LOG_LEVEL_XPATH.equalsIgnoreCase(xpath);
    }

    private boolean isMonitoringLevelXPath(String xpath) {
        return MONITORING_LEVEL_XPATH.equalsIgnoreCase(xpath);
    }

    private boolean isAppRefXPath(String xpath) {
        if (xpath == null) {
            return false;
        }
        String serverXPath = ServerXPathHelper.getServerIdXpath(this.instanceName);
        String appRefXPath = serverXPath + "/" + ServerTags.APPLICATION_REF;
        return xpath.startsWith(appRefXPath);
    }

    private boolean isResRefXPath(String xpath) {
        if (xpath == null) {
            return false;
        }
        String serverXPath = ServerXPathHelper.getServerIdXpath(this.instanceName);
        String resRefXPath = serverXPath + "/" + ServerTags.RESOURCE_REF;
        return xpath.startsWith(resRefXPath);
    }

    private static String getAppRefXPath(String instance, String appName) {
        return ServerXPathHelper.getServerIdXpath(instance) + "/" + ServerTags.APPLICATION_REF + "[@" + ServerTags.REF + "='" + appName + "']";
    }

    private String getResourceType(String xpath) {
        String resType = "unknown";
        String xpathLcase = xpath.toLowerCase();
        if (xpathLcase.startsWith(ServerXPathHelper.XPATH_CUSTOM_RESOURCE)) {
            resType = "custom";
        } else if (xpathLcase.startsWith(ServerXPathHelper.XPATH_JNDI_RESOURCE)) {
            resType = "external-jndi";
        } else if (xpathLcase.startsWith(ServerXPathHelper.XPATH_JDBC_CONNECTION_POOL)) {
            resType = "jcp";
        } else if (xpathLcase.startsWith(ServerXPathHelper.XPATH_JDBC_RESOURCE)) {
            resType = "jdbc";
        } else if (xpathLcase.startsWith(ServerXPathHelper.XPATH_MAIL_RESOURCE)) {
            resType = "mail";
        } else if (xpathLcase.startsWith(ServerXPathHelper.XPATH_PM_FACTORY_RESOURCE)) {
            resType = "pmf";
        } else if (xpathLcase.startsWith(ServerXPathHelper.XPATH_ADMIN_OBJECT_RESOURCE)) {
            resType = "aor";
        } else if (xpathLcase.startsWith(ServerXPathHelper.XPATH_CONNECTOR_CONNECTION_POOL)) {
            resType = "ccp";
        } else if (xpathLcase.startsWith(ServerXPathHelper.XPATH_CONNECTOR_RESOURCE)) {
            resType = "cr";
        } else if (xpathLcase.startsWith(ServerXPathHelper.XPATH_RESOURCE_ADAPTER_CONFIG)) {
            resType = "rac";
        }
        return resType;
    }

    private String getResourceName(String xpath) {
        return this.getXPathToken(xpath, 1);
    }

    private String getXPathToken(String xpath, int numToDiscard) {
        StringTokenizer tok = new StringTokenizer(xpath, "'");
        if (tok.countTokens() <= numToDiscard) {
            Object[] params = new Object[]{xpath, new Integer(numToDiscard + 1), new Integer(tok.countTokens())};
            logger.log(Level.FINE, INVALID_XPATH_TOKENIZATION, params);
            String msg = localStrings.getString("admin.event.invalid_xpath_tokenization", params);
            throw new IllegalArgumentException(msg);
        }
        for (int i = numToDiscard; i > 0; --i) {
            String discard = tok.nextToken();
        }
        return tok.nextToken();
    }

    private boolean processOtherDeployEvent(ConfigChange change) {
        String xpath = AdminEventCache.cleanXPath(change.getXPath());
        String xpathLcase = xpath.toLowerCase();
        boolean processed = false;
        String componentType = null;
        String moduleType = null;
        if (xpathLcase.startsWith(APP_PFX)) {
            componentType = "application";
        } else if (xpathLcase.startsWith(EJB_PFX)) {
            componentType = "module";
            moduleType = "ejb";
        } else if (xpathLcase.startsWith(WEB_PFX)) {
            componentType = "module";
            moduleType = "web";
        } else if (xpathLcase.startsWith(RAR_PFX)) {
            componentType = "module";
            moduleType = "connector";
        } else if (xpathLcase.startsWith(ACC_PFX)) {
            componentType = "module";
            moduleType = "appclient";
        } else {
            return false;
        }
        String componentName = this.getResourceName(xpath);
        BaseDeployEvent theEvent = null;
        theEvent = "application".equals(componentType) ? this.findApplicationDeployEvent(componentName) : this.findModuleDeployEvent(moduleType, componentName);
        if (theEvent == null) {
            String actionCode = null;
            if (!(change instanceof ConfigUpdate)) {
                if (change instanceof ConfigAdd) {
                    actionCode = "deploy";
                } else if (change instanceof ConfigDelete) {
                    actionCode = "undeploy";
                } else {
                    String msg = localStrings.getString("admin.event.handle_add_delete_set_configchange");
                    throw new IllegalStateException(msg);
                }
            }
            if (actionCode != null) {
                theEvent = "application".equals(componentType) ? new ApplicationDeployEvent(this.instanceName, componentName, actionCode) : new ModuleDeployEvent(this.instanceName, componentName, moduleType, actionCode);
                this.cache.add(theEvent);
                processed = true;
            }
        } else {
            processed = true;
        }
        theEvent.addConfigChange(change);
        return processed;
    }

    private boolean processResourceReference(ConfigChange change, ArrayList changeList) {
        return this.processReference(change, changeList, new ResRefProcessor(this));
    }

    private boolean processApplicationReference(ConfigChange change, ArrayList changeList) {
        return this.processReference(change, changeList, new AppRefProcessor(this));
    }

    private boolean processReference(ConfigChange change, ArrayList changeList, RefProcessor processor) {
        String xpath = AdminEventCache.cleanXPath(change.getXPath());
        if (!processor.isRelevant(xpath)) {
            return false;
        }
        String refName = processor.getRefName(xpath);
        processor.initRefTypeXPathMap(refName);
        String refType = processor.getRefType(refName, changeList);
        if (refType == null) {
            return false;
        }
        return processor.process(refName, refType, change);
    }

    private void setWebCoreReconfig(ConfigChange change, ConfigChangeEvent dflt) {
        String xpath = AdminEventCache.cleanXPath(change.getXPath());
        if (this.isWebCoreXPath(xpath)) {
            dflt.setWebCoreReconfigNeeded(true);
        }
    }

    private boolean isWebCoreXPath(String xpath) {
        boolean webCoreXPath = false;
        if (xpath == null) {
            return webCoreXPath;
        }
        if ((xpath = xpath.toLowerCase()).startsWith(HTTP_SERVICE) || xpath.startsWith(WEB_CONTAINER)) {
            webCoreXPath = true;
        }
        return webCoreXPath;
    }

    public static boolean getServerXmlBooleanValue(String xmlValue) {
        boolean retval = false;
        if (xmlValue == null) {
            return retval;
        }
        if (xmlValue.equalsIgnoreCase("true") || xmlValue.equalsIgnoreCase("yes") || xmlValue.equalsIgnoreCase("on") || xmlValue.equalsIgnoreCase("1")) {
            retval = true;
        }
        return retval;
    }

    private ConfigUpdate convertToConfigUpdate(ConfigChange change) {
        ConfigUpdate update = null;
        if (change instanceof ConfigUpdate) {
            update = (ConfigUpdate)change;
        }
        return update;
    }

    public void cacheResourceChange(String resourceType, String resourceName, String actionCode) {
        if (!this.isActionValidForCache(actionCode)) {
            String msg = localStrings.getString("admin.event.invalid_action", actionCode);
            throw new IllegalArgumentException(msg);
        }
        ResourceDeployEvent resEvent = this.findResourceDeployEvent(resourceType, resourceName);
        if (resEvent == null) {
            resEvent = new ResourceDeployEvent(this.instanceName, resourceName, resourceType, actionCode);
            this.cache.add(resEvent);
        } else {
            resEvent.setNewAction(actionCode);
        }
    }

    private boolean isActionValidForCache(String deployAction) {
        boolean valid = false;
        if (deployAction != null && (deployAction.equals("deploy") || deployAction.equals("undeploy") || deployAction.equals("redeploy"))) {
            valid = true;
        }
        return valid;
    }

    public static void populateConfigChange(ConfigContext ctx, AdminEvent event) {
        if (event instanceof ApplicationDeployEvent) {
            AdminEventCache.populateApplicationConfigChange(ctx, (ApplicationDeployEvent)event);
        } else if (event instanceof ModuleDeployEvent) {
            AdminEventCache.populateModuleConfigChange(ctx, (ModuleDeployEvent)event);
        } else {
            String msg = localStrings.getString("admin.event.unsupported_populateconfigchange", event.getClass().getName());
            throw new UnsupportedOperationException(msg);
        }
    }

    private static void populateApplicationConfigChange(ConfigContext ctx, ApplicationDeployEvent event) {
        String xpath = ServerXPathHelper.getAppIdXpathExpression(event.getApplicationName());
        xpath = AdminEventCache.cleanXPath(xpath);
        event.addConfigChange(AdminEventCache.extractConfigChanges(ctx, xpath));
        String refXPath = AdminEventCache.getAppRefXPath(event.getInstanceName(), event.getApplicationName());
        event.addConfigChange(AdminEventCache.extractConfigChanges(ctx, refXPath));
    }

    private static void populateModuleConfigChange(ConfigContext ctx, ModuleDeployEvent event) {
        String moduleType = event.getModuleType();
        String moduleName = event.getModuleName();
        String xpath = null;
        if ("web".equals(moduleType)) {
            xpath = ServerXPathHelper.getWebModuleIdXpathExpression(moduleName);
        } else if ("ejb".equals(moduleType)) {
            xpath = ServerXPathHelper.getEjbModuleIdXpathExpression(moduleName);
        } else if ("connector".equals(moduleType)) {
            xpath = ServerXPathHelper.getConnectorModuleIdXpathExpression(moduleName);
        } else if ("appclient".equals(moduleType)) {
            xpath = ServerXPathHelper.getAppClientModuleIdXpathExpression(moduleName);
        } else {
            String msg = localStrings.getString("admin.event.invalid_module_type", moduleType);
            throw new IllegalArgumentException(msg);
        }
        xpath = AdminEventCache.cleanXPath(xpath);
        event.addConfigChange(AdminEventCache.extractConfigChanges(ctx, xpath));
        String refXPath = AdminEventCache.getAppRefXPath(event.getInstanceName(), moduleName);
        event.addConfigChange(AdminEventCache.extractConfigChanges(ctx, refXPath));
    }

    private static ArrayList extractConfigChanges(ConfigContext configContext, String xpath) {
        if (configContext == null) {
            String msg = localStrings.getString("admin.event.null_config_context");
            throw new IllegalArgumentException(msg);
        }
        ArrayList<ConfigChange> myChanges = new ArrayList<ConfigChange>();
        ArrayList allChanges = configContext.getConfigChangeList();
        if (allChanges == null) {
            String msg = localStrings.getString("admin.event.null_config_changes_in_configcontext");
            throw new IllegalStateException(msg);
        }
        logger.log(Level.FINE, EXTRACT_CHANGE, xpath);
        Iterator iter = allChanges.iterator();
        while (iter.hasNext()) {
            ConfigChange change = (ConfigChange)iter.next();
            logger.log(Level.FINE, PROCESS_CHANGE, change);
            String changeXPath = null;
            if (change != null) {
                changeXPath = AdminEventCache.cleanXPath(change.getXPath());
                logger.log(Level.FINEST, CONFIG_CHANGE_XPATH, changeXPath);
            }
            if (change == null || changeXPath == null) {
                logger.log(Level.FINE, CHANGE_NULL, change);
                continue;
            }
            if (!changeXPath.equals(xpath)) continue;
            myChanges.add(change);
        }
        iter = myChanges.iterator();
        while (iter.hasNext()) {
            configContext.removeConfigChange((ConfigChange)iter.next());
        }
        return myChanges;
    }

    private static String cleanXPath(String xpath) {
        if (xpath == null) {
            return xpath;
        }
        return xpath.replaceAll("/{2,}", "/");
    }

    private static boolean matchRegex(String regex, String str) {
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    private ResourceDeployEvent findResourceDeployEvent(String resType, String resName) {
        if (resType == null || resName == null) {
            String msg = localStrings.getString("admin.event.null_resource_type_or_name", resType, resName);
            throw new IllegalArgumentException(msg);
        }
        ResourceDeployEvent resEvent = null;
        Iterator iter = this.cache.iterator();
        while (iter.hasNext()) {
            AdminEvent event = (AdminEvent)iter.next();
            if (!(event instanceof ResourceDeployEvent)) continue;
            resEvent = (ResourceDeployEvent)event;
            if (resType.equals(resEvent.getResourceType()) && resName.equals(resEvent.getResourceName())) break;
            resEvent = null;
        }
        return resEvent;
    }

    private ApplicationDeployEvent findApplicationDeployEvent(String appName) {
        if (appName == null) {
            String msg = localStrings.getString("admin.event.null_application_name");
            throw new IllegalArgumentException(msg);
        }
        ApplicationDeployEvent appEvent = null;
        Iterator iter = this.cache.iterator();
        while (iter.hasNext()) {
            AdminEvent event = (AdminEvent)iter.next();
            if (!(event instanceof ApplicationDeployEvent)) continue;
            appEvent = (ApplicationDeployEvent)event;
            if (appName.equals(appEvent.getApplicationName())) break;
            appEvent = null;
        }
        return appEvent;
    }

    private ModuleDeployEvent findModuleDeployEvent(String modType, String modName) {
        if (modType == null || modName == null) {
            String msg = localStrings.getString("admin.event.null_module_type_or_name", modType, modName);
            throw new IllegalArgumentException(msg);
        }
        ModuleDeployEvent modEvent = null;
        Iterator iter = this.cache.iterator();
        while (iter.hasNext()) {
            AdminEvent event = (AdminEvent)iter.next();
            if (!(event instanceof ModuleDeployEvent)) continue;
            modEvent = (ModuleDeployEvent)event;
            if (modEvent.getModuleType().equals(modType) && modEvent.getModuleName().equals(modName)) break;
            modEvent = null;
        }
        return modEvent;
    }

    private void purgeNopEvents() {
        Iterator iter = this.cache.iterator();
        while (iter.hasNext()) {
            AdminEvent event = (AdminEvent)iter.next();
            if (!event.isNoOp()) continue;
            logger.log(Level.FINE, PURGE_NOOP, event);
            iter.remove();
        }
    }

    public void setRestartNeeded(boolean flag) {
        if (flag) {
            if (!this.restartNeeded) {
                this.setRestartNeededTrue(true);
            }
        } else {
            this.restartNeeded = false;
        }
    }

    private void setRestartNeededTrue(boolean notifyInstance) {
        this.restartNeeded = true;
        this.tsRestartNeededSince = System.currentTimeMillis();
        if (notifyInstance) {
            RMIClient channel = AdminChannel.getRMIClient(this.instanceName);
            channel.setRestartNeeded(true);
        }
    }

    public boolean isInstanceRestartNeeded() {
        RMIClient channel;
        boolean alreadyRestarted;
        if (this.restartNeeded && (alreadyRestarted = (channel = AdminChannel.getRMIClient(this.instanceName)).hasRestartedSince(this.tsRestartNeededSince))) {
            this.restartNeeded = false;
        }
        return this.restartNeeded;
    }

    class ResRefProcessor
    extends RefProcessor {
        ResRefProcessor(AdminEventCache cache) {
            super(cache);
        }

        boolean isRelevant(String xpath) {
            return this.adminEventCache.isResRefXPath(xpath);
        }

        boolean process(String refName, String refType, ConfigChange change) {
            ResourceDeployEvent event = AdminEventCache.this.findResourceDeployEvent(refType, refName);
            if (event == null) {
                String actionCode = this.getActionCode(change);
                event = new ResourceDeployEvent(this.adminEventCache.instanceName, refName, refType, actionCode);
                AdminEventCache.this.cache.add(event);
            }
            event.addConfigChange(change);
            return true;
        }

        void initRefTypeXPathMap(String refName) {
            this.refTypeXPathMap.put("custom", ServerXPathHelper.getCustomResourceIdXpath(refName));
            this.refTypeXPathMap.put("external-jndi", ServerXPathHelper.getJNDIResourceIdXpath(refName));
            this.refTypeXPathMap.put("jcp", ServerXPathHelper.getJDBCConnectionPoolIdXpath(refName));
            this.refTypeXPathMap.put("jdbc", ServerXPathHelper.getJDBCResourceIdXpath(refName));
            this.refTypeXPathMap.put("mail", ServerXPathHelper.getMailResourceIdXpath(refName));
            this.refTypeXPathMap.put("pmf", ServerXPathHelper.getPMFactoryResourceIdXpath(refName));
            this.refTypeXPathMap.put("aor", ServerXPathHelper.getAbsoluteIdXpathExpression(ServerXPathHelper.XPATH_ADMIN_OBJECT_RESOURCE, ServerTags.JNDI_NAME, refName));
            this.refTypeXPathMap.put("ccp", ServerXPathHelper.getAbsoluteIdXpathExpression(ServerXPathHelper.XPATH_CONNECTOR_CONNECTION_POOL, ServerTags.NAME, refName));
            this.refTypeXPathMap.put("cr", ServerXPathHelper.getAbsoluteIdXpathExpression(ServerXPathHelper.XPATH_CONNECTOR_RESOURCE, ServerTags.JNDI_NAME, refName));
            this.refTypeXPathMap.put("rac", ServerXPathHelper.getAbsoluteIdXpathExpression(ServerXPathHelper.XPATH_RESOURCE_ADAPTER_CONFIG, ServerTags.NAME, refName));
        }
    }

    class AppRefProcessor
    extends RefProcessor {
        AppRefProcessor(AdminEventCache cache) {
            super(cache);
        }

        boolean isRelevant(String xpath) {
            return this.adminEventCache.isAppRefXPath(xpath);
        }

        boolean process(String refName, String refType, ConfigChange change) {
            String compType = null;
            String modType = null;
            if ("application".equals(refType)) {
                compType = "application";
            } else if ("web".equals(refType) || "ejb".equals(refType) || "connector".equals(refType) || "appclient".equals(refType)) {
                compType = "module";
                modType = refType;
            } else {
                return false;
            }
            BaseDeployEvent theEvent = null;
            theEvent = "application".equals(compType) ? this.adminEventCache.findApplicationDeployEvent(refName) : this.adminEventCache.findModuleDeployEvent(modType, refName);
            if (theEvent == null) {
                String actionCode = this.getActionCode(change);
                if ("enable".equals(actionCode) || "disable".equals(actionCode) || "redeploy".equals(actionCode)) {
                    return false;
                }
                theEvent = "application".equals(compType) ? new ApplicationDeployEvent(this.adminEventCache.instanceName, refName, actionCode) : new ModuleDeployEvent(this.adminEventCache.instanceName, refName, modType, actionCode);
                AdminEventCache.this.cache.add(theEvent);
            }
            theEvent.addConfigChange(change);
            return true;
        }

        void initRefTypeXPathMap(String refName) {
            this.refTypeXPathMap.put("application", ServerXPathHelper.getAppIdXpathExpression(refName));
            this.refTypeXPathMap.put("web", ServerXPathHelper.getWebModuleIdXpathExpression(refName));
            this.refTypeXPathMap.put("ejb", ServerXPathHelper.getEjbModuleIdXpathExpression(refName));
            this.refTypeXPathMap.put("connector", ServerXPathHelper.getConnectorModuleIdXpathExpression(refName));
            this.refTypeXPathMap.put("appclient", ServerXPathHelper.getAppClientModuleIdXpathExpression(refName));
        }
    }

    abstract class RefProcessor {
        AdminEventCache adminEventCache;
        Map refTypeXPathMap = new HashMap();
        boolean resEnabled;

        RefProcessor(AdminEventCache cache) {
            this.adminEventCache = cache;
        }

        abstract boolean isRelevant(String var1);

        abstract boolean process(String var1, String var2, ConfigChange var3);

        String getRefName(String xpath) {
            return this.adminEventCache.getXPathToken(xpath, 3);
        }

        String getRefType(String refName, ArrayList allChanges) {
            String refType = this.getRefTypeFromConfig(refName);
            if (refType == null) {
                refType = this.getRefTypeFromChanges(refName, allChanges);
            }
            return refType;
        }

        String getRefTypeFromConfig(String refName) {
            ConfigContext ctx = this.adminEventCache.adminConfigContext;
            if (ctx == null) {
                return null;
            }
            String refType = null;
            Iterator iter = this.refTypeXPathMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String xpath = (String)entry.getValue();
                ConfigBean bean = null;
                try {
                    bean = ctx.exactLookup(xpath);
                }
                catch (ConfigException ce) {
                    // empty catch block
                }
                if (bean == null) continue;
                refType = (String)entry.getKey();
                this.resEnabled = this.getEnabledState(bean);
                break;
            }
            return refType;
        }

        String getRefTypeFromChanges(String refName, ArrayList allChanges) {
            if (allChanges == null) {
                return null;
            }
            String refType = null;
            Iterator iter = allChanges.iterator();
            while (iter.hasNext()) {
                ConfigChange change = (ConfigChange)iter.next();
                String xpath = AdminEventCache.cleanXPath(change.getXPath());
                Iterator iter2 = this.refTypeXPathMap.entrySet().iterator();
                while (iter2.hasNext()) {
                    Map.Entry entry = iter2.next();
                    String xpath2 = (String)entry.getValue();
                    if (xpath == null || !xpath.equals(xpath2)) continue;
                    refType = (String)entry.getKey();
                    if (change instanceof ConfigAdd) {
                        ConfigBean b = ((ConfigAdd)change).getConfigBean();
                        this.resEnabled = this.getEnabledState(b);
                        break;
                    }
                    this.resEnabled = false;
                    break;
                }
                if (refType == null) continue;
                break;
            }
            return refType;
        }

        boolean getEnabledState(ConfigBean bean) {
            String enabledStr = null;
            try {
                enabledStr = bean.getAttributeValue(ServerTags.ENABLED);
            }
            catch (IllegalArgumentException iae) {
                enabledStr = "true";
            }
            return AdminEventCache.getServerXmlBooleanValue(enabledStr);
        }

        String getActionCode(ConfigChange change) {
            String actionCode = null;
            if (change instanceof ConfigUpdate) {
                boolean enabled;
                ConfigUpdate update = (ConfigUpdate)change;
                String enableStr = update.getNewValue(ServerTags.ENABLED);
                actionCode = enableStr != null ? ((enabled = AdminEventCache.getServerXmlBooleanValue(enableStr)) && this.resEnabled ? "enable" : (enabled && !this.resEnabled ? "redeploy" : "disable")) : "redeploy";
            } else if (change instanceof ConfigAdd) {
                actionCode = "deploy";
            } else if (change instanceof ConfigDelete) {
                actionCode = "undeploy";
            } else if (change instanceof ConfigSet) {
                actionCode = "redeploy";
            } else {
                String msg = localStrings.getString("admin.event.unknown_configchange_for_resources");
                throw new IllegalStateException(msg);
            }
            return actionCode;
        }

        abstract void initRefTypeXPathMap(String var1);
    }

    class MonitoringLevelChangeProcessor
    extends LevelChangeProcessor {
        MonitoringLevelChangeProcessor(AdminEventCache cache) {
            super(cache);
        }

        boolean isRelevant(String xpath) {
            return this.eventCache.isMonitoringLevelXPath(xpath);
        }

        AdminEvent createEvent(String componentName, String oldValue, String newValue) {
            MonitoringLevelChangeEvent event = new MonitoringLevelChangeEvent(this.eventCache.instanceName);
            event.setComponentName(componentName);
            event.setOldMonitoringLevel(oldValue);
            event.setNewMonitoringLevel(newValue);
            return event;
        }
    }

    class LogLevelChangeProcessor
    extends LevelChangeProcessor {
        LogLevelChangeProcessor(AdminEventCache cache) {
            super(cache);
        }

        boolean isRelevant(String xpath) {
            return this.eventCache.isLogLevelXPath(xpath);
        }

        AdminEvent createEvent(String componentName, String oldValue, String newValue) {
            LogLevelChangeEvent event = new LogLevelChangeEvent(this.eventCache.instanceName);
            event.setModuleName(componentName);
            event.setOldLogLevel(oldValue);
            event.setNewLogLevel(newValue);
            return event;
        }
    }

    abstract class LevelChangeProcessor {
        AdminEventCache eventCache;

        LevelChangeProcessor(AdminEventCache cache) {
            this.eventCache = cache;
        }

        abstract boolean isRelevant(String var1);

        abstract AdminEvent createEvent(String var1, String var2, String var3);
    }
}

