/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.configbeans;

import com.sun.enterprise.admin.configbeans.BaseConfigBean;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;

public class ResourceReferenceHelper
extends BaseConfigBean {
    private static final TargetType[] VALID_CREATE_DELETE_TYPES = new TargetType[]{TargetType.CLUSTER, TargetType.UNCLUSTERED_SERVER, TargetType.DAS};
    private static final StringManager _strMgr = StringManager.getManager(ResourceReferenceHelper.class);

    public ResourceReferenceHelper(ConfigContext configContext) {
        super(configContext);
    }

    private String validateResourceAndGetType(String referenceName, boolean allowSystemRefs) throws ConfigException {
        String type = this.getResourceType(referenceName);
        if (!allowSystemRefs && ResourceHelper.isSystemResource(this.getConfigContext(), referenceName)) {
            throw new ConfigException(_strMgr.getString("systemResourceRefNotAllowed", referenceName));
        }
        return type;
    }

    private void addResourceReferenceToCluster(Cluster cluster, boolean enabled, String referenceName) throws ConfigException {
        ResourceRef ref = cluster.getResourceRefByRef(referenceName);
        if (ref != null) {
            throw new ConfigException(_strMgr.getString("clusterResourceRefAlreadyExists", referenceName, cluster.getName()));
        }
        ref = new ResourceRef();
        ref.setEnabled(enabled);
        ref.setRef(referenceName);
        cluster.addResourceRef(ref, true);
    }

    private void addResourceReferenceToClusteredServers(Cluster cluster, Server[] servers, boolean enabled, String referenceName) throws ConfigException {
        for (int i = 0; i < servers.length; ++i) {
            ResourceRef ref = servers[i].getResourceRefByRef(referenceName);
            if (ref != null) {
                throw new ConfigException(_strMgr.getString("clusterResourceRefInconsistency", referenceName, cluster.getName(), servers[i].getName()));
            }
            this.addResourceReferenceToServer(servers[i], enabled, referenceName);
        }
    }

    private void addResourceReferenceToServer(Server server, boolean enabled, String referenceName) throws ConfigException {
        ResourceRef ref = server.getResourceRefByRef(referenceName);
        if (ref != null) {
            throw new ConfigException(_strMgr.getString("serverResourceRefAlreadyExists", referenceName, server.getName()));
        }
        ref = new ResourceRef();
        ref.setEnabled(enabled);
        ref.setRef(referenceName);
        server.addResourceRef(ref, true);
    }

    public String getResourceType(String resourceName) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        Domain domain = ConfigAPIHelper.getDomainConfigBean(configContext);
        Resources resources = domain.getResources();
        if (resources.getAdminObjectResourceByJndiName(resourceName) != null) {
            return ServerTags.ADMIN_OBJECT_RESOURCE;
        }
        if (resources.getConnectorConnectionPoolByName(resourceName) != null) {
            return ServerTags.CONNECTOR_CONNECTION_POOL;
        }
        if (resources.getConnectorResourceByJndiName(resourceName) != null) {
            return ServerTags.CONNECTOR_RESOURCE;
        }
        if (resources.getCustomResourceByJndiName(resourceName) != null) {
            return ServerTags.CUSTOM_RESOURCE;
        }
        if (resources.getExternalJndiResourceByJndiName(resourceName) != null) {
            return ServerTags.EXTERNAL_JNDI_RESOURCE;
        }
        if (resources.getJdbcConnectionPoolByName(resourceName) != null) {
            return ServerTags.JDBC_CONNECTION_POOL;
        }
        if (resources.getJdbcResourceByJndiName(resourceName) != null) {
            return ServerTags.JDBC_RESOURCE_JNDI_NAME;
        }
        if (resources.getMailResourceByJndiName(resourceName) != null) {
            return ServerTags.MAIL_RESOURCE;
        }
        if (resources.getPersistenceManagerFactoryResourceByJndiName(resourceName) != null) {
            return ServerTags.PERSISTENCE_MANAGER_FACTORY_RESOURCE;
        }
        if (resources.getResourceAdapterConfigByResourceAdapterName(resourceName) != null) {
            return ServerTags.RESOURCE_ADAPTER_CONFIG;
        }
        throw new ConfigException(_strMgr.getString("resourceDoesNotExist", resourceName));
    }

    public void createResourceReference(String targetName, boolean enabled, String referenceName, boolean allowSystemRefs) throws ConfigException {
        this.createResourceReference(VALID_CREATE_DELETE_TYPES, targetName, enabled, referenceName, allowSystemRefs);
    }

    public void createResourceReference(String targetName, boolean enabled, String referenceName) throws ConfigException {
        this.createResourceReference(targetName, enabled, referenceName, false);
    }

    public void createResourceReference(TargetType[] validTypes, String targetName, boolean enabled, String referenceName) throws ConfigException {
        this.createResourceReference(validTypes, targetName, enabled, referenceName, false);
    }

    public void createResourceReference(TargetType[] validTypes, String targetName, boolean enabled, String referenceName, boolean allowSystemRefs) throws ConfigException {
        String type = this.validateResourceAndGetType(referenceName, allowSystemRefs);
        ConfigContext configContext = this.getConfigContext();
        Target target = TargetBuilder.INSTANCE.createTarget(validTypes, targetName, configContext);
        if (target.getType() == TargetType.CLUSTER) {
            Cluster cluster = ClusterHelper.getClusterByName(configContext, target.getName());
            this.addResourceReferenceToCluster(cluster, enabled, referenceName);
            Server[] servers = ServerHelper.getServersInCluster(configContext, target.getName());
            this.addResourceReferenceToClusteredServers(cluster, servers, enabled, referenceName);
        } else if (target.getType() == TargetType.SERVER || target.getType() == TargetType.DAS) {
            Server server = ServerHelper.getServerByName(configContext, target.getName());
            this.addResourceReferenceToServer(server, enabled, referenceName);
        } else {
            throw new ConfigException(_strMgr.getString("invalidClusterOrServerTarget", target.getName()));
        }
    }

    private void deleteResourceReferenceFromCluster(Cluster cluster, String referenceName) throws ConfigException {
        ResourceRef ref = cluster.getResourceRefByRef(referenceName);
        if (ref == null) {
            throw new ConfigException(_strMgr.getString("clusterResourceRefDoesNotExist", cluster.getName(), referenceName));
        }
        cluster.removeResourceRef(ref, true);
    }

    private void deleteResourceReferenceFromClusteredServers(Cluster cluster, Server[] servers, String referenceName) throws ConfigException {
        for (int i = 0; i < servers.length; ++i) {
            ResourceRef ref = servers[i].getResourceRefByRef(referenceName);
            if (ref == null) {
                throw new ConfigException(_strMgr.getString("clusterResourceRefInconsistency", referenceName, cluster.getName(), servers[i].getName()));
            }
            this.deleteResourceReferenceFromServer(servers[i], referenceName);
        }
    }

    private void deleteResourceReferenceFromServer(Server server, String referenceName) throws ConfigException {
        ResourceRef ref = server.getResourceRefByRef(referenceName);
        if (ref == null) {
            throw new ConfigException(_strMgr.getString("serverResourceRefDoesNotExist", server.getName(), referenceName));
        }
        server.removeResourceRef(ref, true);
    }

    public void deleteResourceReference(String targetName, String referenceName, boolean allowSystemRefs) throws ConfigException {
        this.deleteResourceReference(VALID_CREATE_DELETE_TYPES, targetName, referenceName, allowSystemRefs);
    }

    public void deleteResourceReference(String targetName, String referenceName) throws ConfigException {
        this.deleteResourceReference(targetName, referenceName, false);
    }

    public void deleteResourceReference(TargetType[] validTypes, String targetName, String referenceName) throws ConfigException {
        this.deleteResourceReference(validTypes, targetName, referenceName, false);
    }

    public void deleteResourceReference(TargetType[] validTypes, String targetName, String referenceName, boolean allowSystemRefs) throws ConfigException {
        String type = this.validateResourceAndGetType(referenceName, allowSystemRefs);
        ConfigContext configContext = this.getConfigContext();
        Target target = TargetBuilder.INSTANCE.createTarget(validTypes, targetName, configContext);
        if (target.getType() == TargetType.SERVER || target.getType() == TargetType.DAS) {
            Server server = ServerHelper.getServerByName(configContext, target.getName());
            this.deleteResourceReferenceFromServer(server, referenceName);
        } else if (target.getType().equals(TargetType.CLUSTER)) {
            Cluster cluster = ClusterHelper.getClusterByName(configContext, target.getName());
            this.deleteResourceReferenceFromCluster(cluster, referenceName);
            Server[] servers = ServerHelper.getServersInCluster(configContext, target.getName());
            this.deleteResourceReferenceFromClusteredServers(cluster, servers, referenceName);
        } else {
            throw new ConfigException(_strMgr.getString("invalidClusterOrServerTarget", target.getName()));
        }
    }
}

